/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.api;

import java.nio.file.Path;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import zeenea.connector.commons.api.CantGuessStoreTypeException;

final class StoreHelper {
    StoreHelper() {
    }

    @NotNull
    public static String storeTypeFromExtension(@NotNull Path storePath) {
        String name;
        int index;
        Path fileName = storePath.getFileName();
        if (fileName != null && (index = (name = fileName.toString()).lastIndexOf(46)) >= 0) {
            String extension;
            switch (extension = name.substring(index + 1).toLowerCase(Locale.ROOT)) {
                case "pfx": 
                case "p12": 
                case "pkcs12": {
                    return "PKCS12";
                }
                case "jks": {
                    return "JKS";
                }
            }
        }
        throw new CantGuessStoreTypeException("keystore_config_cannot_guess_store_type " + String.valueOf(storePath));
    }
}

