package zeenea.connector.bluetelligence.client.mapper;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.processing.Generated;
import zeenea.connector.bluetelligence.client.BuildupNode;
import zeenea.connector.bluetelligence.client.Description;
import zeenea.connector.bluetelligence.client.Entity;
import zeenea.connector.bluetelligence.client.xml.EntityXmlFile;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2025-10-02T11:42:42+0000",
    comments = "version: 1.6.3, compiler: IncrementalProcessingEnvironment from gradle-language-java-8.13.jar, environment: Java 11.0.28 (Eclipse Adoptium)"
)
public class EntityMapperImpl implements EntityMapper {

    private final DescriptionMapper descriptionMapper = DescriptionMapper.INSTANCE;

    @Override
    public List<Entity> mapToEntity(List<EntityXmlFile> entityXmlFiles) {
        if ( entityXmlFiles == null ) {
            return new ArrayList<Entity>();
        }

        List<Entity> list = new ArrayList<Entity>( entityXmlFiles.size() );
        for ( EntityXmlFile entityXmlFile : entityXmlFiles ) {
            list.add( mapToSingleEntity( entityXmlFile ) );
        }

        return list;
    }

    @Override
    public Entity mapToSingleEntity(EntityXmlFile entityXmlFile) {
        if ( entityXmlFile == null ) {
            return null;
        }

        List<Description> descriptions = null;
        String label = null;
        String id = null;
        String infoArea = null;
        String space = null;
        String system = null;
        String technicalName = null;
        String type = null;
        String uid = null;

        descriptions = descriptionMapper.mapToDescription( entityXmlFile.getDescriptions() );
        label = entityXmlFile.getLabel();
        id = entityXmlFile.getId();
        infoArea = entityXmlFile.getInfoArea();
        space = entityXmlFile.getSpace();
        system = entityXmlFile.getSystem();
        technicalName = entityXmlFile.getTechnicalName();
        type = entityXmlFile.getType();
        uid = entityXmlFile.getUid();

        List<BuildupNode> fields = null;
        List<String> sourceEntityIds = null;
        List<String> targetEntityIds = null;

        Entity entity = new Entity( label, id, infoArea, space, system, technicalName, type, uid, fields, sourceEntityIds, targetEntityIds, descriptions );

        return entity;
    }
}
