package zeenea.connector.azure.synapse.data.client.management;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.NotNull;

/**
 * Immutable implementation of {@link Subscription}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSubscription.builder()}.
 */
@Generated(from = "Subscription", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableSubscription
    implements Subscription {
  @NotNull
  private final String name;
  @NotNull
  private final String id;

  private ImmutableSubscription(String name, String id) {
    this.name = name;
    this.id = id;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("displayName")
  @NotNull
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("subscriptionId")
  @NotNull
  @Override
  public String getId() {
    return id;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Subscription#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSubscription withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableSubscription(newValue, this.id);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Subscription#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSubscription withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableSubscription(this.name, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSubscription} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSubscription
        && equalTo(0, (ImmutableSubscription) another);
  }

  private boolean equalTo(int synthetic, ImmutableSubscription another) {
    return name.equals(another.name)
        && id.equals(another.id);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code id}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + id.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Subscription} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Subscription{"
        + "name=" + name
        + ", id=" + id
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link Subscription} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Subscription instance
   */
  public static ImmutableSubscription copyOf(Subscription instance) {
    if (instance instanceof ImmutableSubscription) {
      return (ImmutableSubscription) instance;
    }
    return ImmutableSubscription.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSubscription ImmutableSubscription}.
   * <pre>
   * ImmutableSubscription.builder()
   *    .name(String) // required {@link Subscription#getName() name}
   *    .id(String) // required {@link Subscription#getId() id}
   *    .build();
   * </pre>
   * @return A new ImmutableSubscription builder
   */
  public static ImmutableSubscription.Builder builder() {
    return new ImmutableSubscription.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSubscription ImmutableSubscription}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Subscription", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_ID = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String name;
    private @Nullable String id;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Subscription} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Subscription instance) {
      Objects.requireNonNull(instance, "instance");
      this.name(instance.getName());
      this.id(instance.getId());
      return this;
    }

    /**
     * Initializes the value for the {@link Subscription#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("displayName")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link Subscription#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("subscriptionId")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Builds a new {@link ImmutableSubscription ImmutableSubscription}.
     * @return An immutable instance of Subscription
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSubscription build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableSubscription(name, id);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      return "Cannot build Subscription, some of required attributes are not set " + attributes;
    }
  }
}
