package zeenea.connector.azure.synapse.data.client.management;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.NotNull;

/**
 * Immutable implementation of {@link Properties}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableProperties.builder()}.
 */
@Generated(from = "Properties", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableProperties
    implements Properties {
  @NotNull
  private final String workspaceId;

  private ImmutableProperties(String workspaceId) {
    this.workspaceId = workspaceId;
  }

  /**
   * @return The value of the {@code workspaceId} attribute
   */
  @JsonProperty("workspaceUID")
  @NotNull
  @Override
  public String getWorkspaceId() {
    return workspaceId;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Properties#getWorkspaceId() workspaceId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for workspaceId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProperties withWorkspaceId(String value) {
    String newValue = Objects.requireNonNull(value, "workspaceId");
    if (this.workspaceId.equals(newValue)) return this;
    return new ImmutableProperties(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableProperties} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableProperties
        && equalTo(0, (ImmutableProperties) another);
  }

  private boolean equalTo(int synthetic, ImmutableProperties another) {
    return workspaceId.equals(another.workspaceId);
  }

  /**
   * Computes a hash code from attributes: {@code workspaceId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + workspaceId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Properties} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Properties{"
        + "workspaceId=" + workspaceId
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link Properties} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Properties instance
   */
  public static ImmutableProperties copyOf(Properties instance) {
    if (instance instanceof ImmutableProperties) {
      return (ImmutableProperties) instance;
    }
    return ImmutableProperties.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableProperties ImmutableProperties}.
   * <pre>
   * ImmutableProperties.builder()
   *    .workspaceId(String) // required {@link Properties#getWorkspaceId() workspaceId}
   *    .build();
   * </pre>
   * @return A new ImmutableProperties builder
   */
  public static ImmutableProperties.Builder builder() {
    return new ImmutableProperties.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableProperties ImmutableProperties}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Properties", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_WORKSPACE_ID = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String workspaceId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Properties} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Properties instance) {
      Objects.requireNonNull(instance, "instance");
      this.workspaceId(instance.getWorkspaceId());
      return this;
    }

    /**
     * Initializes the value for the {@link Properties#getWorkspaceId() workspaceId} attribute.
     * @param workspaceId The value for workspaceId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("workspaceUID")
    public final Builder workspaceId(String workspaceId) {
      this.workspaceId = Objects.requireNonNull(workspaceId, "workspaceId");
      initBits &= ~INIT_BIT_WORKSPACE_ID;
      return this;
    }

    /**
     * Builds a new {@link ImmutableProperties ImmutableProperties}.
     * @return An immutable instance of Properties
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableProperties build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableProperties(workspaceId);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_WORKSPACE_ID) != 0) attributes.add("workspaceId");
      return "Cannot build Properties, some of required attributes are not set " + attributes;
    }
  }
}
