package zeenea.connector.azure.synapse.data.client.management;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.NotNull;

/**
 * Immutable implementation of {@link GetWorkspacesResponse}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableGetWorkspacesResponse.builder()}.
 */
@Generated(from = "GetWorkspacesResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableGetWorkspacesResponse
    implements GetWorkspacesResponse {
  @NotNull
  private final List<Workspace> workspaces;

  private ImmutableGetWorkspacesResponse(List<Workspace> workspaces) {
    this.workspaces = workspaces;
  }

  /**
   * @return The value of the {@code workspaces} attribute
   */
  @JsonProperty("value")
  @NotNull
  @Override
  public List<Workspace> getWorkspaces() {
    return workspaces;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link GetWorkspacesResponse#getWorkspaces() workspaces}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableGetWorkspacesResponse withWorkspaces(Workspace... elements) {
    List<Workspace> newValue = List.of(elements);
    return new ImmutableGetWorkspacesResponse(newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link GetWorkspacesResponse#getWorkspaces() workspaces}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of workspaces elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableGetWorkspacesResponse withWorkspaces(Iterable<? extends Workspace> elements) {
    if (this.workspaces == elements) return this;
    List<Workspace> newValue = elements instanceof Collection<?>
        ? List.copyOf((Collection<? extends Workspace>) elements)
        : StreamSupport.stream(elements.spliterator(), false)
            .collect(Collectors.toUnmodifiableList());
    return new ImmutableGetWorkspacesResponse(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableGetWorkspacesResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableGetWorkspacesResponse
        && equalTo(0, (ImmutableGetWorkspacesResponse) another);
  }

  private boolean equalTo(int synthetic, ImmutableGetWorkspacesResponse another) {
    return workspaces.equals(another.workspaces);
  }

  /**
   * Computes a hash code from attributes: {@code workspaces}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + workspaces.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GetWorkspacesResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetWorkspacesResponse{"
        + "workspaces=" + workspaces
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link GetWorkspacesResponse} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable GetWorkspacesResponse instance
   */
  public static ImmutableGetWorkspacesResponse copyOf(GetWorkspacesResponse instance) {
    if (instance instanceof ImmutableGetWorkspacesResponse) {
      return (ImmutableGetWorkspacesResponse) instance;
    }
    return ImmutableGetWorkspacesResponse.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableGetWorkspacesResponse ImmutableGetWorkspacesResponse}.
   * <pre>
   * ImmutableGetWorkspacesResponse.builder()
   *    .addWorkspaces|addAllWorkspaces(zeenea.connector.azure.synapse.data.client.management.Workspace) // {@link GetWorkspacesResponse#getWorkspaces() workspaces} elements
   *    .build();
   * </pre>
   * @return A new ImmutableGetWorkspacesResponse builder
   */
  public static ImmutableGetWorkspacesResponse.Builder builder() {
    return new ImmutableGetWorkspacesResponse.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableGetWorkspacesResponse ImmutableGetWorkspacesResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "GetWorkspacesResponse", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private List<Workspace> workspaces = new ArrayList<Workspace>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetWorkspacesResponse} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(GetWorkspacesResponse instance) {
      Objects.requireNonNull(instance, "instance");
      addAllWorkspaces(instance.getWorkspaces());
      return this;
    }

    /**
     * Adds one element to {@link GetWorkspacesResponse#getWorkspaces() workspaces} list.
     * @param element A workspaces element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addWorkspaces(Workspace element) {
      this.workspaces.add(Objects.requireNonNull(element, "workspaces element"));
      return this;
    }

    /**
     * Adds elements to {@link GetWorkspacesResponse#getWorkspaces() workspaces} list.
     * @param elements An array of workspaces elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addWorkspaces(Workspace... elements) {
      for (Workspace element : elements) {
        this.workspaces.add(Objects.requireNonNull(element, "workspaces element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link GetWorkspacesResponse#getWorkspaces() workspaces} list.
     * @param elements An iterable of workspaces elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("value")
    public final Builder workspaces(Iterable<? extends Workspace> elements) {
      this.workspaces.clear();
      return addAllWorkspaces(elements);
    }

    /**
     * Adds elements to {@link GetWorkspacesResponse#getWorkspaces() workspaces} list.
     * @param elements An iterable of workspaces elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllWorkspaces(Iterable<? extends Workspace> elements) {
      for (Workspace element : elements) {
        this.workspaces.add(Objects.requireNonNull(element, "workspaces element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableGetWorkspacesResponse ImmutableGetWorkspacesResponse}.
     * @return An immutable instance of GetWorkspacesResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableGetWorkspacesResponse build() {
      return new ImmutableGetWorkspacesResponse(List.copyOf(workspaces));
    }
  }
}
