package zeenea.connector.azure.synapse.data.client.management;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.NotNull;

/**
 * Immutable implementation of {@link GetSubscriptionsResponse}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableGetSubscriptionsResponse.builder()}.
 */
@Generated(from = "GetSubscriptionsResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableGetSubscriptionsResponse
    implements GetSubscriptionsResponse {
  @NotNull
  private final List<Subscription> subscription;

  private ImmutableGetSubscriptionsResponse(List<Subscription> subscription) {
    this.subscription = subscription;
  }

  /**
   * @return The value of the {@code subscription} attribute
   */
  @JsonProperty("value")
  @NotNull
  @Override
  public List<Subscription> getSubscription() {
    return subscription;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link GetSubscriptionsResponse#getSubscription() subscription}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableGetSubscriptionsResponse withSubscription(Subscription... elements) {
    List<Subscription> newValue = List.of(elements);
    return new ImmutableGetSubscriptionsResponse(newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link GetSubscriptionsResponse#getSubscription() subscription}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of subscription elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableGetSubscriptionsResponse withSubscription(Iterable<? extends Subscription> elements) {
    if (this.subscription == elements) return this;
    List<Subscription> newValue = elements instanceof Collection<?>
        ? List.copyOf((Collection<? extends Subscription>) elements)
        : StreamSupport.stream(elements.spliterator(), false)
            .collect(Collectors.toUnmodifiableList());
    return new ImmutableGetSubscriptionsResponse(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableGetSubscriptionsResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableGetSubscriptionsResponse
        && equalTo(0, (ImmutableGetSubscriptionsResponse) another);
  }

  private boolean equalTo(int synthetic, ImmutableGetSubscriptionsResponse another) {
    return subscription.equals(another.subscription);
  }

  /**
   * Computes a hash code from attributes: {@code subscription}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + subscription.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GetSubscriptionsResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetSubscriptionsResponse{"
        + "subscription=" + subscription
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link GetSubscriptionsResponse} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable GetSubscriptionsResponse instance
   */
  public static ImmutableGetSubscriptionsResponse copyOf(GetSubscriptionsResponse instance) {
    if (instance instanceof ImmutableGetSubscriptionsResponse) {
      return (ImmutableGetSubscriptionsResponse) instance;
    }
    return ImmutableGetSubscriptionsResponse.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableGetSubscriptionsResponse ImmutableGetSubscriptionsResponse}.
   * <pre>
   * ImmutableGetSubscriptionsResponse.builder()
   *    .addSubscription|addAllSubscription(zeenea.connector.azure.synapse.data.client.management.Subscription) // {@link GetSubscriptionsResponse#getSubscription() subscription} elements
   *    .build();
   * </pre>
   * @return A new ImmutableGetSubscriptionsResponse builder
   */
  public static ImmutableGetSubscriptionsResponse.Builder builder() {
    return new ImmutableGetSubscriptionsResponse.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableGetSubscriptionsResponse ImmutableGetSubscriptionsResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "GetSubscriptionsResponse", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private List<Subscription> subscription = new ArrayList<Subscription>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetSubscriptionsResponse} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(GetSubscriptionsResponse instance) {
      Objects.requireNonNull(instance, "instance");
      addAllSubscription(instance.getSubscription());
      return this;
    }

    /**
     * Adds one element to {@link GetSubscriptionsResponse#getSubscription() subscription} list.
     * @param element A subscription element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addSubscription(Subscription element) {
      this.subscription.add(Objects.requireNonNull(element, "subscription element"));
      return this;
    }

    /**
     * Adds elements to {@link GetSubscriptionsResponse#getSubscription() subscription} list.
     * @param elements An array of subscription elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addSubscription(Subscription... elements) {
      for (Subscription element : elements) {
        this.subscription.add(Objects.requireNonNull(element, "subscription element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link GetSubscriptionsResponse#getSubscription() subscription} list.
     * @param elements An iterable of subscription elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("value")
    public final Builder subscription(Iterable<? extends Subscription> elements) {
      this.subscription.clear();
      return addAllSubscription(elements);
    }

    /**
     * Adds elements to {@link GetSubscriptionsResponse#getSubscription() subscription} list.
     * @param elements An iterable of subscription elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllSubscription(Iterable<? extends Subscription> elements) {
      for (Subscription element : elements) {
        this.subscription.add(Objects.requireNonNull(element, "subscription element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableGetSubscriptionsResponse ImmutableGetSubscriptionsResponse}.
     * @return An immutable instance of GetSubscriptionsResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableGetSubscriptionsResponse build() {
      return new ImmutableGetSubscriptionsResponse(List.copyOf(subscription));
    }
  }
}
