package zeenea.connector.azure.synapse.data.client.data;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link TableProperties}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableTableProperties.builder()}.
 */
@Generated(from = "TableProperties", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableTableProperties
    implements TableProperties {
  private final String primaryKeys;
  private final String description;

  private ImmutableTableProperties(String primaryKeys, String description) {
    this.primaryKeys = primaryKeys;
    this.description = description;
  }

  /**
   * @return The value of the {@code primaryKeys} attribute
   */
  @JsonProperty("PrimaryKeys")
  @Override
  public String getPrimaryKeys() {
    return primaryKeys;
  }

  /**
   * @return The value of the {@code description} attribute
   */
  @JsonProperty("Description")
  @Override
  public String getDescription() {
    return description;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TableProperties#getPrimaryKeys() primaryKeys} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for primaryKeys
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTableProperties withPrimaryKeys(String value) {
    String newValue = Objects.requireNonNull(value, "primaryKeys");
    if (this.primaryKeys.equals(newValue)) return this;
    return new ImmutableTableProperties(newValue, this.description);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TableProperties#getDescription() description} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for description
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTableProperties withDescription(String value) {
    String newValue = Objects.requireNonNull(value, "description");
    if (this.description.equals(newValue)) return this;
    return new ImmutableTableProperties(this.primaryKeys, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableTableProperties} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableTableProperties
        && equalTo(0, (ImmutableTableProperties) another);
  }

  private boolean equalTo(int synthetic, ImmutableTableProperties another) {
    return primaryKeys.equals(another.primaryKeys)
        && description.equals(another.description);
  }

  /**
   * Computes a hash code from attributes: {@code primaryKeys}, {@code description}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + primaryKeys.hashCode();
    h += (h << 5) + description.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code TableProperties} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "TableProperties{"
        + "primaryKeys=" + primaryKeys
        + ", description=" + description
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link TableProperties} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable TableProperties instance
   */
  public static ImmutableTableProperties copyOf(TableProperties instance) {
    if (instance instanceof ImmutableTableProperties) {
      return (ImmutableTableProperties) instance;
    }
    return ImmutableTableProperties.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableTableProperties ImmutableTableProperties}.
   * <pre>
   * ImmutableTableProperties.builder()
   *    .primaryKeys(String) // required {@link TableProperties#getPrimaryKeys() primaryKeys}
   *    .description(String) // required {@link TableProperties#getDescription() description}
   *    .build();
   * </pre>
   * @return A new ImmutableTableProperties builder
   */
  public static ImmutableTableProperties.Builder builder() {
    return new ImmutableTableProperties.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableTableProperties ImmutableTableProperties}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "TableProperties", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_PRIMARY_KEYS = 0x1L;
    private static final long INIT_BIT_DESCRIPTION = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String primaryKeys;
    private @Nullable String description;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code TableProperties} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(TableProperties instance) {
      Objects.requireNonNull(instance, "instance");
      this.primaryKeys(instance.getPrimaryKeys());
      this.description(instance.getDescription());
      return this;
    }

    /**
     * Initializes the value for the {@link TableProperties#getPrimaryKeys() primaryKeys} attribute.
     * @param primaryKeys The value for primaryKeys 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("PrimaryKeys")
    public final Builder primaryKeys(String primaryKeys) {
      this.primaryKeys = Objects.requireNonNull(primaryKeys, "primaryKeys");
      initBits &= ~INIT_BIT_PRIMARY_KEYS;
      return this;
    }

    /**
     * Initializes the value for the {@link TableProperties#getDescription() description} attribute.
     * @param description The value for description 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Description")
    public final Builder description(String description) {
      this.description = Objects.requireNonNull(description, "description");
      initBits &= ~INIT_BIT_DESCRIPTION;
      return this;
    }

    /**
     * Builds a new {@link ImmutableTableProperties ImmutableTableProperties}.
     * @return An immutable instance of TableProperties
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableTableProperties build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableTableProperties(primaryKeys, description);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_PRIMARY_KEYS) != 0) attributes.add("primaryKeys");
      if ((initBits & INIT_BIT_DESCRIPTION) != 0) attributes.add("description");
      return "Cannot build TableProperties, some of required attributes are not set " + attributes;
    }
  }
}
