package zeenea.connector.azure.synapse.data.client.data;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Table}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableTable.builder()}.
 */
@Generated(from = "Table", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableTable implements Table {
  private final String name;
  private final Properties properties;

  private ImmutableTable(String name, Properties properties) {
    this.name = name;
    this.properties = properties;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code properties} attribute
   */
  @JsonProperty("properties")
  @Override
  public Properties getProperties() {
    return properties;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Table#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTable withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableTable(newValue, this.properties);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Table#getProperties() properties} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for properties
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTable withProperties(Properties value) {
    if (this.properties == value) return this;
    Properties newValue = Objects.requireNonNull(value, "properties");
    return new ImmutableTable(this.name, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableTable} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableTable
        && equalTo(0, (ImmutableTable) another);
  }

  private boolean equalTo(int synthetic, ImmutableTable another) {
    return name.equals(another.name)
        && properties.equals(another.properties);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code properties}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + properties.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Table} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Table{"
        + "name=" + name
        + ", properties=" + properties
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link Table} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Table instance
   */
  public static ImmutableTable copyOf(Table instance) {
    if (instance instanceof ImmutableTable) {
      return (ImmutableTable) instance;
    }
    return ImmutableTable.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableTable ImmutableTable}.
   * <pre>
   * ImmutableTable.builder()
   *    .name(String) // required {@link Table#getName() name}
   *    .properties(zeenea.connector.azure.synapse.data.client.data.Properties) // required {@link Table#getProperties() properties}
   *    .build();
   * </pre>
   * @return A new ImmutableTable builder
   */
  public static ImmutableTable.Builder builder() {
    return new ImmutableTable.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableTable ImmutableTable}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Table", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_PROPERTIES = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String name;
    private @Nullable Properties properties;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Table} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Table instance) {
      Objects.requireNonNull(instance, "instance");
      this.name(instance.getName());
      this.properties(instance.getProperties());
      return this;
    }

    /**
     * Initializes the value for the {@link Table#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link Table#getProperties() properties} attribute.
     * @param properties The value for properties 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("properties")
    public final Builder properties(Properties properties) {
      this.properties = Objects.requireNonNull(properties, "properties");
      initBits &= ~INIT_BIT_PROPERTIES;
      return this;
    }

    /**
     * Builds a new {@link ImmutableTable ImmutableTable}.
     * @return An immutable instance of Table
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableTable build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableTable(name, properties);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_PROPERTIES) != 0) attributes.add("properties");
      return "Cannot build Table, some of required attributes are not set " + attributes;
    }
  }
}
