package zeenea.connector.azure.synapse.data.client.data;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.NotNull;

/**
 * Immutable implementation of {@link StorageDescriptor}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableStorageDescriptor.builder()}.
 */
@Generated(from = "StorageDescriptor", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableStorageDescriptor
    implements StorageDescriptor {
  @NotNull
  private final List<Column> columns;
  private final Format format;
  private final Source source;

  private ImmutableStorageDescriptor(
      List<Column> columns,
      Format format,
      Source source) {
    this.columns = columns;
    this.format = format;
    this.source = source;
  }

  /**
   * @return The value of the {@code columns} attribute
   */
  @JsonProperty("Columns")
  @NotNull
  @Override
  public List<Column> getColumns() {
    return columns;
  }

  /**
   * @return The value of the {@code format} attribute
   */
  @JsonProperty("Format")
  @Override
  public Format getFormat() {
    return format;
  }

  /**
   * @return The value of the {@code source} attribute
   */
  @JsonProperty("Source")
  @Override
  public Source getSource() {
    return source;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link StorageDescriptor#getColumns() columns}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableStorageDescriptor withColumns(Column... elements) {
    List<Column> newValue = List.of(elements);
    return new ImmutableStorageDescriptor(newValue, this.format, this.source);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link StorageDescriptor#getColumns() columns}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of columns elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableStorageDescriptor withColumns(Iterable<? extends Column> elements) {
    if (this.columns == elements) return this;
    List<Column> newValue = elements instanceof Collection<?>
        ? List.copyOf((Collection<? extends Column>) elements)
        : StreamSupport.stream(elements.spliterator(), false)
            .collect(Collectors.toUnmodifiableList());
    return new ImmutableStorageDescriptor(newValue, this.format, this.source);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StorageDescriptor#getFormat() format} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for format
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStorageDescriptor withFormat(Format value) {
    if (this.format == value) return this;
    Format newValue = Objects.requireNonNull(value, "format");
    return new ImmutableStorageDescriptor(this.columns, newValue, this.source);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StorageDescriptor#getSource() source} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for source
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStorageDescriptor withSource(Source value) {
    if (this.source == value) return this;
    Source newValue = Objects.requireNonNull(value, "source");
    return new ImmutableStorageDescriptor(this.columns, this.format, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableStorageDescriptor} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableStorageDescriptor
        && equalTo(0, (ImmutableStorageDescriptor) another);
  }

  private boolean equalTo(int synthetic, ImmutableStorageDescriptor another) {
    return columns.equals(another.columns)
        && format.equals(another.format)
        && source.equals(another.source);
  }

  /**
   * Computes a hash code from attributes: {@code columns}, {@code format}, {@code source}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + columns.hashCode();
    h += (h << 5) + format.hashCode();
    h += (h << 5) + source.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code StorageDescriptor} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "StorageDescriptor{"
        + "columns=" + columns
        + ", format=" + format
        + ", source=" + source
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link StorageDescriptor} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable StorageDescriptor instance
   */
  public static ImmutableStorageDescriptor copyOf(StorageDescriptor instance) {
    if (instance instanceof ImmutableStorageDescriptor) {
      return (ImmutableStorageDescriptor) instance;
    }
    return ImmutableStorageDescriptor.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableStorageDescriptor ImmutableStorageDescriptor}.
   * <pre>
   * ImmutableStorageDescriptor.builder()
   *    .addColumns|addAllColumns(zeenea.connector.azure.synapse.data.client.data.Column) // {@link StorageDescriptor#getColumns() columns} elements
   *    .format(zeenea.connector.azure.synapse.data.client.data.Format) // required {@link StorageDescriptor#getFormat() format}
   *    .source(zeenea.connector.azure.synapse.data.client.data.Source) // required {@link StorageDescriptor#getSource() source}
   *    .build();
   * </pre>
   * @return A new ImmutableStorageDescriptor builder
   */
  public static ImmutableStorageDescriptor.Builder builder() {
    return new ImmutableStorageDescriptor.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableStorageDescriptor ImmutableStorageDescriptor}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "StorageDescriptor", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_FORMAT = 0x1L;
    private static final long INIT_BIT_SOURCE = 0x2L;
    private long initBits = 0x3L;

    private List<Column> columns = new ArrayList<Column>();
    private @Nullable Format format;
    private @Nullable Source source;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code StorageDescriptor} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(StorageDescriptor instance) {
      Objects.requireNonNull(instance, "instance");
      addAllColumns(instance.getColumns());
      this.format(instance.getFormat());
      this.source(instance.getSource());
      return this;
    }

    /**
     * Adds one element to {@link StorageDescriptor#getColumns() columns} list.
     * @param element A columns element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addColumns(Column element) {
      this.columns.add(Objects.requireNonNull(element, "columns element"));
      return this;
    }

    /**
     * Adds elements to {@link StorageDescriptor#getColumns() columns} list.
     * @param elements An array of columns elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addColumns(Column... elements) {
      for (Column element : elements) {
        this.columns.add(Objects.requireNonNull(element, "columns element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link StorageDescriptor#getColumns() columns} list.
     * @param elements An iterable of columns elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Columns")
    public final Builder columns(Iterable<? extends Column> elements) {
      this.columns.clear();
      return addAllColumns(elements);
    }

    /**
     * Adds elements to {@link StorageDescriptor#getColumns() columns} list.
     * @param elements An iterable of columns elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllColumns(Iterable<? extends Column> elements) {
      for (Column element : elements) {
        this.columns.add(Objects.requireNonNull(element, "columns element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link StorageDescriptor#getFormat() format} attribute.
     * @param format The value for format 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Format")
    public final Builder format(Format format) {
      this.format = Objects.requireNonNull(format, "format");
      initBits &= ~INIT_BIT_FORMAT;
      return this;
    }

    /**
     * Initializes the value for the {@link StorageDescriptor#getSource() source} attribute.
     * @param source The value for source 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Source")
    public final Builder source(Source source) {
      this.source = Objects.requireNonNull(source, "source");
      initBits &= ~INIT_BIT_SOURCE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableStorageDescriptor ImmutableStorageDescriptor}.
     * @return An immutable instance of StorageDescriptor
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableStorageDescriptor build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableStorageDescriptor(List.copyOf(columns), format, source);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_FORMAT) != 0) attributes.add("format");
      if ((initBits & INIT_BIT_SOURCE) != 0) attributes.add("source");
      return "Cannot build StorageDescriptor, some of required attributes are not set " + attributes;
    }
  }
}
