package zeenea.connector.azure.synapse.data.client.data;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Source}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSource.builder()}.
 */
@Generated(from = "Source", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableSource implements Source {
  private final String provider;
  private final String location;

  private ImmutableSource(String provider, String location) {
    this.provider = provider;
    this.location = location;
  }

  /**
   * @return The value of the {@code provider} attribute
   */
  @JsonProperty("Provider")
  @Override
  public String getProvider() {
    return provider;
  }

  /**
   * @return The value of the {@code location} attribute
   */
  @JsonProperty("Location")
  @Override
  public String getLocation() {
    return location;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Source#getProvider() provider} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for provider
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSource withProvider(String value) {
    String newValue = Objects.requireNonNull(value, "provider");
    if (this.provider.equals(newValue)) return this;
    return new ImmutableSource(newValue, this.location);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Source#getLocation() location} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for location
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSource withLocation(String value) {
    String newValue = Objects.requireNonNull(value, "location");
    if (this.location.equals(newValue)) return this;
    return new ImmutableSource(this.provider, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSource} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSource
        && equalTo(0, (ImmutableSource) another);
  }

  private boolean equalTo(int synthetic, ImmutableSource another) {
    return provider.equals(another.provider)
        && location.equals(another.location);
  }

  /**
   * Computes a hash code from attributes: {@code provider}, {@code location}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + provider.hashCode();
    h += (h << 5) + location.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Source} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Source{"
        + "provider=" + provider
        + ", location=" + location
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link Source} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Source instance
   */
  public static ImmutableSource copyOf(Source instance) {
    if (instance instanceof ImmutableSource) {
      return (ImmutableSource) instance;
    }
    return ImmutableSource.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSource ImmutableSource}.
   * <pre>
   * ImmutableSource.builder()
   *    .provider(String) // required {@link Source#getProvider() provider}
   *    .location(String) // required {@link Source#getLocation() location}
   *    .build();
   * </pre>
   * @return A new ImmutableSource builder
   */
  public static ImmutableSource.Builder builder() {
    return new ImmutableSource.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSource ImmutableSource}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Source", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_PROVIDER = 0x1L;
    private static final long INIT_BIT_LOCATION = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String provider;
    private @Nullable String location;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Source} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Source instance) {
      Objects.requireNonNull(instance, "instance");
      this.provider(instance.getProvider());
      this.location(instance.getLocation());
      return this;
    }

    /**
     * Initializes the value for the {@link Source#getProvider() provider} attribute.
     * @param provider The value for provider 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Provider")
    public final Builder provider(String provider) {
      this.provider = Objects.requireNonNull(provider, "provider");
      initBits &= ~INIT_BIT_PROVIDER;
      return this;
    }

    /**
     * Initializes the value for the {@link Source#getLocation() location} attribute.
     * @param location The value for location 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Location")
    public final Builder location(String location) {
      this.location = Objects.requireNonNull(location, "location");
      initBits &= ~INIT_BIT_LOCATION;
      return this;
    }

    /**
     * Builds a new {@link ImmutableSource ImmutableSource}.
     * @return An immutable instance of Source
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSource build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableSource(provider, location);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_PROVIDER) != 0) attributes.add("provider");
      if ((initBits & INIT_BIT_LOCATION) != 0) attributes.add("location");
      return "Cannot build Source, some of required attributes are not set " + attributes;
    }
  }
}
