package zeenea.connector.azure.synapse.data.client.data;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link RelationProperties}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableRelationProperties.builder()}.
 */
@Generated(from = "RelationProperties", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableRelationProperties
    implements RelationProperties {
  private final String fromTable;
  private final String toTable;
  private final List<RelationColumnProperties> columnsProperties;

  private ImmutableRelationProperties(
      String fromTable,
      String toTable,
      List<RelationColumnProperties> columnsProperties) {
    this.fromTable = fromTable;
    this.toTable = toTable;
    this.columnsProperties = columnsProperties;
  }

  /**
   * @return The value of the {@code fromTable} attribute
   */
  @JsonProperty("FromTableName")
  @Override
  public String getFromTable() {
    return fromTable;
  }

  /**
   * @return The value of the {@code toTable} attribute
   */
  @JsonProperty("ToTableName")
  @Override
  public String getToTable() {
    return toTable;
  }

  /**
   * @return The value of the {@code columnsProperties} attribute
   */
  @JsonProperty("ColumnRelationshipInformations")
  @Override
  public List<RelationColumnProperties> getColumnsProperties() {
    return columnsProperties;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RelationProperties#getFromTable() fromTable} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for fromTable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRelationProperties withFromTable(String value) {
    String newValue = Objects.requireNonNull(value, "fromTable");
    if (this.fromTable.equals(newValue)) return this;
    return new ImmutableRelationProperties(newValue, this.toTable, this.columnsProperties);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RelationProperties#getToTable() toTable} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for toTable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRelationProperties withToTable(String value) {
    String newValue = Objects.requireNonNull(value, "toTable");
    if (this.toTable.equals(newValue)) return this;
    return new ImmutableRelationProperties(this.fromTable, newValue, this.columnsProperties);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link RelationProperties#getColumnsProperties() columnsProperties}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRelationProperties withColumnsProperties(RelationColumnProperties... elements) {
    List<RelationColumnProperties> newValue = List.of(elements);
    return new ImmutableRelationProperties(this.fromTable, this.toTable, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link RelationProperties#getColumnsProperties() columnsProperties}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of columnsProperties elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRelationProperties withColumnsProperties(Iterable<? extends RelationColumnProperties> elements) {
    if (this.columnsProperties == elements) return this;
    List<RelationColumnProperties> newValue = elements instanceof Collection<?>
        ? List.copyOf((Collection<? extends RelationColumnProperties>) elements)
        : StreamSupport.stream(elements.spliterator(), false)
            .collect(Collectors.toUnmodifiableList());
    return new ImmutableRelationProperties(this.fromTable, this.toTable, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableRelationProperties} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableRelationProperties
        && equalTo(0, (ImmutableRelationProperties) another);
  }

  private boolean equalTo(int synthetic, ImmutableRelationProperties another) {
    return fromTable.equals(another.fromTable)
        && toTable.equals(another.toTable)
        && columnsProperties.equals(another.columnsProperties);
  }

  /**
   * Computes a hash code from attributes: {@code fromTable}, {@code toTable}, {@code columnsProperties}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + fromTable.hashCode();
    h += (h << 5) + toTable.hashCode();
    h += (h << 5) + columnsProperties.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code RelationProperties} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "RelationProperties{"
        + "fromTable=" + fromTable
        + ", toTable=" + toTable
        + ", columnsProperties=" + columnsProperties
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link RelationProperties} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable RelationProperties instance
   */
  public static ImmutableRelationProperties copyOf(RelationProperties instance) {
    if (instance instanceof ImmutableRelationProperties) {
      return (ImmutableRelationProperties) instance;
    }
    return ImmutableRelationProperties.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableRelationProperties ImmutableRelationProperties}.
   * <pre>
   * ImmutableRelationProperties.builder()
   *    .fromTable(String) // required {@link RelationProperties#getFromTable() fromTable}
   *    .toTable(String) // required {@link RelationProperties#getToTable() toTable}
   *    .addColumnsProperties|addAllColumnsProperties(zeenea.connector.azure.synapse.data.client.data.RelationColumnProperties) // {@link RelationProperties#getColumnsProperties() columnsProperties} elements
   *    .build();
   * </pre>
   * @return A new ImmutableRelationProperties builder
   */
  public static ImmutableRelationProperties.Builder builder() {
    return new ImmutableRelationProperties.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableRelationProperties ImmutableRelationProperties}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "RelationProperties", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_FROM_TABLE = 0x1L;
    private static final long INIT_BIT_TO_TABLE = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String fromTable;
    private @Nullable String toTable;
    private List<RelationColumnProperties> columnsProperties = new ArrayList<RelationColumnProperties>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RelationProperties} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(RelationProperties instance) {
      Objects.requireNonNull(instance, "instance");
      this.fromTable(instance.getFromTable());
      this.toTable(instance.getToTable());
      addAllColumnsProperties(instance.getColumnsProperties());
      return this;
    }

    /**
     * Initializes the value for the {@link RelationProperties#getFromTable() fromTable} attribute.
     * @param fromTable The value for fromTable 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("FromTableName")
    public final Builder fromTable(String fromTable) {
      this.fromTable = Objects.requireNonNull(fromTable, "fromTable");
      initBits &= ~INIT_BIT_FROM_TABLE;
      return this;
    }

    /**
     * Initializes the value for the {@link RelationProperties#getToTable() toTable} attribute.
     * @param toTable The value for toTable 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("ToTableName")
    public final Builder toTable(String toTable) {
      this.toTable = Objects.requireNonNull(toTable, "toTable");
      initBits &= ~INIT_BIT_TO_TABLE;
      return this;
    }

    /**
     * Adds one element to {@link RelationProperties#getColumnsProperties() columnsProperties} list.
     * @param element A columnsProperties element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addColumnsProperties(RelationColumnProperties element) {
      this.columnsProperties.add(Objects.requireNonNull(element, "columnsProperties element"));
      return this;
    }

    /**
     * Adds elements to {@link RelationProperties#getColumnsProperties() columnsProperties} list.
     * @param elements An array of columnsProperties elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addColumnsProperties(RelationColumnProperties... elements) {
      for (RelationColumnProperties element : elements) {
        this.columnsProperties.add(Objects.requireNonNull(element, "columnsProperties element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link RelationProperties#getColumnsProperties() columnsProperties} list.
     * @param elements An iterable of columnsProperties elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("ColumnRelationshipInformations")
    public final Builder columnsProperties(Iterable<? extends RelationColumnProperties> elements) {
      this.columnsProperties.clear();
      return addAllColumnsProperties(elements);
    }

    /**
     * Adds elements to {@link RelationProperties#getColumnsProperties() columnsProperties} list.
     * @param elements An iterable of columnsProperties elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllColumnsProperties(Iterable<? extends RelationColumnProperties> elements) {
      for (RelationColumnProperties element : elements) {
        this.columnsProperties.add(Objects.requireNonNull(element, "columnsProperties element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableRelationProperties ImmutableRelationProperties}.
     * @return An immutable instance of RelationProperties
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableRelationProperties build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableRelationProperties(fromTable, toTable, List.copyOf(columnsProperties));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_FROM_TABLE) != 0) attributes.add("fromTable");
      if ((initBits & INIT_BIT_TO_TABLE) != 0) attributes.add("toTable");
      return "Cannot build RelationProperties, some of required attributes are not set " + attributes;
    }
  }
}
