package zeenea.connector.azure.synapse.data.client.data;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link RelationColumnProperties}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableRelationColumnProperties.builder()}.
 */
@Generated(from = "RelationColumnProperties", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableRelationColumnProperties
    implements RelationColumnProperties {
  private final String fromColumn;
  private final String toColumn;

  private ImmutableRelationColumnProperties(String fromColumn, String toColumn) {
    this.fromColumn = fromColumn;
    this.toColumn = toColumn;
  }

  /**
   * @return The value of the {@code fromColumn} attribute
   */
  @JsonProperty("FromColumnName")
  @Override
  public String getFromColumn() {
    return fromColumn;
  }

  /**
   * @return The value of the {@code toColumn} attribute
   */
  @JsonProperty("ToColumnName")
  @Override
  public String getToColumn() {
    return toColumn;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RelationColumnProperties#getFromColumn() fromColumn} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for fromColumn
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRelationColumnProperties withFromColumn(String value) {
    String newValue = Objects.requireNonNull(value, "fromColumn");
    if (this.fromColumn.equals(newValue)) return this;
    return new ImmutableRelationColumnProperties(newValue, this.toColumn);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RelationColumnProperties#getToColumn() toColumn} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for toColumn
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRelationColumnProperties withToColumn(String value) {
    String newValue = Objects.requireNonNull(value, "toColumn");
    if (this.toColumn.equals(newValue)) return this;
    return new ImmutableRelationColumnProperties(this.fromColumn, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableRelationColumnProperties} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableRelationColumnProperties
        && equalTo(0, (ImmutableRelationColumnProperties) another);
  }

  private boolean equalTo(int synthetic, ImmutableRelationColumnProperties another) {
    return fromColumn.equals(another.fromColumn)
        && toColumn.equals(another.toColumn);
  }

  /**
   * Computes a hash code from attributes: {@code fromColumn}, {@code toColumn}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + fromColumn.hashCode();
    h += (h << 5) + toColumn.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code RelationColumnProperties} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "RelationColumnProperties{"
        + "fromColumn=" + fromColumn
        + ", toColumn=" + toColumn
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link RelationColumnProperties} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable RelationColumnProperties instance
   */
  public static ImmutableRelationColumnProperties copyOf(RelationColumnProperties instance) {
    if (instance instanceof ImmutableRelationColumnProperties) {
      return (ImmutableRelationColumnProperties) instance;
    }
    return ImmutableRelationColumnProperties.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableRelationColumnProperties ImmutableRelationColumnProperties}.
   * <pre>
   * ImmutableRelationColumnProperties.builder()
   *    .fromColumn(String) // required {@link RelationColumnProperties#getFromColumn() fromColumn}
   *    .toColumn(String) // required {@link RelationColumnProperties#getToColumn() toColumn}
   *    .build();
   * </pre>
   * @return A new ImmutableRelationColumnProperties builder
   */
  public static ImmutableRelationColumnProperties.Builder builder() {
    return new ImmutableRelationColumnProperties.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableRelationColumnProperties ImmutableRelationColumnProperties}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "RelationColumnProperties", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_FROM_COLUMN = 0x1L;
    private static final long INIT_BIT_TO_COLUMN = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String fromColumn;
    private @Nullable String toColumn;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RelationColumnProperties} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(RelationColumnProperties instance) {
      Objects.requireNonNull(instance, "instance");
      this.fromColumn(instance.getFromColumn());
      this.toColumn(instance.getToColumn());
      return this;
    }

    /**
     * Initializes the value for the {@link RelationColumnProperties#getFromColumn() fromColumn} attribute.
     * @param fromColumn The value for fromColumn 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("FromColumnName")
    public final Builder fromColumn(String fromColumn) {
      this.fromColumn = Objects.requireNonNull(fromColumn, "fromColumn");
      initBits &= ~INIT_BIT_FROM_COLUMN;
      return this;
    }

    /**
     * Initializes the value for the {@link RelationColumnProperties#getToColumn() toColumn} attribute.
     * @param toColumn The value for toColumn 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("ToColumnName")
    public final Builder toColumn(String toColumn) {
      this.toColumn = Objects.requireNonNull(toColumn, "toColumn");
      initBits &= ~INIT_BIT_TO_COLUMN;
      return this;
    }

    /**
     * Builds a new {@link ImmutableRelationColumnProperties ImmutableRelationColumnProperties}.
     * @return An immutable instance of RelationColumnProperties
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableRelationColumnProperties build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableRelationColumnProperties(fromColumn, toColumn);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_FROM_COLUMN) != 0) attributes.add("fromColumn");
      if ((initBits & INIT_BIT_TO_COLUMN) != 0) attributes.add("toColumn");
      return "Cannot build RelationColumnProperties, some of required attributes are not set " + attributes;
    }
  }
}
