package zeenea.connector.azure.synapse.data.client.data;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link OriginDataTypeName}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableOriginDataTypeName.builder()}.
 */
@Generated(from = "OriginDataTypeName", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableOriginDataTypeName
    implements OriginDataTypeName {
  private final String type;
  private final boolean nullable;
  private final int length;
  private final int precision;
  private final int scale;

  private ImmutableOriginDataTypeName(String type, boolean nullable, int length, int precision, int scale) {
    this.type = type;
    this.nullable = nullable;
    this.length = length;
    this.precision = precision;
    this.scale = scale;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty("TypeName")
  @Override
  public String getType() {
    return type;
  }

  /**
   * @return The value of the {@code nullable} attribute
   */
  @JsonProperty("IsNullable")
  @Override
  public boolean isNullable() {
    return nullable;
  }

  /**
   * @return The value of the {@code length} attribute
   */
  @JsonProperty("Length")
  @Override
  public int getLength() {
    return length;
  }

  /**
   * @return The value of the {@code precision} attribute
   */
  @JsonProperty("Precision")
  @Override
  public int getPrecision() {
    return precision;
  }

  /**
   * @return The value of the {@code scale} attribute
   */
  @JsonProperty("Scale")
  @Override
  public int getScale() {
    return scale;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link OriginDataTypeName#getType() type} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableOriginDataTypeName withType(String value) {
    String newValue = Objects.requireNonNull(value, "type");
    if (this.type.equals(newValue)) return this;
    return new ImmutableOriginDataTypeName(newValue, this.nullable, this.length, this.precision, this.scale);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link OriginDataTypeName#isNullable() nullable} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for nullable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableOriginDataTypeName withNullable(boolean value) {
    if (this.nullable == value) return this;
    return new ImmutableOriginDataTypeName(this.type, value, this.length, this.precision, this.scale);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link OriginDataTypeName#getLength() length} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for length
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableOriginDataTypeName withLength(int value) {
    if (this.length == value) return this;
    return new ImmutableOriginDataTypeName(this.type, this.nullable, value, this.precision, this.scale);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link OriginDataTypeName#getPrecision() precision} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for precision
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableOriginDataTypeName withPrecision(int value) {
    if (this.precision == value) return this;
    return new ImmutableOriginDataTypeName(this.type, this.nullable, this.length, value, this.scale);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link OriginDataTypeName#getScale() scale} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for scale
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableOriginDataTypeName withScale(int value) {
    if (this.scale == value) return this;
    return new ImmutableOriginDataTypeName(this.type, this.nullable, this.length, this.precision, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableOriginDataTypeName} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableOriginDataTypeName
        && equalTo(0, (ImmutableOriginDataTypeName) another);
  }

  private boolean equalTo(int synthetic, ImmutableOriginDataTypeName another) {
    return type.equals(another.type)
        && nullable == another.nullable
        && length == another.length
        && precision == another.precision
        && scale == another.scale;
  }

  /**
   * Computes a hash code from attributes: {@code type}, {@code nullable}, {@code length}, {@code precision}, {@code scale}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + type.hashCode();
    h += (h << 5) + Boolean.hashCode(nullable);
    h += (h << 5) + length;
    h += (h << 5) + precision;
    h += (h << 5) + scale;
    return h;
  }

  /**
   * Prints the immutable value {@code OriginDataTypeName} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "OriginDataTypeName{"
        + "type=" + type
        + ", nullable=" + nullable
        + ", length=" + length
        + ", precision=" + precision
        + ", scale=" + scale
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link OriginDataTypeName} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable OriginDataTypeName instance
   */
  public static ImmutableOriginDataTypeName copyOf(OriginDataTypeName instance) {
    if (instance instanceof ImmutableOriginDataTypeName) {
      return (ImmutableOriginDataTypeName) instance;
    }
    return ImmutableOriginDataTypeName.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableOriginDataTypeName ImmutableOriginDataTypeName}.
   * <pre>
   * ImmutableOriginDataTypeName.builder()
   *    .type(String) // required {@link OriginDataTypeName#getType() type}
   *    .nullable(boolean) // required {@link OriginDataTypeName#isNullable() nullable}
   *    .length(int) // required {@link OriginDataTypeName#getLength() length}
   *    .precision(int) // required {@link OriginDataTypeName#getPrecision() precision}
   *    .scale(int) // required {@link OriginDataTypeName#getScale() scale}
   *    .build();
   * </pre>
   * @return A new ImmutableOriginDataTypeName builder
   */
  public static ImmutableOriginDataTypeName.Builder builder() {
    return new ImmutableOriginDataTypeName.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableOriginDataTypeName ImmutableOriginDataTypeName}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "OriginDataTypeName", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TYPE = 0x1L;
    private static final long INIT_BIT_NULLABLE = 0x2L;
    private static final long INIT_BIT_LENGTH = 0x4L;
    private static final long INIT_BIT_PRECISION = 0x8L;
    private static final long INIT_BIT_SCALE = 0x10L;
    private long initBits = 0x1fL;

    private @Nullable String type;
    private boolean nullable;
    private int length;
    private int precision;
    private int scale;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code OriginDataTypeName} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(OriginDataTypeName instance) {
      Objects.requireNonNull(instance, "instance");
      this.type(instance.getType());
      this.nullable(instance.isNullable());
      this.length(instance.getLength());
      this.precision(instance.getPrecision());
      this.scale(instance.getScale());
      return this;
    }

    /**
     * Initializes the value for the {@link OriginDataTypeName#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("TypeName")
    public final Builder type(String type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link OriginDataTypeName#isNullable() nullable} attribute.
     * @param nullable The value for nullable 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("IsNullable")
    public final Builder nullable(boolean nullable) {
      this.nullable = nullable;
      initBits &= ~INIT_BIT_NULLABLE;
      return this;
    }

    /**
     * Initializes the value for the {@link OriginDataTypeName#getLength() length} attribute.
     * @param length The value for length 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Length")
    public final Builder length(int length) {
      this.length = length;
      initBits &= ~INIT_BIT_LENGTH;
      return this;
    }

    /**
     * Initializes the value for the {@link OriginDataTypeName#getPrecision() precision} attribute.
     * @param precision The value for precision 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Precision")
    public final Builder precision(int precision) {
      this.precision = precision;
      initBits &= ~INIT_BIT_PRECISION;
      return this;
    }

    /**
     * Initializes the value for the {@link OriginDataTypeName#getScale() scale} attribute.
     * @param scale The value for scale 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Scale")
    public final Builder scale(int scale) {
      this.scale = scale;
      initBits &= ~INIT_BIT_SCALE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableOriginDataTypeName ImmutableOriginDataTypeName}.
     * @return An immutable instance of OriginDataTypeName
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableOriginDataTypeName build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableOriginDataTypeName(type, nullable, length, precision, scale);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      if ((initBits & INIT_BIT_NULLABLE) != 0) attributes.add("nullable");
      if ((initBits & INIT_BIT_LENGTH) != 0) attributes.add("length");
      if ((initBits & INIT_BIT_PRECISION) != 0) attributes.add("precision");
      if ((initBits & INIT_BIT_SCALE) != 0) attributes.add("scale");
      return "Cannot build OriginDataTypeName, some of required attributes are not set " + attributes;
    }
  }
}
