package zeenea.connector.azure.synapse.data.client.data;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link GetTablesResult}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableGetTablesResult.builder()}.
 */
@Generated(from = "GetTablesResult", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableGetTablesResult
    implements GetTablesResult {
  private final List<Table> tables;

  private ImmutableGetTablesResult(List<Table> tables) {
    this.tables = tables;
  }

  /**
   * @return The value of the {@code tables} attribute
   */
  @JsonProperty("items")
  @Override
  public List<Table> getTables() {
    return tables;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link GetTablesResult#getTables() tables}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableGetTablesResult withTables(Table... elements) {
    List<Table> newValue = List.of(elements);
    return new ImmutableGetTablesResult(newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link GetTablesResult#getTables() tables}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of tables elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableGetTablesResult withTables(Iterable<? extends Table> elements) {
    if (this.tables == elements) return this;
    List<Table> newValue = elements instanceof Collection<?>
        ? List.copyOf((Collection<? extends Table>) elements)
        : StreamSupport.stream(elements.spliterator(), false)
            .collect(Collectors.toUnmodifiableList());
    return new ImmutableGetTablesResult(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableGetTablesResult} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableGetTablesResult
        && equalTo(0, (ImmutableGetTablesResult) another);
  }

  private boolean equalTo(int synthetic, ImmutableGetTablesResult another) {
    return tables.equals(another.tables);
  }

  /**
   * Computes a hash code from attributes: {@code tables}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + tables.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GetTablesResult} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetTablesResult{"
        + "tables=" + tables
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link GetTablesResult} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable GetTablesResult instance
   */
  public static ImmutableGetTablesResult copyOf(GetTablesResult instance) {
    if (instance instanceof ImmutableGetTablesResult) {
      return (ImmutableGetTablesResult) instance;
    }
    return ImmutableGetTablesResult.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableGetTablesResult ImmutableGetTablesResult}.
   * <pre>
   * ImmutableGetTablesResult.builder()
   *    .addTables|addAllTables(zeenea.connector.azure.synapse.data.client.data.Table) // {@link GetTablesResult#getTables() tables} elements
   *    .build();
   * </pre>
   * @return A new ImmutableGetTablesResult builder
   */
  public static ImmutableGetTablesResult.Builder builder() {
    return new ImmutableGetTablesResult.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableGetTablesResult ImmutableGetTablesResult}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "GetTablesResult", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private List<Table> tables = new ArrayList<Table>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetTablesResult} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(GetTablesResult instance) {
      Objects.requireNonNull(instance, "instance");
      addAllTables(instance.getTables());
      return this;
    }

    /**
     * Adds one element to {@link GetTablesResult#getTables() tables} list.
     * @param element A tables element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addTables(Table element) {
      this.tables.add(Objects.requireNonNull(element, "tables element"));
      return this;
    }

    /**
     * Adds elements to {@link GetTablesResult#getTables() tables} list.
     * @param elements An array of tables elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addTables(Table... elements) {
      for (Table element : elements) {
        this.tables.add(Objects.requireNonNull(element, "tables element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link GetTablesResult#getTables() tables} list.
     * @param elements An iterable of tables elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("items")
    public final Builder tables(Iterable<? extends Table> elements) {
      this.tables.clear();
      return addAllTables(elements);
    }

    /**
     * Adds elements to {@link GetTablesResult#getTables() tables} list.
     * @param elements An iterable of tables elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllTables(Iterable<? extends Table> elements) {
      for (Table element : elements) {
        this.tables.add(Objects.requireNonNull(element, "tables element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableGetTablesResult ImmutableGetTablesResult}.
     * @return An immutable instance of GetTablesResult
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableGetTablesResult build() {
      return new ImmutableGetTablesResult(List.copyOf(tables));
    }
  }
}
