package zeenea.connector.azure.synapse.data.client.data;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link GetRelationshipsResponse}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableGetRelationshipsResponse.builder()}.
 */
@Generated(from = "GetRelationshipsResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableGetRelationshipsResponse
    implements GetRelationshipsResponse {
  private final List<Relation> relations;

  private ImmutableGetRelationshipsResponse(List<Relation> relations) {
    this.relations = relations;
  }

  /**
   * @return The value of the {@code relations} attribute
   */
  @JsonProperty("items")
  @Override
  public List<Relation> getRelations() {
    return relations;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link GetRelationshipsResponse#getRelations() relations}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableGetRelationshipsResponse withRelations(Relation... elements) {
    List<Relation> newValue = List.of(elements);
    return new ImmutableGetRelationshipsResponse(newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link GetRelationshipsResponse#getRelations() relations}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of relations elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableGetRelationshipsResponse withRelations(Iterable<? extends Relation> elements) {
    if (this.relations == elements) return this;
    List<Relation> newValue = elements instanceof Collection<?>
        ? List.copyOf((Collection<? extends Relation>) elements)
        : StreamSupport.stream(elements.spliterator(), false)
            .collect(Collectors.toUnmodifiableList());
    return new ImmutableGetRelationshipsResponse(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableGetRelationshipsResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableGetRelationshipsResponse
        && equalTo(0, (ImmutableGetRelationshipsResponse) another);
  }

  private boolean equalTo(int synthetic, ImmutableGetRelationshipsResponse another) {
    return relations.equals(another.relations);
  }

  /**
   * Computes a hash code from attributes: {@code relations}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + relations.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GetRelationshipsResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetRelationshipsResponse{"
        + "relations=" + relations
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link GetRelationshipsResponse} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable GetRelationshipsResponse instance
   */
  public static ImmutableGetRelationshipsResponse copyOf(GetRelationshipsResponse instance) {
    if (instance instanceof ImmutableGetRelationshipsResponse) {
      return (ImmutableGetRelationshipsResponse) instance;
    }
    return ImmutableGetRelationshipsResponse.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableGetRelationshipsResponse ImmutableGetRelationshipsResponse}.
   * <pre>
   * ImmutableGetRelationshipsResponse.builder()
   *    .addRelations|addAllRelations(zeenea.connector.azure.synapse.data.client.data.Relation) // {@link GetRelationshipsResponse#getRelations() relations} elements
   *    .build();
   * </pre>
   * @return A new ImmutableGetRelationshipsResponse builder
   */
  public static ImmutableGetRelationshipsResponse.Builder builder() {
    return new ImmutableGetRelationshipsResponse.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableGetRelationshipsResponse ImmutableGetRelationshipsResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "GetRelationshipsResponse", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private List<Relation> relations = new ArrayList<Relation>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetRelationshipsResponse} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(GetRelationshipsResponse instance) {
      Objects.requireNonNull(instance, "instance");
      addAllRelations(instance.getRelations());
      return this;
    }

    /**
     * Adds one element to {@link GetRelationshipsResponse#getRelations() relations} list.
     * @param element A relations element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addRelations(Relation element) {
      this.relations.add(Objects.requireNonNull(element, "relations element"));
      return this;
    }

    /**
     * Adds elements to {@link GetRelationshipsResponse#getRelations() relations} list.
     * @param elements An array of relations elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addRelations(Relation... elements) {
      for (Relation element : elements) {
        this.relations.add(Objects.requireNonNull(element, "relations element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link GetRelationshipsResponse#getRelations() relations} list.
     * @param elements An iterable of relations elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("items")
    public final Builder relations(Iterable<? extends Relation> elements) {
      this.relations.clear();
      return addAllRelations(elements);
    }

    /**
     * Adds elements to {@link GetRelationshipsResponse#getRelations() relations} list.
     * @param elements An iterable of relations elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllRelations(Iterable<? extends Relation> elements) {
      for (Relation element : elements) {
        this.relations.add(Objects.requireNonNull(element, "relations element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableGetRelationshipsResponse ImmutableGetRelationshipsResponse}.
     * @return An immutable instance of GetRelationshipsResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableGetRelationshipsResponse build() {
      return new ImmutableGetRelationshipsResponse(List.copyOf(relations));
    }
  }
}
