package zeenea.connector.azure.synapse.data.client.data;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link GetDatabasesResponse}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableGetDatabasesResponse.builder()}.
 */
@Generated(from = "GetDatabasesResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableGetDatabasesResponse
    implements GetDatabasesResponse {
  private final List<Database> databases;

  private ImmutableGetDatabasesResponse(List<Database> databases) {
    this.databases = databases;
  }

  /**
   * @return The value of the {@code databases} attribute
   */
  @JsonProperty("items")
  @Override
  public List<Database> getDatabases() {
    return databases;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link GetDatabasesResponse#getDatabases() databases}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableGetDatabasesResponse withDatabases(Database... elements) {
    List<Database> newValue = List.of(elements);
    return new ImmutableGetDatabasesResponse(newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link GetDatabasesResponse#getDatabases() databases}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of databases elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableGetDatabasesResponse withDatabases(Iterable<? extends Database> elements) {
    if (this.databases == elements) return this;
    List<Database> newValue = elements instanceof Collection<?>
        ? List.copyOf((Collection<? extends Database>) elements)
        : StreamSupport.stream(elements.spliterator(), false)
            .collect(Collectors.toUnmodifiableList());
    return new ImmutableGetDatabasesResponse(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableGetDatabasesResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableGetDatabasesResponse
        && equalTo(0, (ImmutableGetDatabasesResponse) another);
  }

  private boolean equalTo(int synthetic, ImmutableGetDatabasesResponse another) {
    return databases.equals(another.databases);
  }

  /**
   * Computes a hash code from attributes: {@code databases}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + databases.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GetDatabasesResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetDatabasesResponse{"
        + "databases=" + databases
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link GetDatabasesResponse} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable GetDatabasesResponse instance
   */
  public static ImmutableGetDatabasesResponse copyOf(GetDatabasesResponse instance) {
    if (instance instanceof ImmutableGetDatabasesResponse) {
      return (ImmutableGetDatabasesResponse) instance;
    }
    return ImmutableGetDatabasesResponse.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableGetDatabasesResponse ImmutableGetDatabasesResponse}.
   * <pre>
   * ImmutableGetDatabasesResponse.builder()
   *    .addDatabases|addAllDatabases(zeenea.connector.azure.synapse.data.client.data.Database) // {@link GetDatabasesResponse#getDatabases() databases} elements
   *    .build();
   * </pre>
   * @return A new ImmutableGetDatabasesResponse builder
   */
  public static ImmutableGetDatabasesResponse.Builder builder() {
    return new ImmutableGetDatabasesResponse.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableGetDatabasesResponse ImmutableGetDatabasesResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "GetDatabasesResponse", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private List<Database> databases = new ArrayList<Database>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetDatabasesResponse} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(GetDatabasesResponse instance) {
      Objects.requireNonNull(instance, "instance");
      addAllDatabases(instance.getDatabases());
      return this;
    }

    /**
     * Adds one element to {@link GetDatabasesResponse#getDatabases() databases} list.
     * @param element A databases element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addDatabases(Database element) {
      this.databases.add(Objects.requireNonNull(element, "databases element"));
      return this;
    }

    /**
     * Adds elements to {@link GetDatabasesResponse#getDatabases() databases} list.
     * @param elements An array of databases elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addDatabases(Database... elements) {
      for (Database element : elements) {
        this.databases.add(Objects.requireNonNull(element, "databases element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link GetDatabasesResponse#getDatabases() databases} list.
     * @param elements An iterable of databases elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("items")
    public final Builder databases(Iterable<? extends Database> elements) {
      this.databases.clear();
      return addAllDatabases(elements);
    }

    /**
     * Adds elements to {@link GetDatabasesResponse#getDatabases() databases} list.
     * @param elements An iterable of databases elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllDatabases(Iterable<? extends Database> elements) {
      for (Database element : elements) {
        this.databases.add(Objects.requireNonNull(element, "databases element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableGetDatabasesResponse ImmutableGetDatabasesResponse}.
     * @return An immutable instance of GetDatabasesResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableGetDatabasesResponse build() {
      return new ImmutableGetDatabasesResponse(List.copyOf(databases));
    }
  }
}
