package zeenea.connector.azure.synapse.data.client.data;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Format}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableFormat.builder()}.
 */
@Generated(from = "Format", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableFormat implements Format {
  private final String formatType;

  private ImmutableFormat(String formatType) {
    this.formatType = formatType;
  }

  /**
   * @return The value of the {@code formatType} attribute
   */
  @JsonProperty("FormatType")
  @Override
  public String getFormatType() {
    return formatType;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Format#getFormatType() formatType} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for formatType
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormat withFormatType(String value) {
    String newValue = Objects.requireNonNull(value, "formatType");
    if (this.formatType.equals(newValue)) return this;
    return new ImmutableFormat(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableFormat} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableFormat
        && equalTo(0, (ImmutableFormat) another);
  }

  private boolean equalTo(int synthetic, ImmutableFormat another) {
    return formatType.equals(another.formatType);
  }

  /**
   * Computes a hash code from attributes: {@code formatType}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + formatType.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Format} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Format{"
        + "formatType=" + formatType
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link Format} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Format instance
   */
  public static ImmutableFormat copyOf(Format instance) {
    if (instance instanceof ImmutableFormat) {
      return (ImmutableFormat) instance;
    }
    return ImmutableFormat.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableFormat ImmutableFormat}.
   * <pre>
   * ImmutableFormat.builder()
   *    .formatType(String) // required {@link Format#getFormatType() formatType}
   *    .build();
   * </pre>
   * @return A new ImmutableFormat builder
   */
  public static ImmutableFormat.Builder builder() {
    return new ImmutableFormat.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableFormat ImmutableFormat}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Format", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_FORMAT_TYPE = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String formatType;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Format} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Format instance) {
      Objects.requireNonNull(instance, "instance");
      this.formatType(instance.getFormatType());
      return this;
    }

    /**
     * Initializes the value for the {@link Format#getFormatType() formatType} attribute.
     * @param formatType The value for formatType 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("FormatType")
    public final Builder formatType(String formatType) {
      this.formatType = Objects.requireNonNull(formatType, "formatType");
      initBits &= ~INIT_BIT_FORMAT_TYPE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableFormat ImmutableFormat}.
     * @return An immutable instance of Format
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableFormat build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableFormat(formatType);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_FORMAT_TYPE) != 0) attributes.add("formatType");
      return "Cannot build Format, some of required attributes are not set " + attributes;
    }
  }
}
