package zeenea.connector.azure.synapse.data.client.data;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Database}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDatabase.builder()}.
 */
@Generated(from = "Database", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableDatabase implements Database {
  private final String name;

  private ImmutableDatabase(String name) {
    this.name = name;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Database#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDatabase withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableDatabase(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDatabase} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDatabase
        && equalTo(0, (ImmutableDatabase) another);
  }

  private boolean equalTo(int synthetic, ImmutableDatabase another) {
    return name.equals(another.name);
  }

  /**
   * Computes a hash code from attributes: {@code name}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + name.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Database} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Database{"
        + "name=" + name
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link Database} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Database instance
   */
  public static ImmutableDatabase copyOf(Database instance) {
    if (instance instanceof ImmutableDatabase) {
      return (ImmutableDatabase) instance;
    }
    return ImmutableDatabase.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDatabase ImmutableDatabase}.
   * <pre>
   * ImmutableDatabase.builder()
   *    .name(String) // required {@link Database#getName() name}
   *    .build();
   * </pre>
   * @return A new ImmutableDatabase builder
   */
  public static ImmutableDatabase.Builder builder() {
    return new ImmutableDatabase.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDatabase ImmutableDatabase}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Database", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String name;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Database} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Database instance) {
      Objects.requireNonNull(instance, "instance");
      this.name(instance.getName());
      return this;
    }

    /**
     * Initializes the value for the {@link Database#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Builds a new {@link ImmutableDatabase ImmutableDatabase}.
     * @return An immutable instance of Database
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDatabase build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableDatabase(name);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build Database, some of required attributes are not set " + attributes;
    }
  }
}
