package zeenea.connector.azure.synapse.data.client.data;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;

/**
 * Immutable implementation of {@link Column}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableColumn.builder()}.
 */
@Generated(from = "Column", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableColumn implements Column {
  private final String name;
  private final @Nullable String description;
  private final OriginDataTypeName originDataTypeName;

  private ImmutableColumn(
      String name,
      @Nullable String description,
      OriginDataTypeName originDataTypeName) {
    this.name = name;
    this.description = description;
    this.originDataTypeName = originDataTypeName;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("Name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code description} attribute
   */
  @JsonProperty("Description")
  @Override
  public @Nullable String getDescription() {
    return description;
  }

  /**
   * @return The value of the {@code originDataTypeName} attribute
   */
  @JsonProperty("OriginDataTypeName")
  @Override
  public OriginDataTypeName getOriginDataTypeName() {
    return originDataTypeName;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Column#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableColumn withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableColumn(newValue, this.description, this.originDataTypeName);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Column#getDescription() description} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for description (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableColumn withDescription(@Nullable String value) {
    if (Objects.equals(this.description, value)) return this;
    return new ImmutableColumn(this.name, value, this.originDataTypeName);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Column#getOriginDataTypeName() originDataTypeName} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for originDataTypeName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableColumn withOriginDataTypeName(OriginDataTypeName value) {
    if (this.originDataTypeName == value) return this;
    OriginDataTypeName newValue = Objects.requireNonNull(value, "originDataTypeName");
    return new ImmutableColumn(this.name, this.description, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableColumn} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableColumn
        && equalTo(0, (ImmutableColumn) another);
  }

  private boolean equalTo(int synthetic, ImmutableColumn another) {
    return name.equals(another.name)
        && Objects.equals(description, another.description)
        && originDataTypeName.equals(another.originDataTypeName);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code description}, {@code originDataTypeName}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + Objects.hashCode(description);
    h += (h << 5) + originDataTypeName.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Column} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Column{"
        + "name=" + name
        + ", description=" + description
        + ", originDataTypeName=" + originDataTypeName
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link Column} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Column instance
   */
  public static ImmutableColumn copyOf(Column instance) {
    if (instance instanceof ImmutableColumn) {
      return (ImmutableColumn) instance;
    }
    return ImmutableColumn.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableColumn ImmutableColumn}.
   * <pre>
   * ImmutableColumn.builder()
   *    .name(String) // required {@link Column#getName() name}
   *    .description(String | null) // nullable {@link Column#getDescription() description}
   *    .originDataTypeName(zeenea.connector.azure.synapse.data.client.data.OriginDataTypeName) // required {@link Column#getOriginDataTypeName() originDataTypeName}
   *    .build();
   * </pre>
   * @return A new ImmutableColumn builder
   */
  public static ImmutableColumn.Builder builder() {
    return new ImmutableColumn.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableColumn ImmutableColumn}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Column", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_ORIGIN_DATA_TYPE_NAME = 0x2L;
    private long initBits = 0x3L;

    private @javax.annotation.Nullable String name;
    private @javax.annotation.Nullable String description;
    private @javax.annotation.Nullable OriginDataTypeName originDataTypeName;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Column} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Column instance) {
      Objects.requireNonNull(instance, "instance");
      this.name(instance.getName());
      @Nullable String descriptionValue = instance.getDescription();
      if (descriptionValue != null) {
        description(descriptionValue);
      }
      this.originDataTypeName(instance.getOriginDataTypeName());
      return this;
    }

    /**
     * Initializes the value for the {@link Column#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link Column#getDescription() description} attribute.
     * @param description The value for description (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Description")
    public final Builder description(@Nullable String description) {
      this.description = description;
      return this;
    }

    /**
     * Initializes the value for the {@link Column#getOriginDataTypeName() originDataTypeName} attribute.
     * @param originDataTypeName The value for originDataTypeName 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("OriginDataTypeName")
    public final Builder originDataTypeName(OriginDataTypeName originDataTypeName) {
      this.originDataTypeName = Objects.requireNonNull(originDataTypeName, "originDataTypeName");
      initBits &= ~INIT_BIT_ORIGIN_DATA_TYPE_NAME;
      return this;
    }

    /**
     * Builds a new {@link ImmutableColumn ImmutableColumn}.
     * @return An immutable instance of Column
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableColumn build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableColumn(name, description, originDataTypeName);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_ORIGIN_DATA_TYPE_NAME) != 0) attributes.add("originDataTypeName");
      return "Cannot build Column, some of required attributes are not set " + attributes;
    }
  }
}
