package zeenea.connector.azure.synapse.data;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.NotNull;

/**
 * Immutable implementation of {@link ItemRef}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableItemRef.builder()}.
 */
@Generated(from = "ItemRef", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableItemRef extends ItemRef {
  @NotNull
  private final String workspace;
  @NotNull
  private final String database;
  @NotNull
  private final String table;

  private ImmutableItemRef(String workspace, String database, String table) {
    this.workspace = workspace;
    this.database = database;
    this.table = table;
  }

  /**
   * @return The value of the {@code workspace} attribute
   */
  @NotNull
  @Override
  String getWorkspace() {
    return workspace;
  }

  /**
   * @return The value of the {@code database} attribute
   */
  @NotNull
  @Override
  String getDatabase() {
    return database;
  }

  /**
   * @return The value of the {@code table} attribute
   */
  @NotNull
  @Override
  String getTable() {
    return table;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ItemRef#getWorkspace() workspace} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for workspace
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableItemRef withWorkspace(String value) {
    String newValue = Objects.requireNonNull(value, "workspace");
    if (this.workspace.equals(newValue)) return this;
    return new ImmutableItemRef(newValue, this.database, this.table);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ItemRef#getDatabase() database} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for database
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableItemRef withDatabase(String value) {
    String newValue = Objects.requireNonNull(value, "database");
    if (this.database.equals(newValue)) return this;
    return new ImmutableItemRef(this.workspace, newValue, this.table);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ItemRef#getTable() table} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for table
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableItemRef withTable(String value) {
    String newValue = Objects.requireNonNull(value, "table");
    if (this.table.equals(newValue)) return this;
    return new ImmutableItemRef(this.workspace, this.database, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableItemRef} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableItemRef
        && equalTo(0, (ImmutableItemRef) another);
  }

  private boolean equalTo(int synthetic, ImmutableItemRef another) {
    return workspace.equals(another.workspace)
        && database.equals(another.database)
        && table.equals(another.table);
  }

  /**
   * Computes a hash code from attributes: {@code workspace}, {@code database}, {@code table}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + workspace.hashCode();
    h += (h << 5) + database.hashCode();
    h += (h << 5) + table.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ItemRef} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ItemRef{"
        + "workspace=" + workspace
        + ", database=" + database
        + ", table=" + table
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link ItemRef} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ItemRef instance
   */
  public static ImmutableItemRef copyOf(ItemRef instance) {
    if (instance instanceof ImmutableItemRef) {
      return (ImmutableItemRef) instance;
    }
    return ImmutableItemRef.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableItemRef ImmutableItemRef}.
   * <pre>
   * ImmutableItemRef.builder()
   *    .workspace(String) // required {@link ItemRef#getWorkspace() workspace}
   *    .database(String) // required {@link ItemRef#getDatabase() database}
   *    .table(String) // required {@link ItemRef#getTable() table}
   *    .build();
   * </pre>
   * @return A new ImmutableItemRef builder
   */
  public static ImmutableItemRef.Builder builder() {
    return new ImmutableItemRef.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableItemRef ImmutableItemRef}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ItemRef", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_WORKSPACE = 0x1L;
    private static final long INIT_BIT_DATABASE = 0x2L;
    private static final long INIT_BIT_TABLE = 0x4L;
    private long initBits = 0x7L;

    private @Nullable String workspace;
    private @Nullable String database;
    private @Nullable String table;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ItemRef} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ItemRef instance) {
      Objects.requireNonNull(instance, "instance");
      this.workspace(instance.getWorkspace());
      this.database(instance.getDatabase());
      this.table(instance.getTable());
      return this;
    }

    /**
     * Initializes the value for the {@link ItemRef#getWorkspace() workspace} attribute.
     * @param workspace The value for workspace 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder workspace(String workspace) {
      this.workspace = Objects.requireNonNull(workspace, "workspace");
      initBits &= ~INIT_BIT_WORKSPACE;
      return this;
    }

    /**
     * Initializes the value for the {@link ItemRef#getDatabase() database} attribute.
     * @param database The value for database 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder database(String database) {
      this.database = Objects.requireNonNull(database, "database");
      initBits &= ~INIT_BIT_DATABASE;
      return this;
    }

    /**
     * Initializes the value for the {@link ItemRef#getTable() table} attribute.
     * @param table The value for table 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder table(String table) {
      this.table = Objects.requireNonNull(table, "table");
      initBits &= ~INIT_BIT_TABLE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableItemRef ImmutableItemRef}.
     * @return An immutable instance of ItemRef
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableItemRef build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableItemRef(workspace, database, table);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_WORKSPACE) != 0) attributes.add("workspace");
      if ((initBits & INIT_BIT_DATABASE) != 0) attributes.add("database");
      if ((initBits & INIT_BIT_TABLE) != 0) attributes.add("table");
      return "Cannot build ItemRef, some of required attributes are not set " + attributes;
    }
  }
}
