package zeenea.connector.azure.datafactory.client;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Response}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableResponse.builder()}.
 */
@Generated(from = "Response", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableResponse implements Response {
  private final List<Entity> entities;

  private ImmutableResponse(List<Entity> entities) {
    this.entities = entities;
  }

  /**
   * @return The value of the {@code entities} attribute
   */
  @JsonProperty("value")
  @Override
  public List<Entity> getEntities() {
    return entities;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Response#getEntities() entities}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableResponse withEntities(Entity... elements) {
    List<Entity> newValue = List.of(elements);
    return new ImmutableResponse(newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Response#getEntities() entities}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of entities elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableResponse withEntities(Iterable<? extends Entity> elements) {
    if (this.entities == elements) return this;
    List<Entity> newValue = elements instanceof Collection<?>
        ? List.copyOf((Collection<? extends Entity>) elements)
        : StreamSupport.stream(elements.spliterator(), false)
            .collect(Collectors.toUnmodifiableList());
    return new ImmutableResponse(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableResponse
        && equalTo(0, (ImmutableResponse) another);
  }

  private boolean equalTo(int synthetic, ImmutableResponse another) {
    return entities.equals(another.entities);
  }

  /**
   * Computes a hash code from attributes: {@code entities}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + entities.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Response} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Response{"
        + "entities=" + entities
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Response", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Response {
    @Nullable List<Entity> entities = List.of();
    @JsonProperty("value")
    public void setEntities(List<Entity> entities) {
      this.entities = entities;
    }
    @Override
    public List<Entity> getEntities() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableResponse fromJson(Json json) {
    ImmutableResponse.Builder builder = ImmutableResponse.builder();
    if (json.entities != null) {
      builder.addAllEntities(json.entities);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Response} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Response instance
   */
  public static ImmutableResponse copyOf(Response instance) {
    if (instance instanceof ImmutableResponse) {
      return (ImmutableResponse) instance;
    }
    return ImmutableResponse.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableResponse ImmutableResponse}.
   * <pre>
   * ImmutableResponse.builder()
   *    .addEntities|addAllEntities(zeenea.connector.azure.datafactory.client.Entity) // {@link Response#getEntities() entities} elements
   *    .build();
   * </pre>
   * @return A new ImmutableResponse builder
   */
  public static ImmutableResponse.Builder builder() {
    return new ImmutableResponse.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableResponse ImmutableResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Response", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private List<Entity> entities = new ArrayList<Entity>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Response} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Response instance) {
      Objects.requireNonNull(instance, "instance");
      addAllEntities(instance.getEntities());
      return this;
    }

    /**
     * Adds one element to {@link Response#getEntities() entities} list.
     * @param element A entities element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addEntities(Entity element) {
      this.entities.add(Objects.requireNonNull(element, "entities element"));
      return this;
    }

    /**
     * Adds elements to {@link Response#getEntities() entities} list.
     * @param elements An array of entities elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addEntities(Entity... elements) {
      for (Entity element : elements) {
        this.entities.add(Objects.requireNonNull(element, "entities element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Response#getEntities() entities} list.
     * @param elements An iterable of entities elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("value")
    public final Builder entities(Iterable<? extends Entity> elements) {
      this.entities.clear();
      return addAllEntities(elements);
    }

    /**
     * Adds elements to {@link Response#getEntities() entities} list.
     * @param elements An iterable of entities elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllEntities(Iterable<? extends Entity> elements) {
      for (Entity element : elements) {
        this.entities.add(Objects.requireNonNull(element, "entities element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableResponse ImmutableResponse}.
     * @return An immutable instance of Response
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableResponse build() {
      return new ImmutableResponse(List.copyOf(entities));
    }
  }
}
