package zeenea.connector.azure.datafactory.client;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.NotNull;

/**
 * Immutable implementation of {@link PipelineCtx}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutablePipelineCtx.builder()}.
 */
@Generated(from = "PipelineCtx", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutablePipelineCtx implements PipelineCtx {
  @NotNull
  private final FactoryCtx factoryCtx;
  @NotNull
  private final Entity pipeline;

  private ImmutablePipelineCtx(
      FactoryCtx factoryCtx,
      Entity pipeline) {
    this.factoryCtx = factoryCtx;
    this.pipeline = pipeline;
  }

  /**
   * @return The value of the {@code factoryCtx} attribute
   */
  @NotNull
  @Override
  public FactoryCtx getFactoryCtx() {
    return factoryCtx;
  }

  /**
   * @return The value of the {@code pipeline} attribute
   */
  @NotNull
  @Override
  public Entity getPipeline() {
    return pipeline;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PipelineCtx#getFactoryCtx() factoryCtx} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for factoryCtx
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePipelineCtx withFactoryCtx(FactoryCtx value) {
    if (this.factoryCtx == value) return this;
    FactoryCtx newValue = Objects.requireNonNull(value, "factoryCtx");
    return new ImmutablePipelineCtx(newValue, this.pipeline);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PipelineCtx#getPipeline() pipeline} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for pipeline
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePipelineCtx withPipeline(Entity value) {
    if (this.pipeline == value) return this;
    Entity newValue = Objects.requireNonNull(value, "pipeline");
    return new ImmutablePipelineCtx(this.factoryCtx, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutablePipelineCtx} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutablePipelineCtx
        && equalTo(0, (ImmutablePipelineCtx) another);
  }

  private boolean equalTo(int synthetic, ImmutablePipelineCtx another) {
    return factoryCtx.equals(another.factoryCtx)
        && pipeline.equals(another.pipeline);
  }

  /**
   * Computes a hash code from attributes: {@code factoryCtx}, {@code pipeline}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + factoryCtx.hashCode();
    h += (h << 5) + pipeline.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code PipelineCtx} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "PipelineCtx{"
        + "factoryCtx=" + factoryCtx
        + ", pipeline=" + pipeline
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link PipelineCtx} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable PipelineCtx instance
   */
  public static ImmutablePipelineCtx copyOf(PipelineCtx instance) {
    if (instance instanceof ImmutablePipelineCtx) {
      return (ImmutablePipelineCtx) instance;
    }
    return ImmutablePipelineCtx.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutablePipelineCtx ImmutablePipelineCtx}.
   * <pre>
   * ImmutablePipelineCtx.builder()
   *    .factoryCtx(zeenea.connector.azure.datafactory.client.FactoryCtx) // required {@link PipelineCtx#getFactoryCtx() factoryCtx}
   *    .pipeline(zeenea.connector.azure.datafactory.client.Entity) // required {@link PipelineCtx#getPipeline() pipeline}
   *    .build();
   * </pre>
   * @return A new ImmutablePipelineCtx builder
   */
  public static ImmutablePipelineCtx.Builder builder() {
    return new ImmutablePipelineCtx.Builder();
  }

  /**
   * Builds instances of type {@link ImmutablePipelineCtx ImmutablePipelineCtx}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "PipelineCtx", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_FACTORY_CTX = 0x1L;
    private static final long INIT_BIT_PIPELINE = 0x2L;
    private long initBits = 0x3L;

    private @Nullable FactoryCtx factoryCtx;
    private @Nullable Entity pipeline;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code PipelineCtx} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(PipelineCtx instance) {
      Objects.requireNonNull(instance, "instance");
      this.factoryCtx(instance.getFactoryCtx());
      this.pipeline(instance.getPipeline());
      return this;
    }

    /**
     * Initializes the value for the {@link PipelineCtx#getFactoryCtx() factoryCtx} attribute.
     * @param factoryCtx The value for factoryCtx 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder factoryCtx(FactoryCtx factoryCtx) {
      this.factoryCtx = Objects.requireNonNull(factoryCtx, "factoryCtx");
      initBits &= ~INIT_BIT_FACTORY_CTX;
      return this;
    }

    /**
     * Initializes the value for the {@link PipelineCtx#getPipeline() pipeline} attribute.
     * @param pipeline The value for pipeline 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder pipeline(Entity pipeline) {
      this.pipeline = Objects.requireNonNull(pipeline, "pipeline");
      initBits &= ~INIT_BIT_PIPELINE;
      return this;
    }

    /**
     * Builds a new {@link ImmutablePipelineCtx ImmutablePipelineCtx}.
     * @return An immutable instance of PipelineCtx
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutablePipelineCtx build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutablePipelineCtx(factoryCtx, pipeline);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_FACTORY_CTX) != 0) attributes.add("factoryCtx");
      if ((initBits & INIT_BIT_PIPELINE) != 0) attributes.add("pipeline");
      return "Cannot build PipelineCtx, some of required attributes are not set " + attributes;
    }
  }
}
