package zeenea.connector.azure.datafactory.client;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.NotNull;
import zeenea.connector.commons.util.Lazy;

/**
 * Immutable implementation of {@link FactoryCtx}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableFactoryCtx.builder()}.
 */
@Generated(from = "FactoryCtx", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableFactoryCtx implements FactoryCtx {
  @NotNull
  private final String resourceGroup;
  @NotNull
  private final String name;
  @NotNull
  private final Lazy<List<Entity>> linkedServices;

  private ImmutableFactoryCtx(
      String resourceGroup,
      String name,
      Lazy<List<Entity>> linkedServices) {
    this.resourceGroup = resourceGroup;
    this.name = name;
    this.linkedServices = linkedServices;
  }

  /**
   * @return The value of the {@code resourceGroup} attribute
   */
  @NotNull
  @Override
  public String getResourceGroup() {
    return resourceGroup;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @NotNull
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code linkedServices} attribute
   */
  @NotNull
  @Override
  public Lazy<List<Entity>> getLinkedServices() {
    return linkedServices;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FactoryCtx#getResourceGroup() resourceGroup} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for resourceGroup
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFactoryCtx withResourceGroup(String value) {
    String newValue = Objects.requireNonNull(value, "resourceGroup");
    if (this.resourceGroup.equals(newValue)) return this;
    return new ImmutableFactoryCtx(newValue, this.name, this.linkedServices);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FactoryCtx#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFactoryCtx withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableFactoryCtx(this.resourceGroup, newValue, this.linkedServices);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FactoryCtx#getLinkedServices() linkedServices} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for linkedServices
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFactoryCtx withLinkedServices(Lazy<List<Entity>> value) {
    if (this.linkedServices == value) return this;
    Lazy<List<Entity>> newValue = Objects.requireNonNull(value, "linkedServices");
    return new ImmutableFactoryCtx(this.resourceGroup, this.name, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableFactoryCtx} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableFactoryCtx
        && equalTo(0, (ImmutableFactoryCtx) another);
  }

  private boolean equalTo(int synthetic, ImmutableFactoryCtx another) {
    return resourceGroup.equals(another.resourceGroup)
        && name.equals(another.name);
  }

  /**
   * Computes a hash code from attributes: {@code resourceGroup}, {@code name}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + resourceGroup.hashCode();
    h += (h << 5) + name.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code FactoryCtx} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "FactoryCtx{"
        + "resourceGroup=" + resourceGroup
        + ", name=" + name
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link FactoryCtx} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable FactoryCtx instance
   */
  public static ImmutableFactoryCtx copyOf(FactoryCtx instance) {
    if (instance instanceof ImmutableFactoryCtx) {
      return (ImmutableFactoryCtx) instance;
    }
    return ImmutableFactoryCtx.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableFactoryCtx ImmutableFactoryCtx}.
   * <pre>
   * ImmutableFactoryCtx.builder()
   *    .resourceGroup(String) // required {@link FactoryCtx#getResourceGroup() resourceGroup}
   *    .name(String) // required {@link FactoryCtx#getName() name}
   *    .linkedServices(zeenea.connector.commons.util.Lazy&amp;lt;List&amp;lt;zeenea.connector.azure.datafactory.client.Entity&amp;gt;&amp;gt;) // required {@link FactoryCtx#getLinkedServices() linkedServices}
   *    .build();
   * </pre>
   * @return A new ImmutableFactoryCtx builder
   */
  public static ImmutableFactoryCtx.Builder builder() {
    return new ImmutableFactoryCtx.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableFactoryCtx ImmutableFactoryCtx}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "FactoryCtx", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_RESOURCE_GROUP = 0x1L;
    private static final long INIT_BIT_NAME = 0x2L;
    private static final long INIT_BIT_LINKED_SERVICES = 0x4L;
    private long initBits = 0x7L;

    private @Nullable String resourceGroup;
    private @Nullable String name;
    private @Nullable Lazy<List<Entity>> linkedServices;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code FactoryCtx} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(FactoryCtx instance) {
      Objects.requireNonNull(instance, "instance");
      this.resourceGroup(instance.getResourceGroup());
      this.name(instance.getName());
      this.linkedServices(instance.getLinkedServices());
      return this;
    }

    /**
     * Initializes the value for the {@link FactoryCtx#getResourceGroup() resourceGroup} attribute.
     * @param resourceGroup The value for resourceGroup 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder resourceGroup(String resourceGroup) {
      this.resourceGroup = Objects.requireNonNull(resourceGroup, "resourceGroup");
      initBits &= ~INIT_BIT_RESOURCE_GROUP;
      return this;
    }

    /**
     * Initializes the value for the {@link FactoryCtx#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link FactoryCtx#getLinkedServices() linkedServices} attribute.
     * @param linkedServices The value for linkedServices 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder linkedServices(Lazy<List<Entity>> linkedServices) {
      this.linkedServices = Objects.requireNonNull(linkedServices, "linkedServices");
      initBits &= ~INIT_BIT_LINKED_SERVICES;
      return this;
    }

    /**
     * Builds a new {@link ImmutableFactoryCtx ImmutableFactoryCtx}.
     * @return An immutable instance of FactoryCtx
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableFactoryCtx build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableFactoryCtx(resourceGroup, name, linkedServices);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_RESOURCE_GROUP) != 0) attributes.add("resourceGroup");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_LINKED_SERVICES) != 0) attributes.add("linkedServices");
      return "Cannot build FactoryCtx, some of required attributes are not set " + attributes;
    }
  }
}
