package zeenea.connector.azure.datafactory.client;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;

/**
 * Immutable implementation of {@link ConnectionString}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableConnectionString.builder()}.
 */
@Generated(from = "ConnectionString", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableConnectionString
    implements ConnectionString {
  private final @Nullable String text;
  private final @Nullable AzureKeyVault keyVault;

  private ImmutableConnectionString(
      @Nullable String text,
      @Nullable AzureKeyVault keyVault) {
    this.text = text;
    this.keyVault = keyVault;
  }

  /**
   * @return The value of the {@code text} attribute
   */
  @JsonProperty("text")
  @Override
  public @Nullable String getText() {
    return text;
  }

  /**
   * @return The value of the {@code keyVault} attribute
   */
  @JsonProperty("keyVault")
  @Override
  public @Nullable AzureKeyVault getKeyVault() {
    return keyVault;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ConnectionString#getText() text} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for text (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConnectionString withText(@Nullable String value) {
    if (Objects.equals(this.text, value)) return this;
    return new ImmutableConnectionString(value, this.keyVault);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ConnectionString#getKeyVault() keyVault} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for keyVault (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConnectionString withKeyVault(@Nullable AzureKeyVault value) {
    if (this.keyVault == value) return this;
    return new ImmutableConnectionString(this.text, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableConnectionString} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableConnectionString
        && equalTo(0, (ImmutableConnectionString) another);
  }

  private boolean equalTo(int synthetic, ImmutableConnectionString another) {
    return Objects.equals(text, another.text)
        && Objects.equals(keyVault, another.keyVault);
  }

  /**
   * Computes a hash code from attributes: {@code text}, {@code keyVault}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(text);
    h += (h << 5) + Objects.hashCode(keyVault);
    return h;
  }

  /**
   * Prints the immutable value {@code ConnectionString} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ConnectionString{"
        + "text=" + text
        + ", keyVault=" + keyVault
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "ConnectionString", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements ConnectionString {
    @javax.annotation.Nullable String text;
    @javax.annotation.Nullable AzureKeyVault keyVault;
    @JsonProperty("text")
    public void setText(@Nullable String text) {
      this.text = text;
    }
    @JsonProperty("keyVault")
    public void setKeyVault(@Nullable AzureKeyVault keyVault) {
      this.keyVault = keyVault;
    }
    @Override
    public String getText() { throw new UnsupportedOperationException(); }
    @Override
    public AzureKeyVault getKeyVault() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableConnectionString fromJson(Json json) {
    ImmutableConnectionString.Builder builder = ImmutableConnectionString.builder();
    if (json.text != null) {
      builder.text(json.text);
    }
    if (json.keyVault != null) {
      builder.keyVault(json.keyVault);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ConnectionString} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ConnectionString instance
   */
  public static ImmutableConnectionString copyOf(ConnectionString instance) {
    if (instance instanceof ImmutableConnectionString) {
      return (ImmutableConnectionString) instance;
    }
    return ImmutableConnectionString.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableConnectionString ImmutableConnectionString}.
   * <pre>
   * ImmutableConnectionString.builder()
   *    .text(String | null) // nullable {@link ConnectionString#getText() text}
   *    .keyVault(zeenea.connector.azure.datafactory.client.AzureKeyVault | null) // nullable {@link ConnectionString#getKeyVault() keyVault}
   *    .build();
   * </pre>
   * @return A new ImmutableConnectionString builder
   */
  public static ImmutableConnectionString.Builder builder() {
    return new ImmutableConnectionString.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableConnectionString ImmutableConnectionString}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ConnectionString", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @javax.annotation.Nullable String text;
    private @javax.annotation.Nullable AzureKeyVault keyVault;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ConnectionString} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ConnectionString instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable String textValue = instance.getText();
      if (textValue != null) {
        text(textValue);
      }
      @Nullable AzureKeyVault keyVaultValue = instance.getKeyVault();
      if (keyVaultValue != null) {
        keyVault(keyVaultValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ConnectionString#getText() text} attribute.
     * @param text The value for text (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("text")
    public final Builder text(@Nullable String text) {
      this.text = text;
      return this;
    }

    /**
     * Initializes the value for the {@link ConnectionString#getKeyVault() keyVault} attribute.
     * @param keyVault The value for keyVault (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("keyVault")
    public final Builder keyVault(@Nullable AzureKeyVault keyVault) {
      this.keyVault = keyVault;
      return this;
    }

    /**
     * Builds a new {@link ImmutableConnectionString ImmutableConnectionString}.
     * @return An immutable instance of ConnectionString
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableConnectionString build() {
      return new ImmutableConnectionString(text, keyVault);
    }
  }
}
