package zeenea.connector.azure.datafactory.client;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;
import zeenea.connector.azure.datafactory.client.deserializer.ParameterDeserializer;

/**
 * Immutable implementation of {@link AzureKeyVault}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableAzureKeyVault.builder()}.
 */
@Generated(from = "AzureKeyVault", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableAzureKeyVault implements AzureKeyVault {
  private final @Nullable String type;
  private final @Nullable NameTypeObject store;
  private final @Nullable String secretName;
  private final @Nullable String secretVersion;

  private ImmutableAzureKeyVault(
      @Nullable String type,
      @Nullable NameTypeObject store,
      @Nullable String secretName,
      @Nullable String secretVersion) {
    this.type = type;
    this.store = store;
    this.secretName = secretName;
    this.secretVersion = secretVersion;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty("type")
  @Override
  public @Nullable String getType() {
    return type;
  }

  /**
   * @return The value of the {@code store} attribute
   */
  @JsonProperty("store")
  @Override
  public @Nullable NameTypeObject getStore() {
    return store;
  }

  /**
   * @return The value of the {@code secretName} attribute
   */
  @JsonDeserialize(using = ParameterDeserializer.class)
  @JsonProperty("secretName")
  @Override
  public @Nullable String getSecretName() {
    return secretName;
  }

  /**
   * @return The value of the {@code secretVersion} attribute
   */
  @JsonProperty("secretVersion")
  @Override
  public @Nullable String getSecretVersion() {
    return secretVersion;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AzureKeyVault#getType() type} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAzureKeyVault withType(@Nullable String value) {
    if (Objects.equals(this.type, value)) return this;
    return new ImmutableAzureKeyVault(value, this.store, this.secretName, this.secretVersion);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AzureKeyVault#getStore() store} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for store (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAzureKeyVault withStore(@Nullable NameTypeObject value) {
    if (this.store == value) return this;
    return new ImmutableAzureKeyVault(this.type, value, this.secretName, this.secretVersion);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AzureKeyVault#getSecretName() secretName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for secretName (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAzureKeyVault withSecretName(@Nullable String value) {
    if (Objects.equals(this.secretName, value)) return this;
    return new ImmutableAzureKeyVault(this.type, this.store, value, this.secretVersion);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AzureKeyVault#getSecretVersion() secretVersion} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for secretVersion (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAzureKeyVault withSecretVersion(@Nullable String value) {
    if (Objects.equals(this.secretVersion, value)) return this;
    return new ImmutableAzureKeyVault(this.type, this.store, this.secretName, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableAzureKeyVault} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableAzureKeyVault
        && equalTo(0, (ImmutableAzureKeyVault) another);
  }

  private boolean equalTo(int synthetic, ImmutableAzureKeyVault another) {
    return Objects.equals(type, another.type)
        && Objects.equals(store, another.store)
        && Objects.equals(secretName, another.secretName)
        && Objects.equals(secretVersion, another.secretVersion);
  }

  /**
   * Computes a hash code from attributes: {@code type}, {@code store}, {@code secretName}, {@code secretVersion}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(type);
    h += (h << 5) + Objects.hashCode(store);
    h += (h << 5) + Objects.hashCode(secretName);
    h += (h << 5) + Objects.hashCode(secretVersion);
    return h;
  }

  /**
   * Prints the immutable value {@code AzureKeyVault} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "AzureKeyVault{"
        + "type=" + type
        + ", store=" + store
        + ", secretName=" + secretName
        + ", secretVersion=" + secretVersion
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "AzureKeyVault", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements AzureKeyVault {
    @javax.annotation.Nullable String type;
    @javax.annotation.Nullable NameTypeObject store;
    @javax.annotation.Nullable String secretName;
    @javax.annotation.Nullable String secretVersion;
    @JsonProperty("type")
    public void setType(@Nullable String type) {
      this.type = type;
    }
    @JsonProperty("store")
    public void setStore(@Nullable NameTypeObject store) {
      this.store = store;
    }
    @JsonDeserialize(using = ParameterDeserializer.class)
    @JsonProperty("secretName")
    public void setSecretName(@Nullable String secretName) {
      this.secretName = secretName;
    }
    @JsonProperty("secretVersion")
    public void setSecretVersion(@Nullable String secretVersion) {
      this.secretVersion = secretVersion;
    }
    @Override
    public String getType() { throw new UnsupportedOperationException(); }
    @Override
    public NameTypeObject getStore() { throw new UnsupportedOperationException(); }
    @Override
    public String getSecretName() { throw new UnsupportedOperationException(); }
    @Override
    public String getSecretVersion() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableAzureKeyVault fromJson(Json json) {
    ImmutableAzureKeyVault.Builder builder = ImmutableAzureKeyVault.builder();
    if (json.type != null) {
      builder.type(json.type);
    }
    if (json.store != null) {
      builder.store(json.store);
    }
    if (json.secretName != null) {
      builder.secretName(json.secretName);
    }
    if (json.secretVersion != null) {
      builder.secretVersion(json.secretVersion);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link AzureKeyVault} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable AzureKeyVault instance
   */
  public static ImmutableAzureKeyVault copyOf(AzureKeyVault instance) {
    if (instance instanceof ImmutableAzureKeyVault) {
      return (ImmutableAzureKeyVault) instance;
    }
    return ImmutableAzureKeyVault.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableAzureKeyVault ImmutableAzureKeyVault}.
   * <pre>
   * ImmutableAzureKeyVault.builder()
   *    .type(String | null) // nullable {@link AzureKeyVault#getType() type}
   *    .store(zeenea.connector.azure.datafactory.client.NameTypeObject | null) // nullable {@link AzureKeyVault#getStore() store}
   *    .secretName(String | null) // nullable {@link AzureKeyVault#getSecretName() secretName}
   *    .secretVersion(String | null) // nullable {@link AzureKeyVault#getSecretVersion() secretVersion}
   *    .build();
   * </pre>
   * @return A new ImmutableAzureKeyVault builder
   */
  public static ImmutableAzureKeyVault.Builder builder() {
    return new ImmutableAzureKeyVault.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableAzureKeyVault ImmutableAzureKeyVault}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "AzureKeyVault", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @javax.annotation.Nullable String type;
    private @javax.annotation.Nullable NameTypeObject store;
    private @javax.annotation.Nullable String secretName;
    private @javax.annotation.Nullable String secretVersion;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code AzureKeyVault} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(AzureKeyVault instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable String typeValue = instance.getType();
      if (typeValue != null) {
        type(typeValue);
      }
      @Nullable NameTypeObject storeValue = instance.getStore();
      if (storeValue != null) {
        store(storeValue);
      }
      @Nullable String secretNameValue = instance.getSecretName();
      if (secretNameValue != null) {
        secretName(secretNameValue);
      }
      @Nullable String secretVersionValue = instance.getSecretVersion();
      if (secretVersionValue != null) {
        secretVersion(secretVersionValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link AzureKeyVault#getType() type} attribute.
     * @param type The value for type (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("type")
    public final Builder type(@Nullable String type) {
      this.type = type;
      return this;
    }

    /**
     * Initializes the value for the {@link AzureKeyVault#getStore() store} attribute.
     * @param store The value for store (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("store")
    public final Builder store(@Nullable NameTypeObject store) {
      this.store = store;
      return this;
    }

    /**
     * Initializes the value for the {@link AzureKeyVault#getSecretName() secretName} attribute.
     * @param secretName The value for secretName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonDeserialize(using = ParameterDeserializer.class)
    @JsonProperty("secretName")
    public final Builder secretName(@Nullable String secretName) {
      this.secretName = secretName;
      return this;
    }

    /**
     * Initializes the value for the {@link AzureKeyVault#getSecretVersion() secretVersion} attribute.
     * @param secretVersion The value for secretVersion (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("secretVersion")
    public final Builder secretVersion(@Nullable String secretVersion) {
      this.secretVersion = secretVersion;
      return this;
    }

    /**
     * Builds a new {@link ImmutableAzureKeyVault ImmutableAzureKeyVault}.
     * @return An immutable instance of AzureKeyVault
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableAzureKeyVault build() {
      return new ImmutableAzureKeyVault(type, store, secretName, secretVersion);
    }
  }
}
