/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.http.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import java.io.IOException;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.ByteArrayEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import zeenea.connector.commons.http.client.ContentTypeUtil;
import zeenea.connector.commons.http.client.EntityMapper;
import zeenea.connector.commons.json.JsonParsingException;
import zeenea.connector.commons.json.YamlMapper;

public enum HttpYamlMapper implements EntityMapper
{
    INSTANCE;

    private final YamlMapper mapper = YamlMapper.of();

    public static HttpYamlMapper of() {
        return INSTANCE;
    }

    @Override
    public <T> T readEntity(HttpEntity entity, JavaType type) throws IOException, ParseException {
        String body = EntityUtils.toString((HttpEntity)entity);
        try {
            return (T)this.mapper.getMapper().readValue(body, type);
        }
        catch (JsonProcessingException e) {
            throw new JsonParsingException(String.format("Failed parsing response to '%s': '%s'", type.getTypeName(), e.getMessage()), body, (Throwable)e);
        }
    }

    @Override
    public <T> HttpEntity writeAsEntity(T content) {
        return new ByteArrayEntity(this.mapper.writeAsBytes(content), ContentTypeUtil.APPLICATION_YAML);
    }

    @Override
    public <T> String prettyPrint(T o) {
        return null;
    }
}

