/*
 * Decompiled with CFR 0.152.
 */
package scalaj.http;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URLDecoder;
import java.net.URLEncoder;
import scala.Array;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.matching.Regex;
import scalaj.http.Base64;
import scalaj.http.HttpOptions$;
import scalaj.http.Token;

public final class HttpConstants$ {
    public static final HttpConstants$ MODULE$ = new HttpConstants$();
    private static final Regex CharsetRegex = new Regex("(?i)\\bcharset=\\s*\"?([^\\s;\"]*)", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
    private static final Function2<HttpURLConnection, Object, BoxedUnit> setFixedLengthStreamingMode = (Function2 & Serializable)(x0$1, x1$1) -> {
        HttpConstants$.$anonfun$setFixedLengthStreamingMode$1(x0$1, BoxesRunTime.unboxToLong((Object)x1$1));
        return BoxedUnit.UNIT;
    };
    private static final String utf8 = "UTF-8";

    public Regex CharsetRegex() {
        return CharsetRegex;
    }

    public Seq<Function1<HttpURLConnection, BoxedUnit>> defaultOptions() {
        return (Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{HttpOptions$.MODULE$.connTimeout(1000), HttpOptions$.MODULE$.readTimeout(5000), HttpOptions$.MODULE$.followRedirects(false)}));
    }

    public Function2<HttpURLConnection, Object, BoxedUnit> setFixedLengthStreamingMode() {
        return setFixedLengthStreamingMode;
    }

    public String urlEncode(String name, String charset) {
        return URLEncoder.encode(name, charset);
    }

    public String urlDecode(String name, String charset) {
        return URLDecoder.decode(name, charset);
    }

    public String base64(byte[] bytes) {
        return new String(Base64.encode(bytes));
    }

    public String base64(String in) {
        return this.base64(in.getBytes(this.utf8()));
    }

    public String basicAuthValue(String user, String password) {
        return new StringBuilder(6).append("Basic ").append(this.base64(new StringBuilder(1).append(user).append(":").append(password).toString())).toString();
    }

    public String toQs(Seq<Tuple2<String, String>> params, String charset) {
        return ((IterableOnceOps)params.map((Function1 & Serializable)p -> new StringBuilder(1).append(MODULE$.urlEncode((String)p._1(), charset)).append("=").append(MODULE$.urlEncode((String)p._2(), charset)).toString())).mkString("&");
    }

    public String appendQs(String url, Seq<Tuple2<String, String>> params, String charset) {
        return new StringBuilder(0).append(url).append((Object)(params.isEmpty() ? "" : new StringBuilder(0).append(url.contains("?") ? "&" : "?").append(this.toQs(params, charset)).toString())).toString();
    }

    public String readString(InputStream is) {
        return this.readString(is, this.utf8());
    }

    public String readString(InputStream is, String charset) {
        String string;
        if (is == null) {
            string = "";
        } else {
            InputStreamReader in = new InputStreamReader(is, charset);
            scala.collection.mutable.StringBuilder bos = new scala.collection.mutable.StringBuilder();
            char[] ba = new char[4096];
            this.readOnce$2(in, ba, bos);
            string = bos.toString();
        }
        return string;
    }

    public byte[] readBytes(InputStream in) {
        byte[] byArray;
        if (in == null) {
            byArray = (byte[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, (ClassTag)ClassTag$.MODULE$.Byte());
        } else {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] ba = new byte[4096];
            this.readOnce$3(in, ba, bos);
            byArray = bos.toByteArray();
        }
        return byArray;
    }

    public Seq<Tuple2<String, String>> readParams(InputStream in, String charset) {
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])this.readString(in, charset).split("&")), (Function1 & Serializable)x$23 -> {
            None$ none$;
            Object object;
            String[] stringArray = x$23.split("=");
            if (stringArray != null && !Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray)) && new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 2) == 0) {
                String k = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
                String v = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1);
                none$ = new Some((Object)new Tuple2((Object)MODULE$.urlDecode(k, charset), (Object)MODULE$.urlDecode(v, charset)));
            } else {
                none$ = None$.MODULE$;
            }
            return none$;
        }, ClassTag$.MODULE$.apply(Tuple2.class))).toList();
    }

    public String readParams$default$2() {
        return this.utf8();
    }

    public Map<String, String> readParamMap(InputStream in, String charset) {
        return (Map)Predef$.MODULE$.Map().apply(this.readParams(in, charset));
    }

    public String readParamMap$default$2() {
        return this.utf8();
    }

    public Token readToken(InputStream in) {
        Map<String, String> params = this.readParamMap(in, this.readParamMap$default$2());
        return new Token((String)params.apply((Object)"oauth_token"), (String)params.apply((Object)"oauth_token_secret"));
    }

    public Proxy proxy(String host, int port, Proxy.Type proxyType) {
        return new Proxy(proxyType, new InetSocketAddress(host, port));
    }

    public Proxy.Type proxy$default$3() {
        return Proxy.Type.HTTP;
    }

    public String utf8() {
        return utf8;
    }

    public static final /* synthetic */ void $anonfun$setFixedLengthStreamingMode$1(HttpURLConnection x0$1, long x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)x0$1, (Object)BoxesRunTime.boxToLong((long)x1$1));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        HttpURLConnection connection = (HttpURLConnection)tuple2._1();
        long contentLength = tuple2._2$mcJ$sp();
        connection.setFixedLengthStreamingMode(contentLength);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private final void readOnce$2(InputStreamReader in$1, char[] ba$1, scala.collection.mutable.StringBuilder bos$1) {
        int len;
        do {
            Object object = (len = in$1.read(ba$1)) > 0 ? bos$1.appendAll(ba$1, 0, len) : BoxedUnit.UNIT;
        } while (len >= 0);
    }

    private final void readOnce$3(InputStream in$2, byte[] ba$2, ByteArrayOutputStream bos$2) {
        int len;
        do {
            if ((len = in$2.read(ba$2)) <= 0) continue;
            bos$2.write(ba$2, 0, len);
        } while (len >= 0);
    }

    private HttpConstants$() {
    }
}

