/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.ptf;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.trino.spi.ptf.Argument;
import io.trino.spi.type.Type;
import java.util.Objects;

public class ScalarArgument
extends Argument {
    private final Type type;
    private final Object value;

    @JsonCreator
    public ScalarArgument(@JsonProperty(value="type") Type type, @JsonProperty(value="value") Object value) {
        this.type = Objects.requireNonNull(type, "type is null");
        this.value = value;
    }

    @JsonProperty
    public Type getType() {
        return this.type;
    }

    @JsonProperty
    public Object getValue() {
        return this.value;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Type type;
        private Object value;

        private Builder() {
        }

        public Builder type(Type type) {
            this.type = type;
            return this;
        }

        public Builder value(Object value) {
            this.value = value;
            return this;
        }

        public ScalarArgument build() {
            return new ScalarArgument(this.type, this.value);
        }
    }
}

