/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.log;

import java.time.Duration;
import java.time.Instant;
import org.jetbrains.annotations.NotNull;

public class Durations {
    private static final Duration TEN_MILLIS = Duration.ofMillis(10L);

    @NotNull
    public static String elapsedSince(@NotNull Instant startTime) {
        StringBuilder sb = new StringBuilder();
        Durations.appendTo(sb, startTime, Instant.now());
        return sb.toString();
    }

    @NotNull
    public static String toString(@NotNull Duration duration) {
        StringBuilder sb = new StringBuilder();
        Durations.appendTo(sb, duration);
        return sb.toString();
    }

    public static void appendTo(StringBuilder sb, Instant startTime, Instant endTime) {
        Durations.appendTo(sb, Duration.between(startTime, endTime));
    }

    public static void appendTo(StringBuilder sb, Duration duration) {
        if (duration.isZero()) {
            sb.append("0 ms");
            return;
        }
        if (duration.isNegative()) {
            sb.append("- ");
            Durations.appendTo(sb, duration.negated());
        } else if (duration.compareTo(TEN_MILLIS) >= 0) {
            long millis;
            long seconds;
            long minutes;
            boolean nonEmpty = false;
            long hours = duration.toHours();
            if (hours > 0L) {
                sb.append(hours).append(" h");
                duration = duration.minusHours(hours);
                nonEmpty = true;
            }
            if ((minutes = duration.toMinutes()) > 0L) {
                if (nonEmpty) {
                    sb.append(' ');
                }
                sb.append(minutes).append(" m");
                duration = duration.minusMinutes(minutes);
                nonEmpty = true;
            }
            if ((seconds = duration.getSeconds()) > 0L) {
                if (nonEmpty) {
                    sb.append(' ');
                }
                sb.append(seconds).append(" s");
                duration = duration.minusSeconds(seconds);
                nonEmpty = true;
            }
            if ((millis = duration.toMillis()) > 0L) {
                if (nonEmpty) {
                    sb.append(' ');
                }
                sb.append(millis).append(" ms");
            }
        } else {
            int nanos = duration.getNano();
            if (nanos >= 1000000) {
                sb.append(nanos / 1000000).append(" ms");
                if ((nanos %= 1000000) >= 1000) {
                    sb.append(' ').append(nanos / 1000).append(" \u03bcs");
                }
            } else if (nanos >= 1000) {
                int micros = nanos / 1000;
                sb.append(micros).append(" \u03bcs");
                if ((nanos %= 1000) >= 1) {
                    sb.append(' ').append(nanos).append(" ns");
                }
            } else {
                sb.append(nanos).append(" ns");
            }
        }
    }
}

