/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.filesystem.schema.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.InputStream;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOps;
import scala.collection.immutable.ListMap;
import scala.collection.immutable.ListMap$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import zeenea.connector.filesystem.FileSystemClient;
import zeenea.connector.filesystem.FileSystemFile;
import zeenea.connector.filesystem.FileSystemItem;
import zeenea.connector.filesystem.io.CompressionUtils$;
import zeenea.connector.filesystem.schema.SchemaExtractor;
import zeenea.connector.filesystem.schema.json.BooleanJsonValueType$;
import zeenea.connector.filesystem.schema.json.EmptyJsonValueType$;
import zeenea.connector.filesystem.schema.json.IntegerJsonValueType$;
import zeenea.connector.filesystem.schema.json.JsonField;
import zeenea.connector.filesystem.schema.json.JsonField$;
import zeenea.connector.filesystem.schema.json.JsonSchemaException;
import zeenea.connector.filesystem.schema.json.JsonSchemaException$;
import zeenea.connector.filesystem.schema.json.JsonSchemaExtractor$;
import zeenea.connector.filesystem.schema.json.JsonValueType;
import zeenea.connector.filesystem.schema.json.JsonValueType$;
import zeenea.connector.filesystem.schema.json.NullJsonValueType$;
import zeenea.connector.filesystem.schema.json.NumberJsonValueType$;
import zeenea.connector.filesystem.schema.json.ObjectJsonValueType$;
import zeenea.connector.libs.scala.functions;
import zeenea.connector.libs.scala.functions$;
import zeenea.connector.source.PropertyValues;
import zeenea.connector.source.SourceField;
import zeenea.connector.source.SourceField$;
import zeenea.connector.source.SourceItemName;
import zeenea.connector.source.SourceItemName$;
import zeenea.connector.source.datatype.package;

@ScalaSignature(bytes="\u0006\u0005\u0005%d\u0001\u0002\u000b\u0016\u0001\u0001B\u0001b\u000b\u0001\u0003\u0002\u0003\u0006I\u0001\f\u0005\u0006a\u0001!\t!\r\u0005\bk\u0001\u0011\r\u0011\"\u00037\u0011\u0019Q\u0004\u0001)A\u0005o!91\b\u0001b\u0001\n\u0013a\u0004BB#\u0001A\u0003%Q\bC\u0004G\u0001\t\u0007I\u0011B$\t\rQ\u0003\u0001\u0015!\u0003I\u0011\u0015)\u0006\u0001\"\u0011W\u0011\u00159\b\u0001\"\u0003y\u0011\u001d\t\u0019\u0001\u0001C\u0005\u0003\u000bAq!!\u0003\u0001\t\u0013\tY\u0001C\u0004\u0002\u0010\u0001!I!!\u0005\t\u000f\u0005%\u0002\u0001\"\u0003\u0002,!9\u00111\u000b\u0001\u0005\n\u0005UsaBA.+!\u0005\u0011Q\f\u0004\u0007)UA\t!a\u0018\t\rA\nB\u0011AA1\u0011\u001d\t\u0019'\u0005C\u0001\u0003K\u00121CS:p]N\u001b\u0007.Z7b\u000bb$(/Y2u_JT!AF\f\u0002\t)\u001cxN\u001c\u0006\u00031e\taa]2iK6\f'B\u0001\u000e\u001c\u0003)1\u0017\u000e\\3tsN$X-\u001c\u0006\u00039u\t\u0011bY8o]\u0016\u001cGo\u001c:\u000b\u0003y\taA_3f]\u0016\f7\u0001A\n\u0004\u0001\u0005:\u0003C\u0001\u0012&\u001b\u0005\u0019#\"\u0001\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019\u001a#AB!osJ+g\r\u0005\u0002)S5\tq#\u0003\u0002+/\ty1k\u00195f[\u0006,\u0005\u0010\u001e:bGR|'/\u0001\u0005gg\u000ec\u0017.\u001a8u!\tic&D\u0001\u001a\u0013\ty\u0013D\u0001\tGS2,7+_:uK6\u001cE.[3oi\u00061A(\u001b8jiz\"\"A\r\u001b\u0011\u0005M\u0002Q\"A\u000b\t\u000b-\u0012\u0001\u0019\u0001\u0017\u0002\u0015M\fW\u000e\u001d7f'&TX-F\u00018!\t\u0011\u0003(\u0003\u0002:G\t\u0019\u0011J\u001c;\u0002\u0017M\fW\u000e\u001d7f'&TX\rI\u0001\u000ee>|GOR5fY\u0012t\u0015-\\3\u0016\u0003u\u0002\"AP\"\u000e\u0003}R!\u0001Q!\u0002\t1\fgn\u001a\u0006\u0002\u0005\u0006!!.\u0019<b\u0013\t!uH\u0001\u0004TiJLgnZ\u0001\u000fe>|GOR5fY\u0012t\u0015-\\3!\u0003\u001d1\u0017m\u0019;pef,\u0012\u0001\u0013\t\u0003\u0013Jk\u0011A\u0013\u0006\u0003\u00172\u000bAaY8sK*\u0011QJT\u0001\bU\u0006\u001c7n]8o\u0015\ty\u0005+A\u0005gCN$XM\u001d=nY*\t\u0011+A\u0002d_6L!a\u0015&\u0003\u0017)\u001bxN\u001c$bGR|'/_\u0001\tM\u0006\u001cGo\u001c:zA\u0005Iq-\u001a;TG\",W.\u0019\u000b\u0003/J\u00042\u0001W.^\u001b\u0005I&B\u0001.$\u0003\u0011)H/\u001b7\n\u0005qK&a\u0001+ssB\u0019!E\u00181\n\u0005}\u001b#AB(qi&|g\u000eE\u0002bS2t!AY4\u000f\u0005\r4W\"\u00013\u000b\u0005\u0015|\u0012A\u0002\u001fs_>$h(C\u0001%\u0013\tA7%A\u0004qC\u000e\\\u0017mZ3\n\u0005)\\'aA*fc*\u0011\u0001n\t\t\u0003[Bl\u0011A\u001c\u0006\u0003_n\taa]8ve\u000e,\u0017BA9o\u0005-\u0019v.\u001e:dK\u001aKW\r\u001c3\t\u000bML\u0001\u0019\u0001;\u0002\r\u0019\u001c\u0018\n^3n!\tiS/\u0003\u0002w3\tqa)\u001b7f'f\u001cH/Z7Ji\u0016l\u0017!E3yiJ\f7\r^!mY\u000e{g\u000e^3oiR\u0011\u0011\u0010 \t\u0003giL!a_\u000b\u0003\u0013)\u001bxN\u001c$jK2$\u0007\"B?\u000b\u0001\u0004q\u0018A\u00036t_:\u0004\u0016M]:feB\u0011\u0011j`\u0005\u0004\u0003\u0003Q%A\u0003&t_:\u0004\u0016M]:fe\u0006qQ\r\u001f;sC\u000e$8i\u001c8uK:$HcA=\u0002\b!)Qp\u0003a\u0001}\u0006Y!/Z1e\u0007>tG/\u001a8u)\rI\u0018Q\u0002\u0005\u0006{2\u0001\rA`\u0001\rKb$(/Y2u\u0003J\u0014\u0018-\u001f\u000b\u0006s\u0006M\u0011Q\u0003\u0005\u0006{6\u0001\rA \u0005\b\u0003/i\u0001\u0019AA\r\u0003%IG/Z7GS\u0016dG\rE\u0002#=fD3!DA\u000f!\u0011\ty\"!\n\u000e\u0005\u0005\u0005\"bAA\u0012G\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\u001d\u0012\u0011\u0005\u0002\bi\u0006LGN]3d\u00035)\u0007\u0010\u001e:bGR|%M[3diR)\u00110!\f\u00020!)QP\u0004a\u0001}\"9\u0011\u0011\u0007\bA\u0002\u0005M\u0012\u0001C2iS2$'/\u001a8\u0011\u000f\u0005U\u0012qHA\"s6\u0011\u0011q\u0007\u0006\u0005\u0003s\tY$A\u0005j[6,H/\u00192mK*\u0019\u0011QH\u0012\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002B\u0005]\"a\u0002'jgRl\u0015\r\u001d\t\u0005\u0003\u000b\niE\u0004\u0003\u0002H\u0005%\u0003CA2$\u0013\r\tYeI\u0001\u0007!J,G-\u001a4\n\u0007\u0011\u000byEC\u0002\u0002L\rB3ADA\u000f\u0003-\u0019x.\u001e:dK\u001aKW\r\u001c3\u0015\u0007\u0001\f9\u0006\u0003\u0004\u0002Z=\u0001\r!_\u0001\u0006M&,G\u000eZ\u0001\u0014\u0015N|gnU2iK6\fW\t\u001f;sC\u000e$xN\u001d\t\u0003gE\u0019\"!E\u0011\u0015\u0005\u0005u\u0013!B1qa2LHc\u0001\u001a\u0002h!)1f\u0005a\u0001Y\u0001")
public class JsonSchemaExtractor
implements SchemaExtractor {
    private final FileSystemClient fsClient;
    private final int sampleSize;
    private final String rootFieldName;
    private final JsonFactory factory;

    public static JsonSchemaExtractor apply(FileSystemClient fsClient) {
        return JsonSchemaExtractor$.MODULE$.apply(fsClient);
    }

    @Override
    public <B> Try<Option<B>> onNotEmptyFile(FileSystemItem fsItem, Function1<FileSystemFile, Try<Option<B>>> block) {
        return SchemaExtractor.onNotEmptyFile$(this, fsItem, block);
    }

    private int sampleSize() {
        return this.sampleSize;
    }

    private String rootFieldName() {
        return this.rootFieldName;
    }

    private JsonFactory factory() {
        return this.factory;
    }

    @Override
    public Try<Option<Seq<SourceField>>> getSchema(FileSystemItem fsItem) {
        return this.onNotEmptyFile(fsItem, (Function1 & Serializable)fsFile -> functions.TryOfResourceUser$.MODULE$.use$extension(functions$.MODULE$.TryOfResourceUser($this.fsClient.inputStream((FileSystemFile)fsFile)), (Function1 & Serializable)inputStream -> functions.TryOfResourceUser$.MODULE$.use$extension(functions$.MODULE$.TryOfResourceUser(CompressionUtils$.MODULE$.decompressStream((InputStream)inputStream)), (Function1 & Serializable)plainStream -> (Try)functions.ResourceUser$.MODULE$.use$extension(functions$.MODULE$.ResourceUser((AutoCloseable)this.factory().createParser(plainStream)), (Function1 & Serializable)jsonParser -> Try$.MODULE$.apply((Function0 & Serializable)() -> this.extractAllContent((JsonParser)jsonParser)).map((Function1 & Serializable)jsonContent -> new Some(this.sourceField((JsonField)jsonContent)))))));
    }

    private JsonField extractAllContent(JsonParser jsonParser) {
        return this.loop$1(jsonParser, (Option)None$.MODULE$, 0);
    }

    private JsonField extractContent(JsonParser jsonParser) {
        JsonToken token = (JsonToken)Option$.MODULE$.apply((Object)jsonParser.nextToken()).getOrElse((Function0 & Serializable)() -> {
            throw new JsonSchemaException(JsonSchemaException$.MODULE$.$lessinit$greater$default$1());
        });
        if (token.isStructStart() || token.isScalarValue()) {
            return this.readContent(jsonParser);
        }
        throw new JsonSchemaException(JsonSchemaException$.MODULE$.$lessinit$greater$default$1());
    }

    private JsonField readContent(JsonParser jsonParser) {
        JsonToken jsonToken = jsonParser.currentToken();
        if (JsonToken.START_OBJECT.equals(jsonToken)) {
            return this.extractObject(jsonParser, (ListMap<String, JsonField>)((ListMap)ListMap$.MODULE$.apply((Seq)Nil$.MODULE$)));
        }
        if (JsonToken.START_ARRAY.equals(jsonToken)) {
            JsonField a = this.extractArray(jsonParser, (Option<JsonField>)None$.MODULE$);
            return a;
        }
        if (JsonToken.VALUE_STRING.equals(jsonToken)) {
            return new JsonField(JsonValueType$.MODULE$.from(jsonParser.getText()), JsonField$.MODULE$.apply$default$2(), JsonField$.MODULE$.apply$default$3(), JsonField$.MODULE$.apply$default$4());
        }
        if (JsonToken.VALUE_NUMBER_INT.equals(jsonToken)) {
            return new JsonField(IntegerJsonValueType$.MODULE$, JsonField$.MODULE$.apply$default$2(), JsonField$.MODULE$.apply$default$3(), JsonField$.MODULE$.apply$default$4());
        }
        if (JsonToken.VALUE_NUMBER_FLOAT.equals(jsonToken)) {
            return new JsonField(NumberJsonValueType$.MODULE$, JsonField$.MODULE$.apply$default$2(), JsonField$.MODULE$.apply$default$3(), JsonField$.MODULE$.apply$default$4());
        }
        if (JsonToken.VALUE_TRUE.equals(jsonToken)) {
            return new JsonField(BooleanJsonValueType$.MODULE$, JsonField$.MODULE$.apply$default$2(), JsonField$.MODULE$.apply$default$3(), JsonField$.MODULE$.apply$default$4());
        }
        if (JsonToken.VALUE_FALSE.equals(jsonToken)) {
            return new JsonField(BooleanJsonValueType$.MODULE$, JsonField$.MODULE$.apply$default$2(), JsonField$.MODULE$.apply$default$3(), JsonField$.MODULE$.apply$default$4());
        }
        if (JsonToken.VALUE_NULL.equals(jsonToken)) {
            return new JsonField(NullJsonValueType$.MODULE$, JsonField$.MODULE$.apply$default$2(), JsonField$.MODULE$.apply$default$3(), JsonField$.MODULE$.apply$default$4());
        }
        throw new JsonSchemaException(JsonSchemaException$.MODULE$.$lessinit$greater$default$1());
    }

    private JsonField extractArray(JsonParser jsonParser, Option<JsonField> itemField) {
        while (true) {
            JsonToken token;
            JsonToken jsonToken = token = (JsonToken)Option$.MODULE$.apply((Object)jsonParser.nextToken()).getOrElse((Function0 & Serializable)() -> {
                throw new JsonSchemaException(JsonSchemaException$.MODULE$.$lessinit$greater$default$1());
            });
            JsonToken jsonToken2 = JsonToken.END_ARRAY;
            if (!(jsonToken != null ? !jsonToken.equals(jsonToken2) : jsonToken2 != null)) {
                return (JsonField)itemField.map((Function1 & Serializable)i -> new JsonField(JsonValueType$.MODULE$.arrayOf(i.valueType()), i.nullable(), true, i.children())).getOrElse((Function0 & Serializable)() -> {
                    JsonValueType x$1 = JsonValueType$.MODULE$.arrayOf(EmptyJsonValueType$.MODULE$);
                    boolean x$2 = true;
                    boolean x$3 = JsonField$.MODULE$.apply$default$2();
                    ListMap<String, JsonField> x$4 = JsonField$.MODULE$.apply$default$4();
                    return new JsonField(x$1, x$3, true, x$4);
                });
            }
            if (!token.isStructStart() && !token.isScalarValue()) break;
            JsonField nextItem = this.readContent(jsonParser);
            JsonField merged = (JsonField)itemField.map((Function1 & Serializable)i -> i.union(nextItem)).getOrElse((Function0 & Serializable)() -> nextItem);
            itemField = new Some((Object)merged);
        }
        throw new JsonSchemaException(JsonSchemaException$.MODULE$.$lessinit$greater$default$1());
    }

    private JsonField extractObject(JsonParser jsonParser, ListMap<String, JsonField> children) {
        while (true) {
            JsonToken token;
            JsonToken jsonToken;
            if (JsonToken.END_OBJECT.equals(jsonToken = (token = (JsonToken)Option$.MODULE$.apply((Object)jsonParser.nextToken()).getOrElse((Function0 & Serializable)() -> {
                throw new JsonSchemaException(JsonSchemaException$.MODULE$.$lessinit$greater$default$1());
            })))) {
                ObjectJsonValueType$ x$1 = ObjectJsonValueType$.MODULE$;
                ListMap x$2 = children;
                boolean x$3 = JsonField$.MODULE$.apply$default$2();
                boolean x$4 = JsonField$.MODULE$.apply$default$3();
                return new JsonField(x$1, x$3, x$4, x$2);
            }
            if (!JsonToken.FIELD_NAME.equals(jsonToken)) break;
            String fieldName = jsonParser.getCurrentName();
            JsonField field = this.extractContent(jsonParser);
            children = (ListMap)children.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)fieldName), (Object)field));
        }
        throw new JsonSchemaException(JsonSchemaException$.MODULE$.$lessinit$greater$default$1());
    }

    private Seq<SourceField> sourceField(JsonField field) {
        Seq seq;
        JsonValueType jsonValueType = field.valueType();
        ObjectJsonValueType$ objectJsonValueType$ = ObjectJsonValueType$.MODULE$;
        if (!(jsonValueType != null ? !jsonValueType.equals(objectJsonValueType$) : objectJsonValueType$ != null)) {
            seq = JsonSchemaExtractor.childrenSource$1(field, (Option)None$.MODULE$);
        } else {
            JsonValueType valueType = field.valueType();
            SourceField sourceField = SourceField$.MODULE$.useNameAsKey(SourceItemName$.MODULE$.apply(this.rootFieldName()), valueType.toDataType(), valueType.toNativeType(), 0, field.nullable() || valueType.isNullable(), field.multivalued(), SourceField$.MODULE$.useNameAsKey$default$7(), SourceField$.MODULE$.useNameAsKey$default$8());
            seq = (Seq)JsonSchemaExtractor.childrenSource$1(field, (Option)None$.MODULE$).$plus$colon((Object)sourceField);
        }
        Seq raw = seq;
        return (Seq)((IterableOps)raw.zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                int idx;
                SourceField field = (SourceField)tuple2._1();
                int x$1 = idx = tuple2._2$mcI$sp();
                SourceItemName x$2 = field.copy$default$1();
                package.DataType x$3 = field.copy$default$2();
                String x$4 = field.copy$default$3();
                SourceField.Key x$5 = field.copy$default$5();
                boolean x$6 = field.copy$default$6();
                boolean x$7 = field.copy$default$7();
                Option x$8 = field.copy$default$8();
                PropertyValues x$9 = field.copy$default$9();
                return field.copy(x$2, x$3, x$4, x$1, x$5, x$6, x$7, x$8, x$9);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private final JsonField loop$1(JsonParser jsonParser, Option itemField, int idx) {
        block3: {
            Try try_;
            while (true) {
                Some some;
                JsonToken token;
                if (idx == this.sampleSize()) {
                    return (JsonField)itemField.getOrElse((Function0 & Serializable)() -> {
                        throw new JsonSchemaException(JsonSchemaException$.MODULE$.$lessinit$greater$default$1());
                    });
                }
                Option option = Option$.MODULE$.apply((Object)jsonParser.nextToken());
                if (!(option instanceof Some) || !(token = (JsonToken)(some = (Some)option).value()).isStructStart() && !token.isScalarValue()) break block3;
                try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> this.readContent(jsonParser));
                if (!(try_ instanceof Success)) break;
                Success success = (Success)try_;
                JsonField nextItem = (JsonField)success.value();
                ++idx;
                itemField = itemField.map((Function1 & Serializable)x$1 -> x$1.union(nextItem)).orElse((Function0 & Serializable)() -> new Some((Object)nextItem));
            }
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                return (JsonField)itemField.getOrElse((Function0 & Serializable)() -> {
                    throw new JsonSchemaException(e);
                });
            }
            throw new MatchError((Object)try_);
        }
        return (JsonField)itemField.getOrElse((Function0 & Serializable)() -> {
            throw new JsonSchemaException(JsonSchemaException$.MODULE$.$lessinit$greater$default$1());
        });
    }

    private static final Seq childrenSource$1(JsonField parent, Option parentName) {
        return parent.children().iterator().flatMap((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                JsonField field = (JsonField)tuple2._2();
                JsonValueType valueType = field.valueType();
                String fieldName = (String)parentName.map((Function1 & Serializable)pn -> new StringBuilder(11).append((String)pn).append('.').append(name).toString()).getOrElse((Function0 & Serializable)() -> name);
                SourceField sourceField = SourceField$.MODULE$.useNameAsKey(SourceItemName$.MODULE$.apply(fieldName), valueType.toDataType(), valueType.toNativeType(), 0, field.nullable() || valueType.isNullable(), field.multivalued(), SourceField$.MODULE$.useNameAsKey$default$7(), SourceField$.MODULE$.useNameAsKey$default$8());
                return (Seq)JsonSchemaExtractor.childrenSource$1(field, (Option)new Some((Object)fieldName)).$plus$colon((Object)sourceField);
            }
            throw new MatchError((Object)tuple2);
        }).toVector();
    }

    public JsonSchemaExtractor(FileSystemClient fsClient) {
        this.fsClient = fsClient;
        SchemaExtractor.$init$(this);
        this.sampleSize = 1000;
        this.rootFieldName = "<root>";
        this.factory = new JsonFactory().enable(JsonParser.Feature.ALLOW_COMMENTS);
    }
}

