/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.filesystem.schema.deltalake;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import org.json4s.AsJsonInput$;
import org.json4s.DefaultFormats$;
import org.json4s.ExtractableJsonAstNode$;
import org.json4s.Formats;
import org.json4s.JValue;
import org.json4s.MonadicJValue$;
import org.json4s.jackson.JsonMethods$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.Using;
import scala.util.Using$;
import zeenea.connector.filesystem.FileSystemClient;
import zeenea.connector.filesystem.FileSystemDirectory;
import zeenea.connector.filesystem.FileSystemFile;
import zeenea.connector.filesystem.FileSystemHierarchy;
import zeenea.connector.filesystem.FileSystemItem;
import zeenea.connector.filesystem.schema.SchemaExtractor;
import zeenea.connector.filesystem.schema.deltalake.ArrayType;
import zeenea.connector.filesystem.schema.deltalake.BinaryType$;
import zeenea.connector.filesystem.schema.deltalake.BooleanType$;
import zeenea.connector.filesystem.schema.deltalake.ByteType$;
import zeenea.connector.filesystem.schema.deltalake.DateType$;
import zeenea.connector.filesystem.schema.deltalake.DecimalType$;
import zeenea.connector.filesystem.schema.deltalake.DeltaField;
import zeenea.connector.filesystem.schema.deltalake.DeltaLakeSchemaExtractor$;
import zeenea.connector.filesystem.schema.deltalake.DeltaType;
import zeenea.connector.filesystem.schema.deltalake.DeltaType$;
import zeenea.connector.filesystem.schema.deltalake.DoubleType$;
import zeenea.connector.filesystem.schema.deltalake.FloatType$;
import zeenea.connector.filesystem.schema.deltalake.IntegerType$;
import zeenea.connector.filesystem.schema.deltalake.IntervalType$;
import zeenea.connector.filesystem.schema.deltalake.LongType$;
import zeenea.connector.filesystem.schema.deltalake.MapType;
import zeenea.connector.filesystem.schema.deltalake.ShortType$;
import zeenea.connector.filesystem.schema.deltalake.StringType$;
import zeenea.connector.filesystem.schema.deltalake.StructType;
import zeenea.connector.filesystem.schema.deltalake.TimestampType$;
import zeenea.connector.filesystem.schema.deltalake.UnknownType$;
import zeenea.connector.libs.scala.Extensions;
import zeenea.connector.libs.scala.Extensions$;
import zeenea.connector.source.SourceDescription$;
import zeenea.connector.source.SourceField;
import zeenea.connector.source.SourceField$;
import zeenea.connector.source.SourceItemName$;
import zeenea.connector.source.datatype.package;

@ScalaSignature(bytes="\u0006\u0005\u0005Ug\u0001\u0002\r\u001a\u0001\u0011B\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\ti\u0001\u0011\t\u0011)A\u0005k!)\u0001\b\u0001C\u0001s!9a\b\u0001b\u0001\n\u0013y\u0004B\u0002%\u0001A\u0003%\u0001\tC\u0004J\u0001\t\u0007I1\u0001&\t\rE\u0003\u0001\u0015!\u0003L\u0011\u0015\u0011\u0006\u0001\"\u0011T\u0011\u0015!\b\u0001\"\u0003v\u0011\u0015a\b\u0001\"\u0003~\u0011\u001d\t)\u0002\u0001C\u0005\u0003/Aq!a\u0007\u0001\t\u0013\ti\u0002C\u0004\u0002\"\u0001!I!a\t\t\u000f\u0005=\u0002\u0001\"\u0003\u00022!9\u0011\u0011\f\u0001\u0005\n\u0005m\u0003bBA7\u0001\u0011%\u0011q\u000e\u0005\b\u0003\u001f\u0003A\u0011BAI\u0011\u001d\t9\n\u0001C\u0005\u00033Cq!!(\u0001\t\u0013\tyjB\u0004\u0002FfA\t!a2\u0007\raI\u0002\u0012AAe\u0011\u0019AT\u0003\"\u0001\u0002L\"9\u0011QZ\u000b\u0005\u0002\u0005='\u0001\u0007#fYR\fG*Y6f'\u000eDW-\\1FqR\u0014\u0018m\u0019;pe*\u0011!dG\u0001\nI\u0016dG/\u00197bW\u0016T!\u0001H\u000f\u0002\rM\u001c\u0007.Z7b\u0015\tqr$\u0001\u0006gS2,7/_:uK6T!\u0001I\u0011\u0002\u0013\r|gN\\3di>\u0014(\"\u0001\u0012\u0002\ri,WM\\3b\u0007\u0001\u00192\u0001A\u0013,!\t1\u0013&D\u0001(\u0015\u0005A\u0013!B:dC2\f\u0017B\u0001\u0016(\u0005\u0019\te.\u001f*fMB\u0011A&L\u0007\u00027%\u0011af\u0007\u0002\u0010'\u000eDW-\\1FqR\u0014\u0018m\u0019;pe\u0006I\u0001.[3sCJ\u001c\u0007.\u001f\t\u0003cIj\u0011!H\u0005\u0003gu\u00111CR5mKNK8\u000f^3n\u0011&,'/\u0019:dQf\f\u0001BZ:DY&,g\u000e\u001e\t\u0003cYJ!aN\u000f\u0003!\u0019KG.Z*zgR,Wn\u00117jK:$\u0018A\u0002\u001fj]&$h\bF\u0002;yu\u0002\"a\u000f\u0001\u000e\u0003eAQaL\u0002A\u0002ABQ\u0001N\u0002A\u0002U\na\u0001\\8hO\u0016\u0014X#\u0001!\u0011\u0005\u00053U\"\u0001\"\u000b\u0005\r#\u0015!B:mMRR'\"A#\u0002\u0007=\u0014x-\u0003\u0002H\u0005\n1Aj\\4hKJ\fq\u0001\\8hO\u0016\u0014\b%A\u0006kg>tgi\u001c:nCR\u001cX#A&\u000f\u00051{U\"A'\u000b\u00059#\u0015A\u00026t_:$4/\u0003\u0002Q\u001b\u0006qA)\u001a4bk2$hi\u001c:nCR\u001c\u0018\u0001\u00046t_:4uN]7biN\u0004\u0013!C4fiN\u001b\u0007.Z7b)\t!v\u000eE\u0002V1jk\u0011A\u0016\u0006\u0003/\u001e\nA!\u001e;jY&\u0011\u0011L\u0016\u0002\u0004)JL\bc\u0001\u0014\\;&\u0011Al\n\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007y3\u0017N\u0004\u0002`I:\u0011\u0001mY\u0007\u0002C*\u0011!mI\u0001\u0007yI|w\u000e\u001e \n\u0003!J!!Z\u0014\u0002\u000fA\f7m[1hK&\u0011q\r\u001b\u0002\u0004'\u0016\f(BA3(!\tQW.D\u0001l\u0015\taw$\u0001\u0004t_V\u00148-Z\u0005\u0003].\u00141bU8ve\u000e,g)[3mI\")\u0001\u000f\u0003a\u0001c\u00069A-\u0019;bg\u0016$\bCA\u0019s\u0013\t\u0019XD\u0001\bGS2,7+_:uK6LE/Z7\u0002\u0011\u0011,G\u000e^1M_\u001e$\"A\u001e>\u0011\u0007\u0019Zv\u000f\u0005\u00022q&\u0011\u00110\b\u0002\u0014\r&dWmU=ti\u0016lG)\u001b:fGR|'/\u001f\u0005\u0006w&\u0001\ra^\u0001\u0007MNLE/Z7\u0002!\u001d,G\u000fT1ti\u000e\u00138mU2iK6\fGc\u0001@\u0002\u0012A\u0019Q\u000bW@\u0011\t\u0019Z\u0016\u0011\u0001\t\u0005\u0003\u0007\tYA\u0004\u0003\u0002\u0006\u0005\u001d\u0001C\u00011(\u0013\r\tIaJ\u0001\u0007!J,G-\u001a4\n\t\u00055\u0011q\u0002\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005%q\u0005\u0003\u0004\u0002\u0014)\u0001\ra^\u0001\fI\u0016dG/\u0019'pO\u0012K'/A\thKRd\u0015m\u001d;Kg>t7k\u00195f[\u0006$2A`A\r\u0011\u0019\t\u0019b\u0003a\u0001o\u00069R\r\u001f;sC\u000e$8k\u00195f[\u00064%o\\7TiJLgn\u001a\u000b\u0004)\u0006}\u0001B\u0002\u000f\r\u0001\u0004\t\t!\u0001\u000beK2$\u0018mU2iK6\fW\t\u001f;sC\u000e$xN\u001d\u000b\u0004;\u0006\u0015\u0002bBA\u0014\u001b\u0001\u0007\u0011\u0011F\u0001\u0007gR\u0014Xo\u0019;\u0011\u0007m\nY#C\u0002\u0002.e\u0011!b\u0015;sk\u000e$H+\u001f9f\u00031)\u0007\u0010\u001e:bGR4\u0015.\u001a7e)\u0019\t\u0019$!\u000e\u0002@A\u0019Q\u000bW/\t\u000f\u0005]b\u00021\u0001\u0002:\u0005QA-\u001a7uC\u001aKW\r\u001c3\u0011\u0007m\nY$C\u0002\u0002>e\u0011!\u0002R3mi\u00064\u0015.\u001a7e\u0011\u001d\t\tE\u0004a\u0001\u0003\u0007\n\u0011B\\3yi&sG-\u001a=\u0011\t\u0005\u0015\u0013QK\u0007\u0003\u0003\u000fRA!!\u0013\u0002L\u00051\u0011\r^8nS\u000eTA!!\u0014\u0002P\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0007]\u000b\tF\u0003\u0002\u0002T\u0005!!.\u0019<b\u0013\u0011\t9&a\u0012\u0003\u001b\u0005#x.\\5d\u0013:$XmZ3s\u00039\u0019\u0007.\u001b7ee\u0016tg)[3mIN$\u0002\"a\r\u0002^\u0005\u0005\u00141\u000e\u0005\b\u0003?z\u0001\u0019AA\u0001\u0003\u0011q\u0017-\\3\t\u000f\u0005\rt\u00021\u0001\u0002f\u0005AA-\u0019;b)f\u0004X\rE\u0002<\u0003OJ1!!\u001b\u001a\u0005%!U\r\u001c;b)f\u0004X\rC\u0004\u0002B=\u0001\r!a\u0011\u0002#\r\u0014X-\u0019;f'>,(oY3GS\u0016dG\rF\u0006j\u0003c\n\u0019(a\u001e\u0002\u0002\u0006-\u0005bBA0!\u0001\u0007\u0011\u0011\u0001\u0005\b\u0003k\u0002\u0002\u0019AA3\u0003%!W\r\u001c;b)f\u0004X\rC\u0004\u0002zA\u0001\r!a\u001f\u0002\u000b%tG-\u001a=\u0011\u0007\u0019\ni(C\u0002\u0002\u0000\u001d\u00121!\u00138u\u0011\u001d\t\u0019\t\u0005a\u0001\u0003\u000b\u000b!\"[:Ok2d\u0017M\u00197f!\r1\u0013qQ\u0005\u0004\u0003\u0013;#a\u0002\"p_2,\u0017M\u001c\u0005\u0007\u0003\u001b\u0003\u0002\u0019A@\u0002\u0017\u0011,7o\u0019:jaRLwN\\\u0001\u000fO\u0016$H)Z:de&\u0004H/[8o)\ry\u00181\u0013\u0005\b\u0003+\u000b\u0002\u0019AA\u0001\u0003\u001d\u0019w.\\7f]R\fQ\"[:Nk2$\u0018N^1mk\u0016$G\u0003BAC\u00037Cq!!\u001e\u0013\u0001\u0004\t)'A\u000beK2$\u0018\rV=qKR{',Z3oK\u0006$\u0016\u0010]3\u0015\t\u0005\u0005\u0016\u0011\u0019\t\u0005\u0003G\u000bYL\u0004\u0003\u0002&\u0006]f\u0002BAT\u0003gsA!!+\u00022:!\u00111VAX\u001d\r\u0001\u0017QV\u0005\u0002E%\u0011\u0001%I\u0005\u0003Y~I1!!.l\u0003!!\u0017\r^1usB,\u0017bA3\u0002:*\u0019\u0011QW6\n\t\u0005u\u0016q\u0018\u0002\t\t\u0006$\u0018\rV=qK*\u0019Q-!/\t\u000f\u0005\r7\u00031\u0001\u0002f\u0005!A-\u0019;b\u0003a!U\r\u001c;b\u0019\u0006\\WmU2iK6\fW\t\u001f;sC\u000e$xN\u001d\t\u0003wU\u0019\"!F\u0013\u0015\u0005\u0005\u001d\u0017!B1qa2LH#\u0002\u001e\u0002R\u0006M\u0007\"B\u0018\u0018\u0001\u0004\u0001\u0004\"\u0002\u001b\u0018\u0001\u0004)\u0004")
public class DeltaLakeSchemaExtractor
implements SchemaExtractor {
    private final FileSystemHierarchy hierarchy;
    private final FileSystemClient fsClient;
    private final Logger logger;
    private final DefaultFormats$ jsonFormats;

    public static DeltaLakeSchemaExtractor apply(FileSystemHierarchy hierarchy, FileSystemClient fsClient) {
        return DeltaLakeSchemaExtractor$.MODULE$.apply(hierarchy, fsClient);
    }

    @Override
    public <B> Try<Option<B>> onNotEmptyFile(FileSystemItem fsItem, Function1<FileSystemFile, Try<Option<B>>> block) {
        return SchemaExtractor.onNotEmptyFile$(this, fsItem, block);
    }

    private Logger logger() {
        return this.logger;
    }

    public DefaultFormats$ jsonFormats() {
        return this.jsonFormats;
    }

    @Override
    public Try<Option<Seq<SourceField>>> getSchema(FileSystemItem dataset) {
        this.logger().debug("filesystem_delta_get_schema file='{}'", (Object)dataset.path());
        FileSystemItem fileSystemItem = dataset;
        if (fileSystemItem instanceof FileSystemDirectory) {
            FileSystemDirectory fileSystemDirectory = (FileSystemDirectory)fileSystemItem;
            Option<FileSystemDirectory> option = this.deltaLog(fileSystemDirectory);
            if (option instanceof Some) {
                String string;
                Success success;
                Option option2;
                Success success2;
                Option option3;
                Some some = (Some)option;
                FileSystemDirectory deltaLogDir = (FileSystemDirectory)some.value();
                Try<Option<String>> try_ = this.getLastCrcSchema(deltaLogDir);
                if (try_ instanceof Success && (option3 = (Option)(success2 = (Success)try_).value()) instanceof Some) {
                    Some some2 = (Some)option3;
                    String schema = (String)some2.value();
                    return this.extractSchemaFromString(schema);
                }
                Try<Option<String>> try_2 = this.getLastJsonSchema(deltaLogDir);
                if (try_2 instanceof Success && (option2 = (Option)(success = (Success)try_2).value()) instanceof Some) {
                    String schema;
                    Some some3 = (Some)option2;
                    string = schema = (String)some3.value();
                } else {
                    string = "";
                }
                return this.extractSchemaFromString(string);
            }
            if (None$.MODULE$.equals(option)) {
                return new Success((Object)None$.MODULE$);
            }
            throw new MatchError(option);
        }
        if (fileSystemItem instanceof FileSystemFile) {
            return new Success((Object)None$.MODULE$);
        }
        throw new MatchError((Object)fileSystemItem);
    }

    private Option<FileSystemDirectory> deltaLog(FileSystemDirectory fsItem) {
        return this.hierarchy.child(fsItem, "_delta_log").flatMap((Function1 & Serializable)item -> {
            FileSystemItem fileSystemItem = item;
            if (fileSystemItem instanceof FileSystemFile) {
                return None$.MODULE$;
            }
            if (fileSystemItem instanceof FileSystemDirectory) {
                FileSystemDirectory fileSystemDirectory = (FileSystemDirectory)fileSystemItem;
                return new Some((Object)fileSystemDirectory);
            }
            throw new MatchError((Object)fileSystemItem);
        });
    }

    private Try<Option<String>> getLastCrcSchema(FileSystemDirectory deltaLogDir) {
        return Extensions.OptionTryExtension$.MODULE$.sequence$extension(Extensions$.MODULE$.OptionTryExtension(((IterableOnceOps)this.hierarchy.listChildren(deltaLogDir).filter((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)DeltaLakeSchemaExtractor.$anonfun$getLastCrcSchema$1(f)))).maxByOption((Function1 & Serializable)x$1 -> x$1.path().name(), (Ordering)Ordering.String$.MODULE$).flatMap((Function1 & Serializable)x0$1 -> {
            FileSystemItem fileSystemItem = x0$1;
            if (fileSystemItem instanceof FileSystemFile) {
                Option option;
                FileSystemFile fileSystemFile = (FileSystemFile)fileSystemItem;
                boolean bl = false;
                Success success = null;
                Try try_ = $this.fsClient.inputStream(fileSystemFile).map((Function1 & Serializable)in -> (Option)Using$.MODULE$.resource(in, (Function1 & Serializable)input -> Source$.MODULE$.fromInputStream(input, Codec$.MODULE$.fallbackSystemCodec()).getLines().find((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$2)))).map((Function1 & Serializable)metadata -> {
                    JValue json = JsonMethods$.MODULE$.parse(metadata, JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3(), AsJsonInput$.MODULE$.stringAsJsonInput());
                    return (String)ExtractableJsonAstNode$.MODULE$.extract$extension(org.json4s.package$.MODULE$.jvalue2extractable(MonadicJValue$.MODULE$.$bslash$bslash$extension(org.json4s.package$.MODULE$.jvalue2monadic(MonadicJValue$.MODULE$.$bslash$bslash$extension(org.json4s.package$.MODULE$.jvalue2monadic(json), "metadata")), "schemaString")), (Formats)this.jsonFormats(), ManifestFactory$.MODULE$.classType(String.class));
                }), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$));
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable exception = failure.exception();
                    this.logger().warn("filesystem_delta_read_crc_file_failed {}", (Object)exception.getMessage());
                    return new Some((Object)new Failure(exception));
                }
                if (try_ instanceof Success) {
                    bl = true;
                    success = (Success)try_;
                    Option option2 = (Option)success.value();
                    if (option2 instanceof Some) {
                        Some some = (Some)option2;
                        String value = (String)some.value();
                        return new Some((Object)new Success((Object)value));
                    }
                }
                if (bl && None$.MODULE$.equals(option = (Option)success.value())) {
                    return None$.MODULE$;
                }
                throw new MatchError((Object)try_);
            }
            return None$.MODULE$;
        })));
    }

    private Try<Option<String>> getLastJsonSchema(FileSystemDirectory deltaLogDir) {
        return Extensions.OptionTryExtension$.MODULE$.sequence$extension(Extensions$.MODULE$.OptionTryExtension(((Vector)((SeqOps)this.hierarchy.listChildren(deltaLogDir).filter((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)DeltaLakeSchemaExtractor.$anonfun$getLastJsonSchema$1(f)))).sortBy((Function1 & Serializable)f -> f.path().name(), package$.MODULE$.Ordering().apply((Ordering)Ordering.String$.MODULE$).reverse())).iterator().flatMap((Function1 & Serializable)x0$1 -> {
            FileSystemItem fileSystemItem = x0$1;
            if (fileSystemItem instanceof FileSystemFile) {
                Option option;
                FileSystemFile fileSystemFile = (FileSystemFile)fileSystemItem;
                boolean bl = false;
                Success success = null;
                Try try_ = $this.fsClient.inputStream(fileSystemFile).map((Function1 & Serializable)is2 -> (Option)Using$.MODULE$.resource(is2, (Function1 & Serializable)is -> Source$.MODULE$.fromInputStream(is, Codec$.MODULE$.fallbackSystemCodec()).getLines().find((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.startsWith("{\"metaData\":"))).map((Function1 & Serializable)metadata -> {
                    JValue json = JsonMethods$.MODULE$.parse(metadata, JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3(), AsJsonInput$.MODULE$.stringAsJsonInput());
                    return (String)ExtractableJsonAstNode$.MODULE$.extract$extension(org.json4s.package$.MODULE$.jvalue2extractable(MonadicJValue$.MODULE$.$bslash$bslash$extension(org.json4s.package$.MODULE$.jvalue2monadic(json), "schemaString")), (Formats)this.jsonFormats(), ManifestFactory$.MODULE$.classType(String.class));
                }), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$));
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable exception = failure.exception();
                    this.logger().warn("filesystem_delta_read_json_file_failed {}", (Object)exception.getMessage());
                    return new Some((Object)new Failure(exception));
                }
                if (try_ instanceof Success) {
                    bl = true;
                    success = (Success)try_;
                    Option option2 = (Option)success.value();
                    if (option2 instanceof Some) {
                        Some some = (Some)option2;
                        String value = (String)some.value();
                        return new Some((Object)new Success((Object)value));
                    }
                }
                if (bl && None$.MODULE$.equals(option = (Option)success.value())) {
                    return None$.MODULE$;
                }
                throw new MatchError((Object)try_);
            }
            return None$.MODULE$;
        }).nextOption()));
    }

    private Try<Option<Seq<SourceField>>> extractSchemaFromString(String schema) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            DeltaType deltaType = DeltaType$.MODULE$.fromJson(schema);
            if (deltaType instanceof StructType) {
                StructType structType = (StructType)deltaType;
                return Option$.MODULE$.apply(this.deltaSchemaExtractor(structType));
            }
            return new Some((Object)package$.MODULE$.Vector().empty());
        });
    }

    private Seq<SourceField> deltaSchemaExtractor(StructType struct) {
        AtomicInteger index = new AtomicInteger();
        return (Seq)struct.fields().flatMap((Function1 & Serializable)field -> (Seq)this.extractField((DeltaField)field, index).getOrElse((Function0 & Serializable)() -> package$.MODULE$.Vector().empty()));
    }

    private Try<Seq<SourceField>> extractField(DeltaField deltaField, AtomicInteger nextIndex) {
        SourceField field = this.createSourceField(deltaField.name(), deltaField.dataType(), nextIndex.getAndIncrement(), deltaField.nullable(), this.getDescription(deltaField.description()));
        return this.childrenFields(deltaField.name(), deltaField.dataType(), nextIndex).map((Function1 & Serializable)children -> {
            SourceField sourceField = field;
            return (Seq)children.$plus$colon((Object)sourceField);
        });
    }

    private Try<Seq<SourceField>> childrenFields(String name, DeltaType dataType, AtomicInteger nextIndex) {
        DeltaType deltaType;
        while ((deltaType = dataType) instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)deltaType;
            dataType = arrayType.elementType();
        }
        if (deltaType instanceof MapType) {
            MapType mapType = (MapType)deltaType;
            SourceField key = this.createSourceField(new StringBuilder(5).append(name).append("[key]").toString(), mapType.keyType(), nextIndex.getAndIncrement(), false, this.getDescription(mapType.description()));
            return this.extractField(new DeltaField(new StringBuilder(7).append(name).append("[value]").toString(), mapType.valueType(), mapType.valueContainsNull(), mapType.valueType().description()), nextIndex).map((Function1 & Serializable)value -> {
                SourceField sourceField = key;
                return (Seq)value.$plus$colon((Object)sourceField);
            });
        }
        if (deltaType instanceof StructType) {
            StructType structType = (StructType)deltaType;
            return new Success(structType.fields().flatMap((Function1 & Serializable)field -> (Seq)this.extractField(new DeltaField(new StringBuilder(1).append(name).append(".").append(field.name()).toString(), field.dataType(), field.nullable(), field.description()), nextIndex).getOrElse((Function0 & Serializable)() -> (Vector)package$.MODULE$.Vector().apply((Seq)Nil$.MODULE$))));
        }
        return new Success(package$.MODULE$.Vector().apply((Seq)Nil$.MODULE$));
    }

    private SourceField createSourceField(String name, DeltaType deltaType, int index, boolean isNullable, Option<String> description) {
        return SourceField$.MODULE$.useNameAsKey(SourceItemName$.MODULE$.apply(name), this.deltaTypeToZeeneaType(deltaType), deltaType.nativeType(), index, isNullable, this.isMultivalued(deltaType), SourceDescription$.MODULE$.from(description), SourceField$.MODULE$.useNameAsKey$default$8());
    }

    private Option<String> getDescription(String comment) {
        if (comment.isEmpty()) {
            return None$.MODULE$;
        }
        return Option$.MODULE$.apply((Object)comment);
    }

    private boolean isMultivalued(DeltaType deltaType) {
        DeltaType deltaType2 = deltaType;
        if (deltaType2 instanceof ArrayType) {
            return true;
        }
        return deltaType2 instanceof MapType;
    }

    private package.DataType deltaTypeToZeeneaType(DeltaType data) {
        DeltaType deltaType;
        while (true) {
            DeltaType elementType;
            if (BooleanType$.MODULE$.equals(deltaType = data)) {
                return package.BooleanType$.MODULE$;
            }
            if (StringType$.MODULE$.equals(deltaType)) {
                return package.StringType$.MODULE$;
            }
            if (!(deltaType instanceof ArrayType)) break;
            ArrayType arrayType = (ArrayType)deltaType;
            data = elementType = arrayType.elementType();
        }
        if (ByteType$.MODULE$.equals(deltaType)) {
            return package.ByteType$.MODULE$;
        }
        if (ShortType$.MODULE$.equals(deltaType)) {
            return package.ShortType$.MODULE$;
        }
        if (IntegerType$.MODULE$.equals(deltaType)) {
            return package.IntegerType$.MODULE$;
        }
        if (LongType$.MODULE$.equals(deltaType)) {
            return package.LongType$.MODULE$;
        }
        if (DoubleType$.MODULE$.equals(deltaType)) {
            return package.DoubleType$.MODULE$;
        }
        if (FloatType$.MODULE$.equals(deltaType)) {
            return package.FloatType$.MODULE$;
        }
        if (DecimalType$.MODULE$.equals(deltaType)) {
            return package.BigDecimalType$.MODULE$;
        }
        if (IntervalType$.MODULE$.equals(deltaType)) {
            return package.TimeType$.MODULE$;
        }
        if (TimestampType$.MODULE$.equals(deltaType)) {
            return package.TimestampType$.MODULE$;
        }
        if (DateType$.MODULE$.equals(deltaType)) {
            return package.DateType$.MODULE$;
        }
        if (BinaryType$.MODULE$.equals(deltaType)) {
            return package.BinaryType$.MODULE$;
        }
        if (deltaType instanceof StructType) {
            return package.StructType$.MODULE$;
        }
        if (deltaType instanceof MapType) {
            return package.MapType$.MODULE$;
        }
        if (UnknownType$.MODULE$.equals(deltaType)) {
            return package.UnknownType$.MODULE$;
        }
        throw new MatchError((Object)deltaType);
    }

    public static final /* synthetic */ boolean $anonfun$getLastCrcSchema$1(FileSystemItem f) {
        return f.isFile() && f.path().name().matches("[0-9]{20}\\.crc");
    }

    public static final /* synthetic */ boolean $anonfun$getLastJsonSchema$1(FileSystemItem f) {
        return f.path().name().matches("[0-9]{20}\\.json");
    }

    public DeltaLakeSchemaExtractor(FileSystemHierarchy hierarchy, FileSystemClient fsClient) {
        this.hierarchy = hierarchy;
        this.fsClient = fsClient;
        SchemaExtractor.$init$(this);
        this.logger = LoggerFactory.getLogger(DeltaLakeSchemaExtractor.class);
        this.jsonFormats = DefaultFormats$.MODULE$;
    }
}

