/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.filesystem.schema;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.SeqOps;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ReusableBuilder;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import zeenea.connector.filesystem.FilePath;
import zeenea.connector.filesystem.FileSystemClient;
import zeenea.connector.filesystem.FileSystemDirectory;
import zeenea.connector.filesystem.FileSystemFile;
import zeenea.connector.filesystem.FileSystemHierarchy;
import zeenea.connector.filesystem.FileSystemItem;
import zeenea.connector.filesystem.FileSystemKind;
import zeenea.connector.filesystem.inventory.DatasetRef;
import zeenea.connector.filesystem.inventory.ExtensionRule;
import zeenea.connector.filesystem.inventory.InventoryPatterns;
import zeenea.connector.filesystem.inventory.LegacyDatasetRef;
import zeenea.connector.filesystem.inventory.StandardDatasetRef;
import zeenea.connector.filesystem.inventory.StandardMarkedDatasetRef;
import zeenea.connector.filesystem.schema.FileFormatWithExtension;
import zeenea.connector.filesystem.schema.FileFormatWithMark;
import zeenea.connector.filesystem.schema.FileSchema;
import zeenea.connector.filesystem.schema.FileSchemaReader;
import zeenea.connector.filesystem.schema.NoSchemaFound;
import zeenea.connector.libs.scala.Extensions;
import zeenea.connector.libs.scala.Extensions$;

@ScalaSignature(bytes="\u0006\u0005\u0005Ma\u0001B\u0007\u000f\u0005]A\u0001B\b\u0001\u0003\u0002\u0003\u0006Ia\b\u0005\tG\u0001\u0011\t\u0011)A\u0005I!A!\u0006\u0001B\u0001B\u0003%1\u0006\u0003\u0005/\u0001\t\u0005\t\u0015!\u00030\u0011\u0015\u0011\u0004\u0001\"\u00014\u0011\u001dQ\u0004A1A\u0005\nmBa\u0001\u0012\u0001!\u0002\u0013a\u0004bB#\u0001\u0005\u0004%IA\u0012\u0005\u0007\u0015\u0002\u0001\u000b\u0011B$\t\u000b-\u0003A\u0011\u0001'\t\u000b\u0001\u0004A\u0011B1\t\u000f\u0005\u0005\u0001\u0001\"\u0003\u0002\u0004\t!2\u000b^1oI\u0006\u0014HmU2iK6\f'+Z1eKJT!a\u0004\t\u0002\rM\u001c\u0007.Z7b\u0015\t\t\"#\u0001\u0006gS2,7/_:uK6T!a\u0005\u000b\u0002\u0013\r|gN\\3di>\u0014(\"A\u000b\u0002\ri,WM\\3b\u0007\u0001\u0019\"\u0001\u0001\r\u0011\u0005eaR\"\u0001\u000e\u000b\u0003m\tQa]2bY\u0006L!!\b\u000e\u0003\r\u0005s\u0017PU3g\u0003\u0011Y\u0017N\u001c3\u0011\u0005\u0001\nS\"\u0001\t\n\u0005\t\u0002\"A\u0004$jY\u0016\u001c\u0016p\u001d;f[.Kg\u000eZ\u0001\u0011I&\u001c8m\u001c<fef\u0004\u0016\r\u001e;fe:\u0004\"!\n\u0015\u000e\u0003\u0019R!a\n\t\u0002\u0013%tg/\u001a8u_JL\u0018BA\u0015'\u0005EIeN^3oi>\u0014\u0018\u0010U1ui\u0016\u0014hn]\u0001\nQ&,'/\u0019:dQf\u0004\"\u0001\t\u0017\n\u00055\u0002\"a\u0005$jY\u0016\u001c\u0016p\u001d;f[\"KWM]1sG\"L\u0018\u0001\u00034t\u00072LWM\u001c;\u0011\u0005\u0001\u0002\u0014BA\u0019\u0011\u0005A1\u0015\u000e\\3TsN$X-\\\"mS\u0016tG/\u0001\u0004=S:LGO\u0010\u000b\u0006iY:\u0004(\u000f\t\u0003k\u0001i\u0011A\u0004\u0005\u0006=\u0015\u0001\ra\b\u0005\u0006G\u0015\u0001\r\u0001\n\u0005\u0006U\u0015\u0001\ra\u000b\u0005\u0006]\u0015\u0001\raL\u0001\u0007Y><w-\u001a:\u0016\u0003q\u0002\"!\u0010\"\u000e\u0003yR!a\u0010!\u0002\u000bMdg\r\u000e6\u000b\u0003\u0005\u000b1a\u001c:h\u0013\t\u0019eH\u0001\u0004M_\u001e<WM]\u0001\bY><w-\u001a:!\u0003A1\u0017\u000e\\3TG\",W.\u0019*fC\u0012,'/F\u0001H!\t)\u0004*\u0003\u0002J\u001d\t\u0001b)\u001b7f'\u000eDW-\\1SK\u0006$WM]\u0001\u0012M&dWmU2iK6\f'+Z1eKJ\u0004\u0013A\u0003:fC\u0012\u001c6\r[3nCR\u0019QJV.\u0011\u00079\u000b6+D\u0001P\u0015\t\u0001&$\u0001\u0003vi&d\u0017B\u0001*P\u0005\r!&/\u001f\t\u0003kQK!!\u0016\b\u0003\u0015\u0019KG.Z*dQ\u0016l\u0017\rC\u0003X\u0015\u0001\u0007\u0001,\u0001\u0006eCR\f7/\u001a;SK\u001a\u0004\"!J-\n\u0005i3#A\u0003#bi\u0006\u001cX\r\u001e*fM\")AL\u0003a\u0001;\u00061am]%uK6\u0004\"\u0001\t0\n\u0005}\u0003\"A\u0004$jY\u0016\u001c\u0016p\u001d;f[&#X-\\\u0001\nY&\u001cHOR5mKN$BAY9t}B\u00191m\u001b8\u000f\u0005\u0011LgBA3i\u001b\u00051'BA4\u0017\u0003\u0019a$o\\8u}%\t1$\u0003\u0002k5\u00059\u0001/Y2lC\u001e,\u0017B\u00017n\u0005\u00191Vm\u0019;pe*\u0011!N\u0007\t\u0003A=L!\u0001\u001d\t\u0003\u001d\u0019KG.Z*zgR,WNR5mK\")!o\u0003a\u0001;\u0006!!o\\8u\u0011\u0015!8\u00021\u0001v\u0003A)\u0007\u0010^3og&|g\u000eU1ui\u0016\u0014h\u000e\u0005\u0002wy6\tqO\u0003\u0002ys\u0006)!/Z4fq*\u0011\u0001K\u001f\u0006\u0002w\u0006!!.\u0019<b\u0013\tixOA\u0004QCR$XM\u001d8\t\u000b}\\\u0001\u0019A;\u0002\u001f\t\f7/\u001a8b[\u0016\u0004\u0016\r\u001e;fe:\f1BZ5mK6\u000bGo\u00195fgRA\u0011QAA\u0006\u0003\u001f\t\t\u0002E\u0002\u001a\u0003\u000fI1!!\u0003\u001b\u0005\u001d\u0011un\u001c7fC:Da!!\u0004\r\u0001\u0004q\u0017\u0001\u00024jY\u0016DQ\u0001\u001e\u0007A\u0002UDQa \u0007A\u0002U\u0004")
public final class StandardSchemaReader {
    private final FileSystemKind kind;
    private final InventoryPatterns discoveryPattern;
    private final FileSystemHierarchy hierarchy;
    private final Logger logger;
    private final FileSchemaReader fileSchemaReader;

    private Logger logger() {
        return this.logger;
    }

    private FileSchemaReader fileSchemaReader() {
        return this.fileSchemaReader;
    }

    public Try<FileSchema> readSchema(DatasetRef datasetRef, FileSystemItem fsItem) {
        DatasetRef datasetRef2 = datasetRef;
        if (datasetRef2 instanceof LegacyDatasetRef) {
            LegacyDatasetRef legacyDatasetRef = (LegacyDatasetRef)datasetRef2;
            FilePath path = legacyDatasetRef.path();
            return new Failure((Throwable)new IllegalArgumentException(new StringBuilder(66).append("file_system_").append(this.kind).append("_standard_schema_reader_illegal_legacy_dataset path='").append(path).append("'").toString()));
        }
        if (datasetRef2 instanceof StandardDatasetRef) {
            StandardDatasetRef standardDatasetRef = (StandardDatasetRef)datasetRef2;
            FilePath path = standardDatasetRef.path();
            String basename = standardDatasetRef.basename();
            FileFormatWithExtension format = standardDatasetRef.format();
            Pattern basenamePattern = Pattern.compile((String)this.discoveryPattern.filePartitions().map((Function1 & Serializable)partPattern -> basename.replace("*", partPattern.pattern())).getOrElse((Function0 & Serializable)() -> basename));
            ExtensionRule extensionRule = this.discoveryPattern.extensionRules().rule(format);
            return (Try)this.listFiles(fsItem, extensionRule.filePattern(), basenamePattern).iterator().map((Function1 & Serializable)f -> this.fileSchemaReader().readSchema((FileSystemItem)f, format)).flatMap((Function1 & Serializable)r -> {
                Option option;
                boolean bl = false;
                Success success = null;
                Try try_ = r;
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable exception = failure.exception();
                    return new Some((Object)new Failure(exception));
                }
                if (try_ instanceof Success) {
                    bl = true;
                    success = (Success)try_;
                    Option option2 = (Option)success.value();
                    if (None$.MODULE$.equals(option2)) {
                        return None$.MODULE$;
                    }
                }
                if (bl && (option = (Option)success.value()) instanceof Some) {
                    Some some = (Some)option;
                    FileSchema value = (FileSchema)some.value();
                    return new Some((Object)new Success((Object)value));
                }
                throw new MatchError((Object)try_);
            }).nextOption().getOrElse((Function0 & Serializable)() -> new Failure((Throwable)new NoSchemaFound(new StringBuilder(82).append("file_system_").append($this.kind).append("_standard_schema_reader_no_schema_found path='").append(path).append("' basename='").append(basename).append("' format='").append(format.name()).append("''").toString())));
        }
        if (datasetRef2 instanceof StandardMarkedDatasetRef) {
            StandardMarkedDatasetRef standardMarkedDatasetRef = (StandardMarkedDatasetRef)datasetRef2;
            FilePath path = standardMarkedDatasetRef.path();
            FileFormatWithMark format = standardMarkedDatasetRef.format();
            return this.fileSchemaReader().readSchema(fsItem, format).flatMap((Function1 & Serializable)x$1 -> Extensions.OptionExtension$.MODULE$.toTry$extension(Extensions$.MODULE$.OptionExtension(x$1), (Function0 & Serializable)() -> new NoSchemaFound(new StringBuilder(70).append("file_system_").append($this.kind).append("_standard_schema_reader_no_schema_found path='").append(path).append("' format='").append(format.name()).append("''").toString())));
        }
        throw new MatchError((Object)datasetRef2);
    }

    private Vector<FileSystemFile> listFiles(FileSystemItem root, Pattern extensionPattern, Pattern basenamePattern) {
        ReusableBuilder builder = package$.MODULE$.Vector().newBuilder();
        this.loop$1(root, extensionPattern, basenamePattern, builder);
        return (Vector)((SeqOps)builder.result()).sortBy((Function1 & Serializable)f -> f.timestamp(), package$.MODULE$.Ordering().ordered(Predef$.MODULE$.$conforms()).reverse());
    }

    private boolean fileMatches(FileSystemFile file, Pattern extensionPattern, Pattern basenamePattern) {
        Matcher filenameMatcher = extensionPattern.matcher(file.path().name());
        if (filenameMatcher.matches()) {
            String basename = filenameMatcher.group(1);
            boolean result = basenamePattern.matcher(basename).matches();
            this.logger().trace("file_system_{}_file_matches_result: file_path='{}' basename='{}' matches='{}' extension_pattern='{}' basename_pattern='{}'", new Object[]{this.kind, file.path(), basename, BoxesRunTime.boxToBoolean((boolean)result), extensionPattern.pattern(), basenamePattern.pattern()});
            return result;
        }
        this.logger().trace("file_system_{}_file_matches_unmatching_extension: file_path='{}' extension_pattern='{}'", new Object[]{this.kind, file.path(), extensionPattern.pattern()});
        return false;
    }

    private final void loop$1(FileSystemItem item, Pattern extensionPattern$1, Pattern basenamePattern$1, ReusableBuilder builder$1) {
        FileSystemItem fileSystemItem = item;
        if (fileSystemItem instanceof FileSystemFile) {
            FileSystemFile fileSystemFile = (FileSystemFile)fileSystemItem;
            if (this.fileMatches(fileSystemFile, extensionPattern$1, basenamePattern$1)) {
                builder$1.addOne((Object)fileSystemFile);
                return;
            }
            return;
        }
        if (fileSystemItem instanceof FileSystemDirectory) {
            FileSystemDirectory fileSystemDirectory = (FileSystemDirectory)fileSystemItem;
            this.hierarchy.listChildren(fileSystemDirectory).foreach((Function1 & Serializable)child -> {
                this.loop$1(child, extensionPattern$1, basenamePattern$1, builder$1);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError((Object)fileSystemItem);
    }

    public StandardSchemaReader(FileSystemKind kind, InventoryPatterns discoveryPattern, FileSystemHierarchy hierarchy, FileSystemClient fsClient) {
        this.kind = kind;
        this.discoveryPattern = discoveryPattern;
        this.hierarchy = hierarchy;
        this.logger = LoggerFactory.getLogger(StandardSchemaReader.class);
        this.fileSchemaReader = new FileSchemaReader(discoveryPattern, hierarchy, fsClient);
    }
}

