/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.filesystem.schema;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.None$;
import scala.Option;
import scala.reflect.ScalaSignature;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import zeenea.connector.filesystem.FileSystemClient;
import zeenea.connector.filesystem.FileSystemHierarchy;
import zeenea.connector.filesystem.FileSystemItem;
import zeenea.connector.filesystem.inventory.InventoryPatterns;
import zeenea.connector.filesystem.schema.FileFormat;
import zeenea.connector.filesystem.schema.FileSchema;
import zeenea.connector.filesystem.schema.FileSchemaReader;
import zeenea.connector.filesystem.schema.FormatDetector;
import zeenea.connector.filesystem.schema.IncompatiblePattern;
import zeenea.connector.filesystem.schema.InfoFetcher;

@ScalaSignature(bytes="\u0006\u0005\u001d4A\u0001D\u0007\u0005-!AA\u0005\u0001B\u0001B\u0003%Q\u0005\u0003\u0005,\u0001\t\u0005\t\u0015!\u0003-\u0011!\u0001\u0004A!A!\u0002\u0013\t\u0004\"\u0002\u001b\u0001\t\u0003)\u0004b\u0002\u001e\u0001\u0005\u0004%Ia\u000f\u0005\u0007\t\u0002\u0001\u000b\u0011\u0002\u001f\t\u000f\u0015\u0003!\u0019!C\u0005\r\"1!\n\u0001Q\u0001\n\u001dCQa\u0013\u0001\u0005B1CQ\u0001\u0019\u0001\u0005B\u0005DQ\u0001\u001a\u0001\u0005B\u0015\u0014QbU2iK6\fg)\u001a;dQ\u0016\u0014(B\u0001\b\u0010\u0003\u0019\u00198\r[3nC*\u0011\u0001#E\u0001\u000bM&dWm]=ti\u0016l'B\u0001\n\u0014\u0003%\u0019wN\u001c8fGR|'OC\u0001\u0015\u0003\u0019QX-\u001a8fC\u000e\u00011c\u0001\u0001\u0018;A\u0011\u0001dG\u0007\u00023)\t!$A\u0003tG\u0006d\u0017-\u0003\u0002\u001d3\t1\u0011I\\=SK\u001a\u00042AH\u0010\"\u001b\u0005i\u0011B\u0001\u0011\u000e\u0005-IeNZ8GKR\u001c\u0007.\u001a:\u0011\u0005y\u0011\u0013BA\u0012\u000e\u0005)1\u0015\u000e\\3TG\",W.Y\u0001\u0011I&\u001c8m\u001c<fef\u0004\u0016\r\u001e;fe:\u0004\"AJ\u0015\u000e\u0003\u001dR!\u0001K\b\u0002\u0013%tg/\u001a8u_JL\u0018B\u0001\u0016(\u0005EIeN^3oi>\u0014\u0018\u0010U1ui\u0016\u0014hn]\u0001\nQ&,'/\u0019:dQf\u0004\"!\f\u0018\u000e\u0003=I!aL\b\u0003'\u0019KG.Z*zgR,W\u000eS5fe\u0006\u00148\r[=\u0002\u0011\u0019\u001c8\t\\5f]R\u0004\"!\f\u001a\n\u0005Mz!\u0001\u0005$jY\u0016\u001c\u0016p\u001d;f[\u000ec\u0017.\u001a8u\u0003\u0019a\u0014N\\5u}Q!ag\u000e\u001d:!\tq\u0002\u0001C\u0003%\t\u0001\u0007Q\u0005C\u0003,\t\u0001\u0007A\u0006C\u00031\t\u0001\u0007\u0011'\u0001\u0004m_\u001e<WM]\u000b\u0002yA\u0011QHQ\u0007\u0002})\u0011q\bQ\u0001\u0006g24GG\u001b\u0006\u0002\u0003\u0006\u0019qN]4\n\u0005\rs$A\u0002'pO\u001e,'/A\u0004m_\u001e<WM\u001d\u0011\u0002\u0019M\u001c\u0007.Z7b%\u0016\fG-\u001a:\u0016\u0003\u001d\u0003\"A\b%\n\u0005%k!\u0001\u0005$jY\u0016\u001c6\r[3nCJ+\u0017\rZ3s\u00035\u00198\r[3nCJ+\u0017\rZ3sA\u0005)a-\u001a;dQR\u0019QJV.\u0011\u00079\u000b6+D\u0001P\u0015\t\u0001\u0016$\u0001\u0003vi&d\u0017B\u0001*P\u0005\r!&/\u001f\t\u00041Q\u000b\u0013BA+\u001a\u0005\u0019y\u0005\u000f^5p]\")q+\u0003a\u00011\u00061am]%uK6\u0004\"!L-\n\u0005i{!A\u0004$jY\u0016\u001c\u0016p\u001d;f[&#X-\u001c\u0005\u00069&\u0001\r!X\u0001\fS:\u0004X\u000f\u001e$pe6\fG\u000f\u0005\u0002\u001f=&\u0011q,\u0004\u0002\u000b\r&dWMR8s[\u0006$\u0018aE;o[\u0006$8\r[5oOB\u000b'\u000f^5uS>tGCA'c\u0011\u0015\u0019'\u00021\u0001Y\u0003\u0019\u0001\u0018M]3oi\u0006qQ-\u001c9us\u0012K'/Z2u_JLHCA'g\u0011\u0015\u00197\u00021\u0001Y\u0001")
public class SchemaFetcher
implements InfoFetcher<FileSchema> {
    private final Logger logger = LoggerFactory.getLogger(FormatDetector.class);
    private final FileSchemaReader schemaReader;

    private Logger logger() {
        return this.logger;
    }

    private FileSchemaReader schemaReader() {
        return this.schemaReader;
    }

    @Override
    public Try<Option<FileSchema>> fetch(FileSystemItem fsItem, FileFormat inputFormat) {
        return this.schemaReader().readSchema(fsItem, inputFormat);
    }

    @Override
    public Try<Option<FileSchema>> unmatchingPartition(FileSystemItem parent) {
        this.logger().trace("filesystem_infer_format_some_children_dont_match parent_folder='{}'", (Object)parent.path());
        return new Failure((Throwable)new IncompatiblePattern(new StringBuilder(62).append("Some subfolders don't match partition pattern parent_folder='").append(parent.path()).append("'").toString()));
    }

    @Override
    public Try<Option<FileSchema>> emptyDirectory(FileSystemItem parent) {
        this.logger().trace("filesystem_infer_format_empty_directory parent_folder='{}'", (Object)parent.path());
        return new Success((Object)None$.MODULE$);
    }

    public SchemaFetcher(InventoryPatterns discoveryPattern, FileSystemHierarchy hierarchy, FileSystemClient fsClient) {
        this.schemaReader = new FileSchemaReader(discoveryPattern, hierarchy, fsClient);
    }
}

