/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.filesystem.schema;

import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import zeenea.connector.filesystem.FileSystemClient;
import zeenea.connector.filesystem.FileSystemDirectory;
import zeenea.connector.filesystem.FileSystemFile;
import zeenea.connector.filesystem.FileSystemHierarchy;
import zeenea.connector.filesystem.FileSystemItem;
import zeenea.connector.filesystem.inventory.ExtensionRule;
import zeenea.connector.filesystem.inventory.InventoryPatterns;
import zeenea.connector.filesystem.schema.FileFormat;
import zeenea.connector.filesystem.schema.FileSchema;
import zeenea.connector.filesystem.schema.InfoFetcher;
import zeenea.connector.filesystem.schema.InfoFetcher$;
import zeenea.connector.filesystem.schema.NoSchemaFound;
import zeenea.connector.filesystem.schema.deltalake.DeltaLakeMarker;
import zeenea.connector.filesystem.schema.deltalake.DeltaLakeMarker$;
import zeenea.connector.libs.scala.Extensions;
import zeenea.connector.libs.scala.Extensions$;

@ScalaSignature(bytes="\u0006\u0005\u0005Ue\u0001B\n\u0015\u0001uA\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006I!\n\u0005\tW\u0001\u0011\t\u0011)A\u0005Y!A\u0001\u0007\u0001B\u0001B\u0003%\u0011\u0007C\u00035\u0001\u0011\u0005Q\u0007C\u0004<\u0001\t\u0007I\u0011\u0002\u001f\t\r\u0015\u0003\u0001\u0015!\u0003>\u0011\u001d1\u0005A1A\u0005\n\u001dCaA\u0014\u0001!\u0002\u0013A\u0005bB(\u0001\u0005\u0004%I\u0001\u0015\u0005\u0007A\u0002\u0001\u000b\u0011B)\t\u000b\u0005\u0004A\u0011\u00012\t\u000b9\u0004A\u0011A8\t\u000bU\u0004A\u0011\u0002<\t\u000f\u0005u\u0001\u0001\"\u0003\u0002 !9\u0011Q\t\u0001\u0005\n\u0005\u001d\u0003bBA.\u0001\u0011%\u0011Q\f\u0005\b\u0003_\u0002A\u0011BA9\u0011\u001d\ty\t\u0001C\u0005\u0003#\u0013aBR8s[\u0006$H)\u001a;fGR|'O\u0003\u0002\u0016-\u000511o\u00195f[\u0006T!a\u0006\r\u0002\u0015\u0019LG.Z:zgR,WN\u0003\u0002\u001a5\u0005I1m\u001c8oK\u000e$xN\u001d\u0006\u00027\u00051!0Z3oK\u0006\u001c\u0001a\u0005\u0002\u0001=A\u0011qDI\u0007\u0002A)\t\u0011%A\u0003tG\u0006d\u0017-\u0003\u0002$A\t1\u0011I\\=SK\u001a\f\u0001\u0003Z5tG>4XM]=QCR$XM\u001d8\u0011\u0005\u0019JS\"A\u0014\u000b\u0005!2\u0012!C5om\u0016tGo\u001c:z\u0013\tQsEA\tJ]Z,g\u000e^8ssB\u000bG\u000f^3s]N\f\u0011\u0002[5fe\u0006\u00148\r[=\u0011\u00055rS\"\u0001\f\n\u0005=2\"a\u0005$jY\u0016\u001c\u0016p\u001d;f[\"KWM]1sG\"L\u0018\u0001\u00034t\u00072LWM\u001c;\u0011\u00055\u0012\u0014BA\u001a\u0017\u0005A1\u0015\u000e\\3TsN$X-\\\"mS\u0016tG/\u0001\u0004=S:LGO\u0010\u000b\u0005maJ$\b\u0005\u00028\u00015\tA\u0003C\u0003%\t\u0001\u0007Q\u0005C\u0003,\t\u0001\u0007A\u0006C\u00031\t\u0001\u0007\u0011'\u0001\u0004m_\u001e<WM]\u000b\u0002{A\u0011ahQ\u0007\u0002\u007f)\u0011\u0001)Q\u0001\u0006g24GG\u001b\u0006\u0002\u0005\u0006\u0019qN]4\n\u0005\u0011{$A\u0002'pO\u001e,'/A\u0004m_\u001e<WM\u001d\u0011\u0002\u001f\u0011,G\u000e^1MC.,W*\u0019:lKJ,\u0012\u0001\u0013\t\u0003\u00132k\u0011A\u0013\u0006\u0003\u0017R\t\u0011\u0002Z3mi\u0006d\u0017m[3\n\u00055S%a\u0004#fYR\fG*Y6f\u001b\u0006\u00148.\u001a:\u0002!\u0011,G\u000e^1MC.,W*\u0019:lKJ\u0004\u0013a\u00052z)&lWm\u001d;b[B|%\u000fZ3sS:<W#A)\u0011\u0007ISVL\u0004\u0002T1:\u0011AkV\u0007\u0002+*\u0011a\u000bH\u0001\u0007yI|w\u000e\u001e \n\u0003\u0005J!!\u0017\u0011\u0002\u000fA\f7m[1hK&\u00111\f\u0018\u0002\t\u001fJ$WM]5oO*\u0011\u0011\f\t\t\u0003[yK!a\u0018\f\u0003\u001d\u0019KG.Z*zgR,W.\u0013;f[\u0006!\"-\u001f+j[\u0016\u001cH/Y7q\u001fJ$WM]5oO\u0002\n\u0011\"[:ECR\f7/\u001a;\u0015\u0005\rd\u0007c\u00013hS6\tQM\u0003\u0002gA\u0005!Q\u000f^5m\u0013\tAWMA\u0002Uef\u0004\"a\b6\n\u0005-\u0004#a\u0002\"p_2,\u0017M\u001c\u0005\u0006[.\u0001\r!X\u0001\u0007MNLE/Z7\u0002#I,GO]5wK\u001aKG.Z*dQ\u0016l\u0017\r\u0006\u0002qiB\u0019AmZ9\u0011\u0005]\u0012\u0018BA:\u0015\u0005)1\u0015\u000e\\3TG\",W.\u0019\u0005\u0006[2\u0001\r!X\u0001\u0013e\u0016$(/\u001b<f\t\u0006$\u0018m]3u\u0013:4w.\u0006\u0002x\u007fR\u0019\u00010a\u0007\u0015\u0007e\f\t\u0002E\u0002eOj\u00042aH>~\u0013\ta\bE\u0001\u0004PaRLwN\u001c\t\u0003}~d\u0001\u0001B\u0004\u0002\u00025\u0011\r!a\u0001\u0003\u0003\t\u000bB!!\u0002\u0002\fA\u0019q$a\u0002\n\u0007\u0005%\u0001EA\u0004O_RD\u0017N\\4\u0011\u0007}\ti!C\u0002\u0002\u0010\u0001\u00121!\u00118z\u0011\u001d\t\u0019\"\u0004a\u0002\u0003+\t1\"\u001b8g_\u001a+Go\u00195feB!q'a\u0006~\u0013\r\tI\u0002\u0006\u0002\f\u0013:4wNR3uG\",'\u000fC\u0003n\u001b\u0001\u0007Q,A\rj]\u001a,'O\u0012:p[\u0012K'/Z2u_JL8i\u001c8uK:$X\u0003BA\u0011\u0003W!b!a\t\u00022\u0005mB\u0003BA\u0013\u0003[\u0001B\u0001Z4\u0002(A!qd_A\u0015!\rq\u00181\u0006\u0003\b\u0003\u0003q!\u0019AA\u0002\u0011\u001d\t\u0019B\u0004a\u0002\u0003_\u0001RaNA\f\u0003SAq!a\r\u000f\u0001\u0004\t)$\u0001\u0004qCJ,g\u000e\u001e\t\u0004[\u0005]\u0012bAA\u001d-\t\u0019b)\u001b7f'f\u001cH/Z7ESJ,7\r^8ss\"9\u0011Q\b\bA\u0002\u0005}\u0012AB2iS2$7\u000f\u0005\u0003S\u0003\u0003j\u0016bAA\"9\nA\u0011\n^3sC\ndW-\u0001\nj]\u001a,'O\u0012:p[\u0012K'/Z2u_JLX\u0003BA%\u0003'\"B!a\u0013\u0002ZQ!\u0011QJA+!\u0011!w-a\u0014\u0011\t}Y\u0018\u0011\u000b\t\u0004}\u0006MCaBA\u0001\u001f\t\u0007\u00111\u0001\u0005\b\u0003'y\u00019AA,!\u00159\u0014qCA)\u0011\u0019iw\u00021\u0001\u00026\u0005y\u0011N\u001c4fe\u001a\u0013x.\\'be.,'\u000f\u0006\u0003\u0002`\u00055\u0004\u0003B\u0010|\u0003C\u0002baHA2;\u0006\u001d\u0014bAA3A\t1A+\u001e9mKJ\u00022aNA5\u0013\r\tY\u0007\u0006\u0002\u000b\r&dWMR8s[\u0006$\bBB7\u0011\u0001\u0004\t)$\u0001\bj]\u001a,'O\u0012:p[\u001aKG.Z:\u0016\t\u0005M\u0014Q\u0010\u000b\u0007\u0003k\n\u0019)!\"\u0015\t\u0005]\u0014q\u0010\t\u0005I\u001e\fI\b\u0005\u0003 w\u0006m\u0004c\u0001@\u0002~\u00119\u0011\u0011A\tC\u0002\u0005\r\u0001bBA\n#\u0001\u000f\u0011\u0011\u0011\t\u0006o\u0005]\u00111\u0010\u0005\u0007\u0003g\t\u0002\u0019A/\t\u000f\u0005\u001d\u0015\u00031\u0001\u0002\n\u0006)a-\u001b7fgB!!+a#^\u0013\r\ti\t\u0018\u0002\u0004'\u0016\f\u0018aC5oM\u0016\u0014hi\u001c:nCR$B!a\u0018\u0002\u0014\")QN\u0005a\u0001;\u0002")
public class FormatDetector {
    private final InventoryPatterns discoveryPattern;
    private final FileSystemHierarchy hierarchy;
    private final FileSystemClient fsClient;
    private final Logger logger;
    private final DeltaLakeMarker deltaLakeMarker;
    private final Ordering<FileSystemItem> byTimestampOrdering;

    private Logger logger() {
        return this.logger;
    }

    private DeltaLakeMarker deltaLakeMarker() {
        return this.deltaLakeMarker;
    }

    private Ordering<FileSystemItem> byTimestampOrdering() {
        return this.byTimestampOrdering;
    }

    public Try<Object> isDataset(FileSystemItem fsItem) {
        return this.retriveDatasetInfo(fsItem, InfoFetcher$.MODULE$.isDataset()).map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)FormatDetector.$anonfun$isDataset$1(x$1)));
    }

    public Try<FileSchema> retriveFileSchema(FileSystemItem fsItem) {
        return this.retriveDatasetInfo(fsItem, InfoFetcher$.MODULE$.schema(this.discoveryPattern, this.hierarchy, this.fsClient)).flatMap((Function1 & Serializable)x$2 -> Extensions.OptionExtension$.MODULE$.toTry$extension(Extensions$.MODULE$.OptionExtension(x$2), (Function0 & Serializable)() -> new NoSchemaFound(new StringBuilder(20).append("No schema found for ").append(fsItem.path()).toString())));
    }

    private <B> Try<Option<B>> retriveDatasetInfo(FileSystemItem fsItem, InfoFetcher<B> infoFetcher) {
        FileSystemItem fileSystemItem = fsItem;
        if (fileSystemItem instanceof FileSystemFile) {
            FileSystemFile fileSystemFile = (FileSystemFile)fileSystemItem;
            return this.inferFromFiles(fsItem, (Seq<FileSystemItem>)((Seq)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new FileSystemFile[]{fileSystemFile}))), infoFetcher);
        }
        if (fileSystemItem instanceof FileSystemDirectory) {
            FileSystemDirectory fileSystemDirectory = (FileSystemDirectory)fileSystemItem;
            return this.inferFromDirectory(fileSystemDirectory, infoFetcher);
        }
        throw new MatchError((Object)fileSystemItem);
    }

    private <B> Try<Option<B>> inferFromDirectoryContent(FileSystemDirectory parent, Iterable<FileSystemItem> childs, InfoFetcher<B> infoFetcher) {
        Vector validChildren = (Vector)childs.toVector().filter((Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)this.discoveryPattern.matchValidChild(c)));
        if (validChildren.isEmpty()) {
            return infoFetcher.emptyDirectory(parent);
        }
        if (validChildren.exists((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isDirectory()))) {
            Vector dirChildren = (Vector)validChildren.filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.isDirectory()));
            boolean directoriesMatchPartitionPattern = dirChildren.forall((Function1 & Serializable)folder -> BoxesRunTime.boxToBoolean((boolean)this.discoveryPattern.matchPartition(folder)));
            if (directoriesMatchPartitionPattern) {
                return Extensions.OptionTryExtension$.MODULE$.sequence$extension(Extensions$.MODULE$.OptionTryExtension(((Vector)dirChildren.sorted(this.byTimestampOrdering())).iterator().map((Function1 & Serializable)d -> this.retriveDatasetInfo((FileSystemItem)d, infoFetcher)).find((Function1 & Serializable)info -> BoxesRunTime.boxToBoolean((boolean)FormatDetector.$anonfun$inferFromDirectoryContent$6(info))))).map((Function1 & Serializable)x$5 -> x$5.flatten((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            }
            return infoFetcher.unmatchingPartition(parent);
        }
        return this.inferFromFiles(parent, (Seq<FileSystemItem>)validChildren, infoFetcher);
    }

    private <B> Try<Option<B>> inferFromDirectory(FileSystemDirectory fsItem, InfoFetcher<B> infoFetcher) {
        Some some;
        Tuple2 tuple2;
        this.logger().debug("filesystem_infer_format_from_directory {}", (Object)fsItem.path());
        Option<Tuple2<FileSystemItem, FileFormat>> option = this.inferFromMarker(fsItem);
        if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
            FileSystemItem item = (FileSystemItem)tuple2._1();
            FileFormat format = (FileFormat)tuple2._2();
            return infoFetcher.fetch(item, format);
        }
        return this.inferFromDirectoryContent(fsItem, (Iterable<FileSystemItem>)this.hierarchy.listChildren(fsItem), infoFetcher);
    }

    private Option<Tuple2<FileSystemItem, FileFormat>> inferFromMarker(FileSystemDirectory fsItem) {
        if (this.deltaLakeMarker().matches(fsItem)) {
            return new Some((Object)new Tuple2((Object)fsItem, (Object)this.deltaLakeMarker().format()));
        }
        return None$.MODULE$;
    }

    /*
     * Enabled aggressive block sorting
     */
    private <B> Try<Option<B>> inferFromFiles(FileSystemItem parent, Seq<FileSystemItem> files, InfoFetcher<B> infoFetcher) {
        Option option;
        Try res = Extensions.OptionTryExtension$.MODULE$.sequence$extension(Extensions$.MODULE$.OptionTryExtension(((IterableOnce)files.sorted(this.byTimestampOrdering())).iterator().flatMap((Function1 & Serializable)fsItem -> this.inferFormat((FileSystemItem)fsItem)).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                FileSystemItem fsItem = (FileSystemItem)tuple2._1();
                FileFormat inputFormat = (FileFormat)tuple2._2();
                return infoFetcher.fetch(fsItem, inputFormat).map((Function1 & Serializable)x$6 -> x$6.map((Function1 & Serializable)x$7 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)fsItem), x$7)));
            }
            throw new MatchError((Object)tuple2);
        }).find((Function1 & Serializable)info -> BoxesRunTime.boxToBoolean((boolean)FormatDetector.$anonfun$inferFromFiles$5(info))))).map((Function1 & Serializable)x$8 -> x$8.flatten((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        boolean bl = false;
        Success success = null;
        Try try_ = res;
        if (try_ instanceof Success) {
            Some some;
            Tuple2 tuple2;
            bl = true;
            success = (Success)try_;
            Option option2 = (Option)success.value();
            if (option2 instanceof Some && (tuple2 = (Tuple2)(some = (Some)option2).value()) != null) {
                FileSystemItem fsItem2 = (FileSystemItem)tuple2._1();
                this.logger().trace("infer_from_files_success matching_file='{}'", (Object)fsItem2.path());
                return res.map((Function1 & Serializable)x$9 -> x$9.map((Function1 & Serializable)x$10 -> x$10._2()));
            }
        }
        if (bl && None$.MODULE$.equals(option = (Option)success.value())) {
            this.logger().trace("infer_from_files_empty_info parent_folder='{}'", (Object)parent.path());
            return res.map((Function1 & Serializable)x$9 -> x$9.map((Function1 & Serializable)x$10 -> x$10._2()));
        }
        if (!(try_ instanceof Failure)) throw new MatchError((Object)try_);
        Failure failure = (Failure)try_;
        Throwable t = failure.exception();
        this.logger().trace("infer_from_files_failed parent_folder='{}'", (Object)parent.path(), (Object)t);
        return res.map((Function1 & Serializable)x$9 -> x$9.map((Function1 & Serializable)x$10 -> x$10._2()));
    }

    private Option<Tuple2<FileSystemItem, FileFormat>> inferFormat(FileSystemItem fsItem) {
        String filename = fsItem.path().name();
        return this.discoveryPattern.extensionRules().all().find((Function1 & Serializable)r -> BoxesRunTime.boxToBoolean((boolean)FormatDetector.$anonfun$inferFormat$1(filename, r))).map((Function1 & Serializable)rule -> new Tuple2((Object)fsItem, (Object)rule.format()));
    }

    public static final /* synthetic */ boolean $anonfun$isDataset$1(Option x$1) {
        return BoxesRunTime.unboxToBoolean((Object)x$1.getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false));
    }

    public static final /* synthetic */ boolean $anonfun$inferFromDirectoryContent$6(Try info) {
        return info.isFailure() || ((Option)info.get()).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$inferFromFiles$5(Try info) {
        return info.isFailure() || ((Option)info.get()).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$inferFormat$1(String filename$1, ExtensionRule r) {
        return r.filePattern().matcher(filename$1).matches();
    }

    public FormatDetector(InventoryPatterns discoveryPattern, FileSystemHierarchy hierarchy, FileSystemClient fsClient) {
        this.discoveryPattern = discoveryPattern;
        this.hierarchy = hierarchy;
        this.fsClient = fsClient;
        this.logger = LoggerFactory.getLogger(FormatDetector.class);
        this.deltaLakeMarker = DeltaLakeMarker$.MODULE$.apply(hierarchy);
        this.byTimestampOrdering = package$.MODULE$.Ordering().by((Function1 & Serializable)no -> no.timestamp(), Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms())).reverse();
    }
}

