/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.filesystem.schema;

import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.util.Success;
import scala.util.Try;
import zeenea.connector.filesystem.FileSystemClient;
import zeenea.connector.filesystem.FileSystemDirectory;
import zeenea.connector.filesystem.FileSystemFile;
import zeenea.connector.filesystem.FileSystemHierarchy;
import zeenea.connector.filesystem.FileSystemItem;
import zeenea.connector.filesystem.inventory.InventoryPatterns;
import zeenea.connector.filesystem.schema.AvroFileFormat$;
import zeenea.connector.filesystem.schema.CsvFileFormat$;
import zeenea.connector.filesystem.schema.DeltaLakeFileFormat$;
import zeenea.connector.filesystem.schema.FileFormat;
import zeenea.connector.filesystem.schema.FileSchema;
import zeenea.connector.filesystem.schema.JsonFileFormat$;
import zeenea.connector.filesystem.schema.OrcFileFormat$;
import zeenea.connector.filesystem.schema.ParquetFileFormat$;
import zeenea.connector.filesystem.schema.SchemaExtractor;
import zeenea.connector.filesystem.schema.XmlFileFormat$;
import zeenea.connector.filesystem.schema.avro.AvroSchemaExtractor$;
import zeenea.connector.filesystem.schema.csv.CsvSchemaExtractor$;
import zeenea.connector.filesystem.schema.deltalake.DeltaLakeSchemaExtractor$;
import zeenea.connector.filesystem.schema.json.JsonSchemaExtractor$;
import zeenea.connector.filesystem.schema.orc.OrcSchemaExtractor$;
import zeenea.connector.filesystem.schema.parquet.ParquetSchemaExtractor;
import zeenea.connector.filesystem.schema.parquet.ParquetSchemaExtractor$;
import zeenea.connector.filesystem.schema.xml.XmlSchemaExtractor$;
import zeenea.connector.source.SourceField;

@ScalaSignature(bytes="\u0006\u0005\u00193AAB\u0004\u0001!!Aq\u0003\u0001B\u0001B\u0003%\u0001\u0004\u0003\u0005\u001f\u0001\t\u0005\t\u0015!\u0003 \u0011!\u0019\u0003A!A!\u0002\u0013!\u0003\"B\u0014\u0001\t\u0003A\u0003\"\u0002\u0018\u0001\t\u0003y#\u0001\u0005$jY\u0016\u001c6\r[3nCJ+\u0017\rZ3s\u0015\tA\u0011\"\u0001\u0004tG\",W.\u0019\u0006\u0003\u0015-\t!BZ5mKNL8\u000f^3n\u0015\taQ\"A\u0005d_:tWm\u0019;pe*\ta\"\u0001\u0004{K\u0016tW-Y\u0002\u0001'\t\u0001\u0011\u0003\u0005\u0002\u0013+5\t1CC\u0001\u0015\u0003\u0015\u00198-\u00197b\u0013\t12C\u0001\u0004B]f\u0014VMZ\u0001\u0011I&\u001c8m\u001c<fef\u0004\u0016\r\u001e;fe:\u0004\"!\u0007\u000f\u000e\u0003iQ!aG\u0005\u0002\u0013%tg/\u001a8u_JL\u0018BA\u000f\u001b\u0005EIeN^3oi>\u0014\u0018\u0010U1ui\u0016\u0014hn]\u0001\nQ&,'/\u0019:dQf\u0004\"\u0001I\u0011\u000e\u0003%I!AI\u0005\u0003'\u0019KG.Z*zgR,W\u000eS5fe\u0006\u00148\r[=\u0002\u0011\u0019\u001c8\t\\5f]R\u0004\"\u0001I\u0013\n\u0005\u0019J!\u0001\u0005$jY\u0016\u001c\u0016p\u001d;f[\u000ec\u0017.\u001a8u\u0003\u0019a\u0014N\\5u}Q!\u0011f\u000b\u0017.!\tQ\u0003!D\u0001\b\u0011\u00159B\u00011\u0001\u0019\u0011\u0015qB\u00011\u0001 \u0011\u0015\u0019C\u00011\u0001%\u0003)\u0011X-\u00193TG\",W.\u0019\u000b\u0004aq\n\u0005cA\u00195m5\t!G\u0003\u00024'\u0005!Q\u000f^5m\u0013\t)$GA\u0002Uef\u00042AE\u001c:\u0013\tA4C\u0001\u0004PaRLwN\u001c\t\u0003UiJ!aO\u0004\u0003\u0015\u0019KG.Z*dQ\u0016l\u0017\rC\u0003>\u000b\u0001\u0007a(\u0001\u0004gg&#X-\u001c\t\u0003A}J!\u0001Q\u0005\u0003\u001d\u0019KG.Z*zgR,W.\u0013;f[\")!)\u0002a\u0001\u0007\u0006Y\u0011N\u001c9vi\u001a{'/\\1u!\tQC)\u0003\u0002F\u000f\tQa)\u001b7f\r>\u0014X.\u0019;")
public class FileSchemaReader {
    private final InventoryPatterns discoveryPattern;
    private final FileSystemHierarchy hierarchy;
    private final FileSystemClient fsClient;

    public Try<Option<FileSchema>> readSchema(FileSystemItem fsItem, FileFormat inputFormat) {
        boolean bl;
        FileSystemItem fileSystemItem = fsItem;
        if (fileSystemItem instanceof FileSystemDirectory) {
            bl = true;
        } else if (fileSystemItem instanceof FileSystemFile) {
            FileSystemFile fileSystemFile = (FileSystemFile)fileSystemItem;
            bl = fileSystemFile.size() > 0L;
        } else {
            throw new MatchError((Object)fileSystemItem);
        }
        boolean canHaveSchema = bl;
        if (canHaveSchema) {
            SchemaExtractor schemaExtractor;
            FileFormat fileFormat = inputFormat;
            if (ParquetFileFormat$.MODULE$.equals(fileFormat)) {
                schemaExtractor = ParquetSchemaExtractor$.MODULE$.apply(this.fsClient);
            } else if (AvroFileFormat$.MODULE$.equals(fileFormat)) {
                schemaExtractor = AvroSchemaExtractor$.MODULE$.apply(this.fsClient);
            } else if (OrcFileFormat$.MODULE$.equals(fileFormat)) {
                schemaExtractor = OrcSchemaExtractor$.MODULE$.apply(this.fsClient);
            } else if (XmlFileFormat$.MODULE$.equals(fileFormat)) {
                schemaExtractor = XmlSchemaExtractor$.MODULE$.apply(this.discoveryPattern.xml(), this.fsClient);
            } else if (JsonFileFormat$.MODULE$.equals(fileFormat)) {
                schemaExtractor = JsonSchemaExtractor$.MODULE$.apply(this.fsClient);
            } else if (CsvFileFormat$.MODULE$.equals(fileFormat)) {
                schemaExtractor = CsvSchemaExtractor$.MODULE$.apply(this.discoveryPattern.csv(), this.fsClient);
            } else if (DeltaLakeFileFormat$.MODULE$.equals(fileFormat)) {
                schemaExtractor = DeltaLakeSchemaExtractor$.MODULE$.apply(this.hierarchy, this.fsClient);
            } else {
                throw new MatchError((Object)fileFormat);
            }
            ParquetSchemaExtractor schemaExtractor2 = schemaExtractor;
            return schemaExtractor2.getSchema(fsItem).map((Function1 & Serializable)fsOpt -> fsOpt.map((Function1 & Serializable)fs -> new FileSchema(inputFormat, fsItem, (Seq<SourceField>)fs)));
        }
        return new Success((Object)None$.MODULE$);
    }

    public FileSchemaReader(InventoryPatterns discoveryPattern, FileSystemHierarchy hierarchy, FileSystemClient fsClient) {
        this.discoveryPattern = discoveryPattern;
        this.hierarchy = hierarchy;
        this.fsClient = fsClient;
    }
}

