/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.filesystem.inventory;

import java.util.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.AbstractIterator;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import zeenea.connector.filesystem.FileSystemKind;
import zeenea.connector.filesystem.TracingContext;
import zeenea.connector.filesystem.inventory.DatasetRef;
import zeenea.connector.filesystem.inventory.InventoryLimits;
import zeenea.connector.filesystem.inventory.InventoryWalker;
import zeenea.connector.filesystem.inventory.TooLargeInventoryException;
import zeenea.connector.source.SourcePath;
import zeenea.connector.source.SourcePath$;
import zeenea.connector.source.ZeePath;

@ScalaSignature(bytes="\u0006\u0005u4A\u0001F\u000b\u0001=!AQ\u0006\u0001B\u0001B\u0003%a\u0006\u0003\u00053\u0001\t\u0005\t\u0015!\u00034\u0011!1\u0004A!A!\u0002\u00139\u0004\u0002C\u001e\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001f\t\u000b}\u0002A\u0011\u0001!\t\u000f\u0019\u0003!\u0019!C\u0005\u000f\"1\u0001\u000b\u0001Q\u0001\n!Cq!\u0015\u0001A\u0002\u0013%!\u000bC\u0004X\u0001\u0001\u0007I\u0011\u0002-\t\ry\u0003\u0001\u0015)\u0003T\u0011\u001dy\u0006\u00011A\u0005\n\u0001Dq\u0001\u001a\u0001A\u0002\u0013%Q\r\u0003\u0004h\u0001\u0001\u0006K!\u0019\u0005\bQ\u0002\u0001\r\u0011\"\u0003j\u0011\u001di\u0007\u00011A\u0005\n9Da\u0001\u001d\u0001!B\u0013Q\u0007\"B9\u0001\t\u000b\u0012\u0006\"B=\u0001\t\u0003R\b\"B>\u0001\t\u0013a(!E%om\u0016tGo\u001c:z\u0013R,'/\u0019;pe*\u0011acF\u0001\nS:4XM\u001c;pefT!\u0001G\r\u0002\u0015\u0019LG.Z:zgR,WN\u0003\u0002\u001b7\u0005I1m\u001c8oK\u000e$xN\u001d\u0006\u00029\u00051!0Z3oK\u0006\u001c\u0001a\u0005\u0002\u0001?A\u0019\u0001%J\u0014\u000e\u0003\u0005R!AI\u0012\u0002\u0015\r|G\u000e\\3di&|gNC\u0001%\u0003\u0015\u00198-\u00197b\u0013\t1\u0013E\u0001\tBEN$(/Y2u\u0013R,'/\u0019;peB\u0011\u0001fK\u0007\u0002S)\u0011!&G\u0001\u0007g>,(oY3\n\u00051J#AC*pkJ\u001cW\rU1uQ\u0006\u00191\r\u001e=\u0011\u0005=\u0002T\"A\f\n\u0005E:\"A\u0004+sC\u000eLgnZ\"p]R,\u0007\u0010^\u0001\u0005W&tG\r\u0005\u00020i%\u0011Qg\u0006\u0002\u000f\r&dWmU=ti\u0016l7*\u001b8e\u0003\u0019a\u0017.\\5ugB\u0011\u0001(O\u0007\u0002+%\u0011!(\u0006\u0002\u0010\u0013:4XM\u001c;pefd\u0015.\\5ug\u00061q/\u00197lKJ\u0004\"\u0001O\u001f\n\u0005y*\"aD%om\u0016tGo\u001c:z/\u0006d7.\u001a:\u0002\rqJg.\u001b;?)\u0015\t%i\u0011#F!\tA\u0004\u0001C\u0003.\u000b\u0001\u0007a\u0006C\u00033\u000b\u0001\u00071\u0007C\u00037\u000b\u0001\u0007q\u0007C\u0003<\u000b\u0001\u0007A(\u0001\u0004m_\u001e<WM]\u000b\u0002\u0011B\u0011\u0011JT\u0007\u0002\u0015*\u00111\nT\u0001\u0006g24GG\u001b\u0006\u0002\u001b\u0006\u0019qN]4\n\u0005=S%A\u0002'pO\u001e,'/A\u0004m_\u001e<WM\u001d\u0011\u0002\t\u0011|g.Z\u000b\u0002'B\u0011A+V\u0007\u0002G%\u0011ak\t\u0002\b\u0005>|G.Z1o\u0003!!wN\\3`I\u0015\fHCA-]!\t!&,\u0003\u0002\\G\t!QK\\5u\u0011\u001di\u0016\"!AA\u0002M\u000b1\u0001\u001f\u00132\u0003\u0015!wN\\3!\u0003\u001dqW\r\u001f;WC2,\u0012!\u0019\t\u0004)\n<\u0013BA2$\u0005\u0019y\u0005\u000f^5p]\u0006Ya.\u001a=u-\u0006dw\fJ3r)\tIf\rC\u0004^\u0019\u0005\u0005\t\u0019A1\u0002\u00119,\u0007\u0010\u001e,bY\u0002\nQaY8v]R,\u0012A\u001b\t\u0003).L!\u0001\\\u0012\u0003\t1{gnZ\u0001\nG>,h\u000e^0%KF$\"!W8\t\u000fu{\u0011\u0011!a\u0001U\u000611m\\;oi\u0002\nq\u0001[1t\u001d\u0016DH\u000f\u000b\u0002\u0012gB\u0011Ao^\u0007\u0002k*\u0011aoI\u0001\u000bC:tw\u000e^1uS>t\u0017B\u0001=v\u0005\u001d!\u0018-\u001b7sK\u000e\fAA\\3yiR\tq%\u0001\bd_6\u0004X\u000f^3OKb$h+\u00197\u0015\u0003e\u0003")
public class InventoryIterator
extends AbstractIterator<SourcePath> {
    private final String ctx;
    private final FileSystemKind kind;
    private final InventoryLimits limits;
    private final InventoryWalker walker;
    private final Logger logger;
    private boolean done;
    private Option<SourcePath> nextVal;
    private long count;

    private Logger logger() {
        return this.logger;
    }

    private boolean done() {
        return this.done;
    }

    private void done_$eq(boolean x$1) {
        this.done = x$1;
    }

    private Option<SourcePath> nextVal() {
        return this.nextVal;
    }

    private void nextVal_$eq(Option<SourcePath> x$1) {
        this.nextVal = x$1;
    }

    private long count() {
        return this.count;
    }

    private void count_$eq(long x$1) {
        this.count = x$1;
    }

    public final boolean hasNext() {
        while (!this.nextVal().isDefined()) {
            if (this.done()) {
                return false;
            }
            this.computeNextVal();
        }
        return true;
    }

    public SourcePath next() {
        if (this.hasNext() && this.nextVal().isDefined()) {
            SourcePath value = (SourcePath)this.nextVal().get();
            this.nextVal_$eq((Option<SourcePath>)None$.MODULE$);
            this.count_$eq(this.count() + 1L);
            if (this.count() > (long)this.limits.maxItems()) {
                throw new TooLargeInventoryException(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(422).append("file_system_").append(this.kind).append("_standard_inventory_walker_too_many_items_in_inventory ").append(new TracingContext(this.ctx)).append(" count='").append(this.count()).append("'\n             |    ------------------------------------------------------------------------\n             |    Check that the inventory parameters fit your use case.\n             |    If the count is valid, increase the value of inventory.limits.max_items.\n             |    ------------------------------------------------------------------------").toString())));
            }
            return value;
        }
        throw new NoSuchElementException("No more items");
    }

    private void computeNextVal() {
        Option<DatasetRef> option = this.walker.next();
        if (option instanceof Some) {
            Some some = (Some)option;
            DatasetRef datasetRef = (DatasetRef)some.value();
            Try<ZeePath> try_ = datasetRef.toZeepath();
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                ZeePath zeepath = (ZeePath)success.value();
                this.nextVal_$eq((Option<SourcePath>)new Some((Object)new SourcePath(zeepath, datasetRef.label(), SourcePath$.MODULE$.apply$default$3())));
                this.logger().debug("file_system_{}_inventory_item_found {} zeepath='{}'", new Object[]{this.kind, new TracingContext(this.ctx), zeepath.escapedValue()});
            } else if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                this.logger().warn("file_system_{}_invalid_zeepath {} dataset_ref='{}' {}", new Object[]{this.kind, new TracingContext(this.ctx), datasetRef, e.getMessage()});
            } else {
                throw new MatchError(try_);
            }
            return;
        }
        if (None$.MODULE$.equals(option)) {
            this.done_$eq(true);
            this.logger().info("file_system_{}_inventory_end {} dataset_count='{}'", new Object[]{this.kind, new TracingContext(this.ctx), BoxesRunTime.boxToLong((long)this.count())});
            return;
        }
        throw new MatchError(option);
    }

    public InventoryIterator(String ctx, FileSystemKind kind, InventoryLimits limits, InventoryWalker walker) {
        this.ctx = ctx;
        this.kind = kind;
        this.limits = limits;
        this.walker = walker;
        this.logger = LoggerFactory.getLogger(InventoryIterator.class);
        this.done = false;
        this.nextVal = None$.MODULE$;
        this.count = 0L;
    }
}

