/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.filesystem.inventory;

import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import zeenea.connector.filesystem.FilePath;
import zeenea.connector.filesystem.FilePath$;
import zeenea.connector.filesystem.FileSystemKind;
import zeenea.connector.filesystem.inventory.DatasetRef;
import zeenea.connector.filesystem.inventory.LegacyDatasetRef;
import zeenea.connector.filesystem.inventory.StandardDatasetRef;
import zeenea.connector.filesystem.inventory.StandardMarkedDatasetRef;
import zeenea.connector.filesystem.schema.FileFormat;
import zeenea.connector.filesystem.schema.FileFormat$;
import zeenea.connector.filesystem.schema.FileFormatWithExtension;
import zeenea.connector.filesystem.schema.FileFormatWithMark;
import zeenea.connector.source.ZeePath;

public final class DatasetRef$ {
    public static final DatasetRef$ MODULE$ = new DatasetRef$();

    public Try<DatasetRef> legacy(FileSystemKind kind, ZeePath zeePath) {
        if (zeePath.isEmpty()) {
            return new Failure((Throwable)new IllegalArgumentException(new StringBuilder(51).append("file_system_").append(kind).append("_invalid_legacy_zeepath_empty_root_path").toString()));
        }
        return new Success((Object)new LegacyDatasetRef(FilePath$.MODULE$.from(zeePath)));
    }

    public Try<DatasetRef> standard(FileSystemKind kind, ZeePath zeePath) {
        FilePath logicalPath = FilePath$.MODULE$.from(zeePath);
        String name = logicalPath.name();
        int dotIndex = name.lastIndexOf(46);
        if (dotIndex >= 0) {
            return FileFormat$.MODULE$.from(name.substring(dotIndex + 1)).map((Function1 & Serializable)format -> {
                String baseName = name.substring(0, dotIndex);
                FileFormat fileFormat = format;
                if (fileFormat instanceof FileFormatWithExtension) {
                    FileFormatWithExtension fileFormatWithExtension = (FileFormatWithExtension)fileFormat;
                    FilePath root = (FilePath)logicalPath.parent().getOrElse((Function0 & Serializable)() -> FilePath$.MODULE$.root());
                    return new StandardDatasetRef(root, baseName, fileFormatWithExtension);
                }
                if (fileFormat instanceof FileFormatWithMark) {
                    FileFormatWithMark fileFormatWithMark = (FileFormatWithMark)fileFormat;
                    FilePath path = logicalPath.rename((Function1<String, String>)(Function1 & Serializable)x$1 -> baseName);
                    return new StandardMarkedDatasetRef(path, fileFormatWithMark);
                }
                throw new MatchError((Object)fileFormat);
            });
        }
        return new Failure((Throwable)new IllegalArgumentException(new StringBuilder(57).append("file_system_").append(kind).append("_invalid_standard_zeepath_missing_item_type: ").append(zeePath.escapedValue()).toString()));
    }

    private DatasetRef$() {
    }
}

