/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.filesystem;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.util.Try;
import scala.util.Try$;
import zeenea.connector.commons.cache.CacheData;
import zeenea.connector.filesystem.FilePath;
import zeenea.connector.filesystem.FilePath$;
import zeenea.connector.filesystem.FileSystemDirectory;
import zeenea.connector.filesystem.FileSystemFile;
import zeenea.connector.filesystem.FileSystemItem;

public final class FileSystemItem$ {
    public static final FileSystemItem$ MODULE$ = new FileSystemItem$();

    public Try<FileSystemItem> fromCache(Option<FilePath> parentPath, CacheData data) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            ByteBuffer bb = data.toByteBuffer();
            byte kind = bb.get();
            int id = bb.getInt();
            int nameLen = bb.getInt();
            byte[] nameBytes = new byte[nameLen];
            bb.get(nameBytes);
            String name = new String(nameBytes, StandardCharsets.UTF_8);
            FilePath path = (FilePath)parentPath.map((Function1 & Serializable)p -> p.child(name)).getOrElse((Function0 & Serializable)() -> FilePath$.MODULE$.apply(name));
            Instant timestamp = Instant.ofEpochMilli(bb.getLong());
            byte by = kind;
            switch (by) {
                case 70: {
                    long size = bb.getLong();
                    return new FileSystemFile(id, path, timestamp, size);
                }
                case 68: {
                    int childrenSize = bb.getInt();
                    int[] children = new int[childrenSize];
                    RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), childrenSize).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                        children$1[i] = bb.getInt();
                    });
                    return new FileSystemDirectory(id, path, timestamp, children);
                }
            }
            throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by));
        });
    }

    private FileSystemItem$() {
    }
}

