/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.filesystem;

import java.io.Serializable;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import scala.Function1;
import scala.Function2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction2;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import zeenea.connector.commons.cache.CacheData;
import zeenea.connector.filesystem.FilePath;
import zeenea.connector.filesystem.FileSystemDirectory;
import zeenea.connector.filesystem.FileSystemItem;

@ScalaSignature(bytes="\u0006\u0005Y4A!\u0005\n\u00033!AA\u0005\u0001BC\u0002\u0013\u0005S\u0005\u0003\u0005*\u0001\t\u0005\t\u0015!\u0003'\u0011!Q\u0003A!b\u0001\n\u0003Z\u0003\u0002C\u0018\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0017\t\u0011A\u0002!Q1A\u0005BEB\u0001B\u000f\u0001\u0003\u0002\u0003\u0006IA\r\u0005\tw\u0001\u0011)\u0019!C\u0001y!A\u0001\t\u0001B\u0001B\u0003%Q\bC\u0003B\u0001\u0011\u0005!\tC\u0003I\u0001\u0011\u0005\u0011\nC\u0003S\u0001\u0011\u00053\u000bC\u0003^\u0001\u0011\u0005c\fC\u0003a\u0001\u0011\u0005\u0013\rC\u0003f\u0001\u0011\u0005c\rC\u0003n\u0001\u0011\u0005c\u000eC\u0003u\u0001\u0011\u0005SO\u0001\bGS2,7+_:uK64\u0015\u000e\\3\u000b\u0005M!\u0012A\u00034jY\u0016\u001c\u0018p\u001d;f[*\u0011QCF\u0001\nG>tg.Z2u_JT\u0011aF\u0001\u0007u\u0016,g.Z1\u0004\u0001M\u0019\u0001A\u0007\u0011\u0011\u0005mqR\"\u0001\u000f\u000b\u0003u\tQa]2bY\u0006L!a\b\u000f\u0003\r\u0005s\u0017PU3g!\t\t#%D\u0001\u0013\u0013\t\u0019#C\u0001\bGS2,7+_:uK6LE/Z7\u0002\u0011\r\f7\r[3LKf,\u0012A\n\t\u00037\u001dJ!\u0001\u000b\u000f\u0003\u0007%sG/A\u0005dC\u000eDWmS3zA\u0005!\u0001/\u0019;i+\u0005a\u0003CA\u0011.\u0013\tq#C\u0001\u0005GS2,\u0007+\u0019;i\u0003\u0015\u0001\u0018\r\u001e5!\u0003%!\u0018.\\3ti\u0006l\u0007/F\u00013!\t\u0019\u0004(D\u00015\u0015\t)d'\u0001\u0003uS6,'\"A\u001c\u0002\t)\fg/Y\u0005\u0003sQ\u0012q!\u00138ti\u0006tG/\u0001\u0006uS6,7\u000f^1na\u0002\nAa]5{KV\tQ\b\u0005\u0002\u001c}%\u0011q\b\b\u0002\u0005\u0019>tw-A\u0003tSj,\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0006\u0007\u0012+ei\u0012\t\u0003C\u0001AQ\u0001J\u0005A\u0002\u0019BQAK\u0005A\u00021BQ\u0001M\u0005A\u0002IBQaO\u0005A\u0002u\nA\u0002^8DC\u000eDWMV1mk\u0016,\u0012A\u0013\t\u0003\u0017Bk\u0011\u0001\u0014\u0006\u0003\u001b:\u000bQaY1dQ\u0016T!a\u0014\u000b\u0002\u000f\r|W.\\8og&\u0011\u0011\u000b\u0014\u0002\n\u0007\u0006\u001c\u0007.\u001a#bi\u0006\f1\"Y:ESJ,7\r^8ssV\tA\u000bE\u0002V1jk\u0011A\u0016\u0006\u0003/r\tA!\u001e;jY&\u0011\u0011L\u0016\u0002\u0004)JL\bCA\u0011\\\u0013\ta&CA\nGS2,7+_:uK6$\u0015N]3di>\u0014\u00180\u0001\u0004bg\u001aKG.Z\u000b\u0002?B\u0019Q\u000bW\"\u0002\u000f%\u001cX)\u001c9usV\t!\r\u0005\u0002\u001cG&\u0011A\r\b\u0002\b\u0005>|G.Z1o\u0003!!xn\u0015;sS:<G#A4\u0011\u0005!\\W\"A5\u000b\u0005)4\u0014\u0001\u00027b]\u001eL!\u0001\\5\u0003\rM#(/\u001b8h\u0003\u0019)\u0017/^1mgR\u0011!m\u001c\u0005\u0006a>\u0001\r!]\u0001\u0006_RDWM\u001d\t\u00037IL!a\u001d\u000f\u0003\u0007\u0005s\u00170\u0001\u0005iCND7i\u001c3f)\u00051\u0003")
public final class FileSystemFile
implements FileSystemItem {
    private final int cacheKey;
    private final FilePath path;
    private final Instant timestamp;
    private final long size;

    @Override
    public boolean isDirectory() {
        return FileSystemItem.isDirectory$(this);
    }

    @Override
    public boolean isFile() {
        return FileSystemItem.isFile$(this);
    }

    @Override
    public int cacheKey() {
        return this.cacheKey;
    }

    @Override
    public FilePath path() {
        return this.path;
    }

    @Override
    public Instant timestamp() {
        return this.timestamp;
    }

    public long size() {
        return this.size;
    }

    @Override
    public CacheData toCacheValue() {
        byte[] nameBytes = this.path().name().getBytes(StandardCharsets.UTF_8);
        ByteBuffer bb = ByteBuffer.allocate(25 + nameBytes.length);
        bb.put((byte)70);
        bb.putInt(this.cacheKey());
        bb.putInt(nameBytes.length);
        bb.put(nameBytes);
        bb.putLong(this.timestamp().toEpochMilli());
        bb.putLong(this.size());
        ((Buffer)bb).flip();
        return CacheData.of((ByteBuffer)bb);
    }

    @Override
    public Try<FileSystemDirectory> asDirectory() {
        return new Failure((Throwable)new IllegalStateException(new StringBuilder(20).append("'").append(this.path()).append("' isn't a directory").toString()));
    }

    @Override
    public Try<FileSystemFile> asFile() {
        return new Success((Object)this);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0L;
    }

    public String toString() {
        return new StringBuilder(58).append("FileSystemFile(cacheKey='").append(this.cacheKey()).append("' path='").append(this.path()).append("', timestamp='").append(this.timestamp()).append("', size='").append(this.size()).append("')").toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        Object object = other;
        if (!(object instanceof FileSystemFile)) return false;
        FileSystemFile fileSystemFile = (FileSystemFile)object;
        if (this.cacheKey() != fileSystemFile.cacheKey()) return false;
        FilePath filePath = this.path();
        FilePath filePath2 = fileSystemFile.path();
        if (filePath == null) {
            if (filePath2 != null) {
                return false;
            }
        } else if (!((Object)filePath).equals(filePath2)) return false;
        Instant instant = this.timestamp();
        Instant instant2 = fileSystemFile.timestamp();
        if (instant == null) {
            if (instant2 != null) {
                return false;
            }
        } else if (!((Object)instant).equals(instant2)) return false;
        if (this.size() != fileSystemFile.size()) return false;
        return true;
    }

    public int hashCode() {
        Seq state = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.cacheKey()), this.path(), this.timestamp(), BoxesRunTime.boxToLong((long)this.size())}));
        return BoxesRunTime.unboxToInt((Object)((IterableOnceOps)state.map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.hashCode()))).foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)(JFunction2.mcIII.sp & Serializable)(a, b) -> 31 * a + b));
    }

    public FileSystemFile(int cacheKey, FilePath path, Instant timestamp, long size) {
        this.cacheKey = cacheKey;
        this.path = path;
        this.timestamp = timestamp;
        this.size = size;
        FileSystemItem.$init$(this);
    }
}

