/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.filesystem;

import java.io.Serializable;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Arrays;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import zeenea.connector.commons.cache.CacheData;
import zeenea.connector.filesystem.FilePath;
import zeenea.connector.filesystem.FileSystemFile;
import zeenea.connector.filesystem.FileSystemItem;

@ScalaSignature(bytes="\u0006\u0005a4AAE\n\u00035!AQ\u0005\u0001BC\u0002\u0013\u0005c\u0005\u0003\u0005+\u0001\t\u0005\t\u0015!\u0003(\u0011!Y\u0003A!b\u0001\n\u0003b\u0003\u0002\u0003\u0019\u0001\u0005\u0003\u0005\u000b\u0011B\u0017\t\u0011E\u0002!Q1A\u0005BIB\u0001b\u000f\u0001\u0003\u0002\u0003\u0006Ia\r\u0005\ty\u0001\u0011)\u0019!C\u0005{!A\u0011\t\u0001B\u0001B\u0003%a\bC\u0003C\u0001\u0011\u00051\tC\u0003J\u0001\u0011\u0005Q\bC\u0003K\u0001\u0011\u00051\nC\u0003U\u0001\u0011\u0005S\u000bC\u0003]\u0001\u0011\u0005S\fC\u0003c\u0001\u0011\u00053\rC\u0003h\u0001\u0011\u0005\u0003\u000eC\u0003p\u0001\u0011\u0005\u0003\u000fC\u0003w\u0001\u0011\u0005sOA\nGS2,7+_:uK6$\u0015N]3di>\u0014\u0018P\u0003\u0002\u0015+\u0005Qa-\u001b7fgf\u001cH/Z7\u000b\u0005Y9\u0012!C2p]:,7\r^8s\u0015\u0005A\u0012A\u0002>fK:,\u0017m\u0001\u0001\u0014\u0007\u0001Y\u0012\u0005\u0005\u0002\u001d?5\tQDC\u0001\u001f\u0003\u0015\u00198-\u00197b\u0013\t\u0001SD\u0001\u0004B]f\u0014VM\u001a\t\u0003E\rj\u0011aE\u0005\u0003IM\u0011aBR5mKNK8\u000f^3n\u0013R,W.\u0001\u0005dC\u000eDWmS3z+\u00059\u0003C\u0001\u000f)\u0013\tISDA\u0002J]R\f\u0011bY1dQ\u0016\\U-\u001f\u0011\u0002\tA\fG\u000f[\u000b\u0002[A\u0011!EL\u0005\u0003_M\u0011\u0001BR5mKB\u000bG\u000f[\u0001\u0006a\u0006$\b\u000eI\u0001\ni&lWm\u001d;b[B,\u0012a\r\t\u0003iej\u0011!\u000e\u0006\u0003m]\nA\u0001^5nK*\t\u0001(\u0001\u0003kCZ\f\u0017B\u0001\u001e6\u0005\u001dIen\u001d;b]R\f!\u0002^5nKN$\u0018-\u001c9!\u00035\u0019\u0007.\u001b7ee\u0016t\u0017I\u001d:bsV\ta\bE\u0002\u001d\u007f\u001dJ!\u0001Q\u000f\u0003\u000b\u0005\u0013(/Y=\u0002\u001d\rD\u0017\u000e\u001c3sK:\f%O]1zA\u00051A(\u001b8jiz\"R\u0001R#G\u000f\"\u0003\"A\t\u0001\t\u000b\u0015J\u0001\u0019A\u0014\t\u000b-J\u0001\u0019A\u0017\t\u000bEJ\u0001\u0019A\u001a\t\u000bqJ\u0001\u0019\u0001 \u0002\u0011\rD\u0017\u000e\u001c3sK:\fA\u0002^8DC\u000eDWMV1mk\u0016,\u0012\u0001\u0014\t\u0003\u001bJk\u0011A\u0014\u0006\u0003\u001fB\u000bQaY1dQ\u0016T!!U\u000b\u0002\u000f\r|W.\\8og&\u00111K\u0014\u0002\n\u0007\u0006\u001c\u0007.\u001a#bi\u0006\f1\"Y:ESJ,7\r^8ssV\ta\u000bE\u0002X5\u0012k\u0011\u0001\u0017\u0006\u00033v\tA!\u001e;jY&\u00111\f\u0017\u0002\u0004)JL\u0018AB1t\r&dW-F\u0001_!\r9&l\u0018\t\u0003E\u0001L!!Y\n\u0003\u001d\u0019KG.Z*zgR,WNR5mK\u00069\u0011n]#naRLX#\u00013\u0011\u0005q)\u0017B\u00014\u001e\u0005\u001d\u0011un\u001c7fC:\f\u0001\u0002^8TiJLgn\u001a\u000b\u0002SB\u0011!.\\\u0007\u0002W*\u0011AnN\u0001\u0005Y\u0006tw-\u0003\u0002oW\n11\u000b\u001e:j]\u001e\fa!Z9vC2\u001cHC\u00013r\u0011\u0015\u0011\b\u00031\u0001t\u0003\u0015yG\u000f[3s!\taB/\u0003\u0002v;\t\u0019\u0011I\\=\u0002\u0011!\f7\u000f[\"pI\u0016$\u0012a\n")
public final class FileSystemDirectory
implements FileSystemItem {
    private final int cacheKey;
    private final FilePath path;
    private final Instant timestamp;
    private final int[] childrenArray;

    @Override
    public boolean isDirectory() {
        return FileSystemItem.isDirectory$(this);
    }

    @Override
    public boolean isFile() {
        return FileSystemItem.isFile$(this);
    }

    @Override
    public int cacheKey() {
        return this.cacheKey;
    }

    @Override
    public FilePath path() {
        return this.path;
    }

    @Override
    public Instant timestamp() {
        return this.timestamp;
    }

    private int[] childrenArray() {
        return this.childrenArray;
    }

    public int[] children() {
        return (int[])this.childrenArray().clone();
    }

    @Override
    public CacheData toCacheValue() {
        byte[] nameBytes = this.path().name().getBytes(StandardCharsets.UTF_8);
        ByteBuffer bb = ByteBuffer.allocate(25 + nameBytes.length + 4 * this.childrenArray().length);
        bb.put((byte)68);
        bb.putInt(this.cacheKey());
        bb.putInt(nameBytes.length);
        bb.put(nameBytes);
        bb.putLong(this.timestamp().toEpochMilli());
        bb.putInt(this.childrenArray().length);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.intArrayOps(this.childrenArray()), (Function1 & Serializable)c -> bb.putInt(BoxesRunTime.unboxToInt((Object)c)));
        ((Buffer)bb).flip();
        return CacheData.of((ByteBuffer)bb);
    }

    @Override
    public Try<FileSystemDirectory> asDirectory() {
        return new Success((Object)this);
    }

    @Override
    public Try<FileSystemFile> asFile() {
        return new Failure((Throwable)new IllegalStateException(new StringBuilder(15).append("'").append(this.path()).append("' isn't a file").toString()));
    }

    @Override
    public boolean isEmpty() {
        return ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.intArrayOps(this.childrenArray()));
    }

    public String toString() {
        return new StringBuilder(65).append("FileSystemDirectory(key='").append(this.cacheKey()).append("' path='").append(this.path()).append("', timestamp='").append(this.timestamp()).append("', child_count='").append(this.childrenArray().length).append("')").toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        Object object = other;
        if (!(object instanceof FileSystemDirectory)) return false;
        FileSystemDirectory fileSystemDirectory = (FileSystemDirectory)object;
        if (this.cacheKey() != fileSystemDirectory.cacheKey()) return false;
        FilePath filePath = this.path();
        FilePath filePath2 = fileSystemDirectory.path();
        if (filePath == null) {
            if (filePath2 != null) {
                return false;
            }
        } else if (!((Object)filePath).equals(filePath2)) return false;
        Instant instant = this.timestamp();
        Instant instant2 = fileSystemDirectory.timestamp();
        if (instant == null) {
            if (instant2 != null) {
                return false;
            }
        } else if (!((Object)instant).equals(instant2)) return false;
        if (!Predef$.MODULE$.wrapIntArray(this.childrenArray()).sameElements((IterableOnce)Predef$.MODULE$.wrapIntArray(fileSystemDirectory.childrenArray()))) return false;
        return true;
    }

    public int hashCode() {
        return Arrays.deepHashCode(new Object[]{BoxesRunTime.boxToInteger((int)this.cacheKey()), this.path(), this.timestamp(), this.childrenArray()});
    }

    public FileSystemDirectory(int cacheKey, FilePath path, Instant timestamp, int[] childrenArray) {
        this.cacheKey = cacheKey;
        this.path = path;
        this.timestamp = timestamp;
        this.childrenArray = childrenArray;
        FileSystemItem.$init$(this);
    }
}

