/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.common.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.apache.hive.common.util.Murmur3;

public class BloomFilter {
    public static final double DEFAULT_FPP = 0.05;
    protected BitSet bitSet;
    protected int numBits;
    protected int numHashFunctions;
    public static final int START_OF_SERIALIZED_LONGS = 5;

    public BloomFilter() {
    }

    public BloomFilter(long l) {
        this(l, 0.05);
    }

    static void checkArgument(boolean bl, String string) {
        if (!bl) {
            throw new IllegalArgumentException(string);
        }
    }

    public BloomFilter(long l, double d) {
        BloomFilter.checkArgument(l > 0L, "expectedEntries should be > 0");
        BloomFilter.checkArgument(d > 0.0 && d < 1.0, "False positive probability should be > 0.0 & < 1.0");
        int n = BloomFilter.optimalNumOfBits(l, d);
        this.numBits = n + (64 - n % 64);
        this.numHashFunctions = BloomFilter.optimalNumOfHashFunctions(l, this.numBits);
        this.bitSet = new BitSet(this.numBits);
    }

    public BloomFilter(long[] lArray, int n) {
        this.bitSet = new BitSet(lArray);
        this.numBits = lArray.length * 64;
        this.numHashFunctions = n;
    }

    static int optimalNumOfHashFunctions(long l, long l2) {
        return Math.max(1, (int)Math.round((double)l2 / (double)l * Math.log(2.0)));
    }

    static int optimalNumOfBits(long l, double d) {
        return (int)((double)(-l) * Math.log(d) / (Math.log(2.0) * Math.log(2.0)));
    }

    public void add(byte[] byArray) {
        if (byArray == null) {
            this.addBytes(byArray, -1, -1);
        } else {
            this.addBytes(byArray, 0, byArray.length);
        }
    }

    public void addBytes(byte[] byArray, int n, int n2) {
        long l = byArray == null ? 2862933555777941757L : Murmur3.hash64(byArray, n, n2);
        this.addHash(l);
    }

    private void addHash(long l) {
        int n = (int)l;
        int n2 = (int)(l >>> 32);
        for (int i = 1; i <= this.numHashFunctions; ++i) {
            int n3 = n + (i + 1) * n2;
            if (n3 < 0) {
                n3 ^= 0xFFFFFFFF;
            }
            int n4 = n3 % this.numBits;
            this.bitSet.set(n4);
        }
    }

    public void addString(String string) {
        if (string == null) {
            this.add(null);
        } else {
            this.add(string.getBytes());
        }
    }

    public void addLong(long l) {
        this.addHash(this.getLongHash(l));
    }

    public void addDouble(double d) {
        this.addLong(Double.doubleToLongBits(d));
    }

    public boolean test(byte[] byArray) {
        if (byArray == null) {
            return this.testBytes(byArray, -1, -1);
        }
        return this.testBytes(byArray, 0, byArray.length);
    }

    public boolean testBytes(byte[] byArray, int n, int n2) {
        long l = byArray == null ? 2862933555777941757L : Murmur3.hash64(byArray, n, n2);
        return this.testHash(l);
    }

    private boolean testHash(long l) {
        int n = (int)l;
        int n2 = (int)(l >>> 32);
        for (int i = 1; i <= this.numHashFunctions; ++i) {
            int n3;
            int n4 = n + (i + 1) * n2;
            if (n4 < 0) {
                n4 ^= 0xFFFFFFFF;
            }
            if (this.bitSet.get(n3 = n4 % this.numBits)) continue;
            return false;
        }
        return true;
    }

    public boolean testString(String string) {
        if (string == null) {
            return this.test(null);
        }
        return this.test(string.getBytes());
    }

    public boolean testLong(long l) {
        return this.testHash(this.getLongHash(l));
    }

    private long getLongHash(long l) {
        l = (l ^ 0xFFFFFFFFFFFFFFFFL) + (l << 21);
        l ^= l >> 24;
        l = l + (l << 3) + (l << 8);
        l ^= l >> 14;
        l = l + (l << 2) + (l << 4);
        l ^= l >> 28;
        l += l << 31;
        return l;
    }

    public boolean testDouble(double d) {
        return this.testLong(Double.doubleToLongBits(d));
    }

    public long sizeInBytes() {
        return this.getBitSize() / 8;
    }

    public int getBitSize() {
        return this.bitSet.getData().length * 64;
    }

    public int getNumHashFunctions() {
        return this.numHashFunctions;
    }

    public long[] getBitSet() {
        return this.bitSet.getData();
    }

    public String toString() {
        return "m: " + this.numBits + " k: " + this.numHashFunctions;
    }

    public void merge(BloomFilter bloomFilter) {
        if (this == bloomFilter || this.numBits != bloomFilter.numBits || this.numHashFunctions != bloomFilter.numHashFunctions) {
            throw new IllegalArgumentException("BloomFilters are not compatible for merging. this - " + this.toString() + " that - " + bloomFilter.toString());
        }
        this.bitSet.putAll(bloomFilter.bitSet);
    }

    public void reset() {
        this.bitSet.clear();
    }

    public static void serialize(OutputStream outputStream, BloomFilter bloomFilter) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        dataOutputStream.writeByte(bloomFilter.numHashFunctions);
        dataOutputStream.writeInt(bloomFilter.getBitSet().length);
        for (long l : bloomFilter.getBitSet()) {
            dataOutputStream.writeLong(l);
        }
    }

    public static BloomFilter deserialize(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            throw new IOException("Input stream is null");
        }
        try {
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            byte by = dataInputStream.readByte();
            int n = dataInputStream.readInt();
            long[] lArray = new long[n];
            for (int i = 0; i < n; ++i) {
                lArray[i] = dataInputStream.readLong();
            }
            return new BloomFilter(lArray, by);
        }
        catch (RuntimeException runtimeException) {
            IOException iOException = new IOException("Unable to deserialize BloomFilter");
            iOException.initCause(runtimeException);
            throw iOException;
        }
    }

    public static void mergeBloomFilterBytes(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) {
        int n5;
        if (n2 != n4) {
            throw new IllegalArgumentException("bf1Length " + n2 + " does not match bf2Length " + n4);
        }
        for (n5 = 0; n5 < 5; ++n5) {
            if (byArray[n + n5] == byArray2[n3 + n5]) continue;
            throw new IllegalArgumentException("bf1 NumHashFunctions/NumBits does not match bf2");
        }
        for (n5 = 5; n5 < n2; ++n5) {
            int n6 = n + n5;
            byArray[n6] = (byte)(byArray[n6] | byArray2[n3 + n5]);
        }
    }

    public class BitSet {
        private final long[] data;

        public BitSet(long l) {
            this(new long[(int)Math.ceil((double)l / 64.0)]);
        }

        public BitSet(long[] lArray) {
            assert (lArray.length > 0) : "data length is zero!";
            this.data = lArray;
        }

        public void set(int n) {
            int n2 = n >>> 6;
            this.data[n2] = this.data[n2] | 1L << n;
        }

        public boolean get(int n) {
            return (this.data[n >>> 6] & 1L << n) != 0L;
        }

        public long bitSize() {
            return (long)this.data.length * 64L;
        }

        public long[] getData() {
            return this.data;
        }

        public void putAll(BitSet bitSet) {
            assert (this.data.length == bitSet.data.length) : "BitArrays must be of equal length (" + this.data.length + "!= " + bitSet.data.length + ")";
            for (int i = 0; i < this.data.length; ++i) {
                int n = i;
                this.data[n] = this.data[n] | bitSet.data[i];
            }
        }

        public void clear() {
            Arrays.fill(this.data, 0L);
        }
    }
}

