package zeenea.connector.aws.dynamodb.client;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/**
 * Immutable implementation of {@link Field}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableField.builder()}.
 */
@Generated(from = "Field", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableField implements Field {
  @NotNull
  private final String name;
  @NotNull
  private final String key;
  @NotNull
  private final String type;
  private final @Nullable FieldKind kind;
  private final @Nullable String description;
  private final @Nullable Boolean multivalued;

  private ImmutableField(
      String name,
      String key,
      String type,
      @Nullable FieldKind kind,
      @Nullable String description,
      @Nullable Boolean multivalued) {
    this.name = name;
    this.key = key;
    this.type = type;
    this.kind = kind;
    this.description = description;
    this.multivalued = multivalued;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @NotNull
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code key} attribute
   */
  @NotNull
  @Override
  public String getKey() {
    return key;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @NotNull
  @Override
  public String getType() {
    return type;
  }

  /**
   * @return The value of the {@code kind} attribute
   */
  @Override
  public @Nullable FieldKind getKind() {
    return kind;
  }

  /**
   * @return The value of the {@code description} attribute
   */
  @Override
  public @Nullable String getDescription() {
    return description;
  }

  /**
   * @return The value of the {@code multivalued} attribute
   */
  @Override
  public @Nullable Boolean isMultivalued() {
    return multivalued;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Field#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableField withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableField(newValue, this.key, this.type, this.kind, this.description, this.multivalued);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Field#getKey() key} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for key
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableField withKey(String value) {
    String newValue = Objects.requireNonNull(value, "key");
    if (this.key.equals(newValue)) return this;
    return new ImmutableField(this.name, newValue, this.type, this.kind, this.description, this.multivalued);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Field#getType() type} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableField withType(String value) {
    String newValue = Objects.requireNonNull(value, "type");
    if (this.type.equals(newValue)) return this;
    return new ImmutableField(this.name, this.key, newValue, this.kind, this.description, this.multivalued);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Field#getKind() kind} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for kind (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableField withKind(@Nullable FieldKind value) {
    if (this.kind == value) return this;
    return new ImmutableField(this.name, this.key, this.type, value, this.description, this.multivalued);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Field#getDescription() description} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for description (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableField withDescription(@Nullable String value) {
    if (Objects.equals(this.description, value)) return this;
    return new ImmutableField(this.name, this.key, this.type, this.kind, value, this.multivalued);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Field#isMultivalued() multivalued} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for multivalued (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableField withMultivalued(@Nullable Boolean value) {
    if (Objects.equals(this.multivalued, value)) return this;
    return new ImmutableField(this.name, this.key, this.type, this.kind, this.description, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableField} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableField
        && equalTo(0, (ImmutableField) another);
  }

  private boolean equalTo(int synthetic, ImmutableField another) {
    return name.equals(another.name)
        && key.equals(another.key)
        && type.equals(another.type)
        && Objects.equals(kind, another.kind)
        && Objects.equals(description, another.description)
        && Objects.equals(multivalued, another.multivalued);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code key}, {@code type}, {@code kind}, {@code description}, {@code multivalued}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + key.hashCode();
    h += (h << 5) + type.hashCode();
    h += (h << 5) + Objects.hashCode(kind);
    h += (h << 5) + Objects.hashCode(description);
    h += (h << 5) + Objects.hashCode(multivalued);
    return h;
  }

  /**
   * Prints the immutable value {@code Field} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Field{"
        + "name=" + name
        + ", key=" + key
        + ", type=" + type
        + ", kind=" + kind
        + ", description=" + description
        + ", multivalued=" + multivalued
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link Field} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Field instance
   */
  public static ImmutableField copyOf(Field instance) {
    if (instance instanceof ImmutableField) {
      return (ImmutableField) instance;
    }
    return ImmutableField.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableField ImmutableField}.
   * <pre>
   * ImmutableField.builder()
   *    .name(String) // required {@link Field#getName() name}
   *    .key(String) // required {@link Field#getKey() key}
   *    .type(String) // required {@link Field#getType() type}
   *    .kind(zeenea.connector.aws.dynamodb.client.FieldKind | null) // nullable {@link Field#getKind() kind}
   *    .description(String | null) // nullable {@link Field#getDescription() description}
   *    .multivalued(Boolean | null) // nullable {@link Field#isMultivalued() multivalued}
   *    .build();
   * </pre>
   * @return A new ImmutableField builder
   */
  public static ImmutableField.Builder builder() {
    return new ImmutableField.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableField ImmutableField}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Field", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_KEY = 0x2L;
    private static final long INIT_BIT_TYPE = 0x4L;
    private long initBits = 0x7L;

    private @javax.annotation.Nullable String name;
    private @javax.annotation.Nullable String key;
    private @javax.annotation.Nullable String type;
    private @javax.annotation.Nullable FieldKind kind;
    private @javax.annotation.Nullable String description;
    private @javax.annotation.Nullable Boolean multivalued;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Field} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Field instance) {
      Objects.requireNonNull(instance, "instance");
      this.name(instance.getName());
      this.key(instance.getKey());
      this.type(instance.getType());
      @Nullable FieldKind kindValue = instance.getKind();
      if (kindValue != null) {
        kind(kindValue);
      }
      @Nullable String descriptionValue = instance.getDescription();
      if (descriptionValue != null) {
        description(descriptionValue);
      }
      @Nullable Boolean multivaluedValue = instance.isMultivalued();
      if (multivaluedValue != null) {
        multivalued(multivaluedValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Field#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link Field#getKey() key} attribute.
     * @param key The value for key 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder key(String key) {
      this.key = Objects.requireNonNull(key, "key");
      initBits &= ~INIT_BIT_KEY;
      return this;
    }

    /**
     * Initializes the value for the {@link Field#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder type(String type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link Field#getKind() kind} attribute.
     * @param kind The value for kind (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder kind(@Nullable FieldKind kind) {
      this.kind = kind;
      return this;
    }

    /**
     * Initializes the value for the {@link Field#getDescription() description} attribute.
     * @param description The value for description (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder description(@Nullable String description) {
      this.description = description;
      return this;
    }

    /**
     * Initializes the value for the {@link Field#isMultivalued() multivalued} attribute.
     * @param multivalued The value for multivalued (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder multivalued(@Nullable Boolean multivalued) {
      this.multivalued = multivalued;
      return this;
    }

    /**
     * Builds a new {@link ImmutableField ImmutableField}.
     * @return An immutable instance of Field
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableField build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableField(name, key, type, kind, description, multivalued);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_KEY) != 0) attributes.add("key");
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      return "Cannot build Field, some of required attributes are not set " + attributes;
    }
  }
}
