package zeenea.connector.aws.dynamodb.client;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/**
 * Immutable implementation of {@link Dataset}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDataset.builder()}.
 */
@Generated(from = "Dataset", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableDataset implements Dataset {
  @NotNull
  private final ItemRef reference;
  private final @Nullable String description;
  @NotNull
  private final List<Field> fields;
  @NotNull
  private final List<String> primaryKeys;
  private final @Nullable Instant createdAt;
  private final @Nullable String arn;
  private final @Nullable Long itemsCount;
  private final @Nullable Long size;

  private ImmutableDataset(
      ItemRef reference,
      @Nullable String description,
      List<Field> fields,
      List<String> primaryKeys,
      @Nullable Instant createdAt,
      @Nullable String arn,
      @Nullable Long itemsCount,
      @Nullable Long size) {
    this.reference = reference;
    this.description = description;
    this.fields = fields;
    this.primaryKeys = primaryKeys;
    this.createdAt = createdAt;
    this.arn = arn;
    this.itemsCount = itemsCount;
    this.size = size;
  }

  /**
   * @return The value of the {@code reference} attribute
   */
  @NotNull
  @Override
  public ItemRef getReference() {
    return reference;
  }

  /**
   * @return The value of the {@code description} attribute
   */
  @Override
  public @Nullable String getDescription() {
    return description;
  }

  /**
   * @return The value of the {@code fields} attribute
   */
  @NotNull
  @Override
  public List<Field> getFields() {
    return fields;
  }

  /**
   * @return The value of the {@code primaryKeys} attribute
   */
  @NotNull
  @Override
  public List<String> getPrimaryKeys() {
    return primaryKeys;
  }

  /**
   * @return The value of the {@code createdAt} attribute
   */
  @Override
  public @Nullable Instant getCreatedAt() {
    return createdAt;
  }

  /**
   * @return The value of the {@code arn} attribute
   */
  @Override
  public @Nullable String getArn() {
    return arn;
  }

  /**
   * @return The value of the {@code itemsCount} attribute
   */
  @Override
  public @Nullable Long getItemsCount() {
    return itemsCount;
  }

  /**
   * @return The value of the {@code size} attribute
   */
  @Override
  public @Nullable Long getSize() {
    return size;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Dataset#getReference() reference} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for reference
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDataset withReference(ItemRef value) {
    if (this.reference == value) return this;
    ItemRef newValue = Objects.requireNonNull(value, "reference");
    return new ImmutableDataset(
        newValue,
        this.description,
        this.fields,
        this.primaryKeys,
        this.createdAt,
        this.arn,
        this.itemsCount,
        this.size);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Dataset#getDescription() description} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for description (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDataset withDescription(@Nullable String value) {
    if (Objects.equals(this.description, value)) return this;
    return new ImmutableDataset(
        this.reference,
        value,
        this.fields,
        this.primaryKeys,
        this.createdAt,
        this.arn,
        this.itemsCount,
        this.size);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Dataset#getFields() fields}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDataset withFields(Field... elements) {
    List<Field> newValue = List.of(elements);
    return new ImmutableDataset(
        this.reference,
        this.description,
        newValue,
        this.primaryKeys,
        this.createdAt,
        this.arn,
        this.itemsCount,
        this.size);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Dataset#getFields() fields}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of fields elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDataset withFields(Iterable<? extends Field> elements) {
    if (this.fields == elements) return this;
    List<Field> newValue = elements instanceof Collection<?>
        ? List.copyOf((Collection<? extends Field>) elements)
        : StreamSupport.stream(elements.spliterator(), false)
            .collect(Collectors.toUnmodifiableList());
    return new ImmutableDataset(
        this.reference,
        this.description,
        newValue,
        this.primaryKeys,
        this.createdAt,
        this.arn,
        this.itemsCount,
        this.size);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Dataset#getPrimaryKeys() primaryKeys}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDataset withPrimaryKeys(String... elements) {
    List<String> newValue = List.of(elements);
    return new ImmutableDataset(
        this.reference,
        this.description,
        this.fields,
        newValue,
        this.createdAt,
        this.arn,
        this.itemsCount,
        this.size);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Dataset#getPrimaryKeys() primaryKeys}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of primaryKeys elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDataset withPrimaryKeys(Iterable<String> elements) {
    if (this.primaryKeys == elements) return this;
    List<String> newValue = elements instanceof Collection<?>
        ? List.copyOf((Collection<String>) elements)
        : StreamSupport.stream(elements.spliterator(), false)
            .collect(Collectors.toUnmodifiableList());
    return new ImmutableDataset(
        this.reference,
        this.description,
        this.fields,
        newValue,
        this.createdAt,
        this.arn,
        this.itemsCount,
        this.size);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Dataset#getCreatedAt() createdAt} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for createdAt (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDataset withCreatedAt(@Nullable Instant value) {
    if (this.createdAt == value) return this;
    return new ImmutableDataset(
        this.reference,
        this.description,
        this.fields,
        this.primaryKeys,
        value,
        this.arn,
        this.itemsCount,
        this.size);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Dataset#getArn() arn} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for arn (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDataset withArn(@Nullable String value) {
    if (Objects.equals(this.arn, value)) return this;
    return new ImmutableDataset(
        this.reference,
        this.description,
        this.fields,
        this.primaryKeys,
        this.createdAt,
        value,
        this.itemsCount,
        this.size);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Dataset#getItemsCount() itemsCount} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for itemsCount (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDataset withItemsCount(@Nullable Long value) {
    if (Objects.equals(this.itemsCount, value)) return this;
    return new ImmutableDataset(
        this.reference,
        this.description,
        this.fields,
        this.primaryKeys,
        this.createdAt,
        this.arn,
        value,
        this.size);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Dataset#getSize() size} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for size (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDataset withSize(@Nullable Long value) {
    if (Objects.equals(this.size, value)) return this;
    return new ImmutableDataset(
        this.reference,
        this.description,
        this.fields,
        this.primaryKeys,
        this.createdAt,
        this.arn,
        this.itemsCount,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDataset} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDataset
        && equalTo(0, (ImmutableDataset) another);
  }

  private boolean equalTo(int synthetic, ImmutableDataset another) {
    return reference.equals(another.reference)
        && Objects.equals(description, another.description)
        && fields.equals(another.fields)
        && primaryKeys.equals(another.primaryKeys)
        && Objects.equals(createdAt, another.createdAt)
        && Objects.equals(arn, another.arn)
        && Objects.equals(itemsCount, another.itemsCount)
        && Objects.equals(size, another.size);
  }

  /**
   * Computes a hash code from attributes: {@code reference}, {@code description}, {@code fields}, {@code primaryKeys}, {@code createdAt}, {@code arn}, {@code itemsCount}, {@code size}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + reference.hashCode();
    h += (h << 5) + Objects.hashCode(description);
    h += (h << 5) + fields.hashCode();
    h += (h << 5) + primaryKeys.hashCode();
    h += (h << 5) + Objects.hashCode(createdAt);
    h += (h << 5) + Objects.hashCode(arn);
    h += (h << 5) + Objects.hashCode(itemsCount);
    h += (h << 5) + Objects.hashCode(size);
    return h;
  }

  /**
   * Prints the immutable value {@code Dataset} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Dataset{"
        + "reference=" + reference
        + ", description=" + description
        + ", fields=" + fields
        + ", primaryKeys=" + primaryKeys
        + ", createdAt=" + createdAt
        + ", arn=" + arn
        + ", itemsCount=" + itemsCount
        + ", size=" + size
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link Dataset} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Dataset instance
   */
  public static ImmutableDataset copyOf(Dataset instance) {
    if (instance instanceof ImmutableDataset) {
      return (ImmutableDataset) instance;
    }
    return ImmutableDataset.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDataset ImmutableDataset}.
   * <pre>
   * ImmutableDataset.builder()
   *    .reference(zeenea.connector.aws.dynamodb.client.ItemRef) // required {@link Dataset#getReference() reference}
   *    .description(String | null) // nullable {@link Dataset#getDescription() description}
   *    .addFields|addAllFields(zeenea.connector.aws.dynamodb.client.Field) // {@link Dataset#getFields() fields} elements
   *    .addPrimaryKeys|addAllPrimaryKeys(String) // {@link Dataset#getPrimaryKeys() primaryKeys} elements
   *    .createdAt(java.time.Instant | null) // nullable {@link Dataset#getCreatedAt() createdAt}
   *    .arn(String | null) // nullable {@link Dataset#getArn() arn}
   *    .itemsCount(Long | null) // nullable {@link Dataset#getItemsCount() itemsCount}
   *    .size(Long | null) // nullable {@link Dataset#getSize() size}
   *    .build();
   * </pre>
   * @return A new ImmutableDataset builder
   */
  public static ImmutableDataset.Builder builder() {
    return new ImmutableDataset.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDataset ImmutableDataset}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Dataset", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_REFERENCE = 0x1L;
    private long initBits = 0x1L;

    private @javax.annotation.Nullable ItemRef reference;
    private @javax.annotation.Nullable String description;
    private List<Field> fields = new ArrayList<Field>();
    private List<String> primaryKeys = new ArrayList<String>();
    private @javax.annotation.Nullable Instant createdAt;
    private @javax.annotation.Nullable String arn;
    private @javax.annotation.Nullable Long itemsCount;
    private @javax.annotation.Nullable Long size;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Dataset} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Dataset instance) {
      Objects.requireNonNull(instance, "instance");
      this.reference(instance.getReference());
      @Nullable String descriptionValue = instance.getDescription();
      if (descriptionValue != null) {
        description(descriptionValue);
      }
      addAllFields(instance.getFields());
      addAllPrimaryKeys(instance.getPrimaryKeys());
      @Nullable Instant createdAtValue = instance.getCreatedAt();
      if (createdAtValue != null) {
        createdAt(createdAtValue);
      }
      @Nullable String arnValue = instance.getArn();
      if (arnValue != null) {
        arn(arnValue);
      }
      @Nullable Long itemsCountValue = instance.getItemsCount();
      if (itemsCountValue != null) {
        itemsCount(itemsCountValue);
      }
      @Nullable Long sizeValue = instance.getSize();
      if (sizeValue != null) {
        size(sizeValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Dataset#getReference() reference} attribute.
     * @param reference The value for reference 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder reference(ItemRef reference) {
      this.reference = Objects.requireNonNull(reference, "reference");
      initBits &= ~INIT_BIT_REFERENCE;
      return this;
    }

    /**
     * Initializes the value for the {@link Dataset#getDescription() description} attribute.
     * @param description The value for description (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder description(@Nullable String description) {
      this.description = description;
      return this;
    }

    /**
     * Adds one element to {@link Dataset#getFields() fields} list.
     * @param element A fields element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addFields(Field element) {
      this.fields.add(Objects.requireNonNull(element, "fields element"));
      return this;
    }

    /**
     * Adds elements to {@link Dataset#getFields() fields} list.
     * @param elements An array of fields elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addFields(Field... elements) {
      for (Field element : elements) {
        this.fields.add(Objects.requireNonNull(element, "fields element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Dataset#getFields() fields} list.
     * @param elements An iterable of fields elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder fields(Iterable<? extends Field> elements) {
      this.fields.clear();
      return addAllFields(elements);
    }

    /**
     * Adds elements to {@link Dataset#getFields() fields} list.
     * @param elements An iterable of fields elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllFields(Iterable<? extends Field> elements) {
      for (Field element : elements) {
        this.fields.add(Objects.requireNonNull(element, "fields element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link Dataset#getPrimaryKeys() primaryKeys} list.
     * @param element A primaryKeys element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addPrimaryKeys(String element) {
      this.primaryKeys.add(Objects.requireNonNull(element, "primaryKeys element"));
      return this;
    }

    /**
     * Adds elements to {@link Dataset#getPrimaryKeys() primaryKeys} list.
     * @param elements An array of primaryKeys elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addPrimaryKeys(String... elements) {
      for (String element : elements) {
        this.primaryKeys.add(Objects.requireNonNull(element, "primaryKeys element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Dataset#getPrimaryKeys() primaryKeys} list.
     * @param elements An iterable of primaryKeys elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder primaryKeys(Iterable<String> elements) {
      this.primaryKeys.clear();
      return addAllPrimaryKeys(elements);
    }

    /**
     * Adds elements to {@link Dataset#getPrimaryKeys() primaryKeys} list.
     * @param elements An iterable of primaryKeys elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllPrimaryKeys(Iterable<String> elements) {
      for (String element : elements) {
        this.primaryKeys.add(Objects.requireNonNull(element, "primaryKeys element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Dataset#getCreatedAt() createdAt} attribute.
     * @param createdAt The value for createdAt (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder createdAt(@Nullable Instant createdAt) {
      this.createdAt = createdAt;
      return this;
    }

    /**
     * Initializes the value for the {@link Dataset#getArn() arn} attribute.
     * @param arn The value for arn (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder arn(@Nullable String arn) {
      this.arn = arn;
      return this;
    }

    /**
     * Initializes the value for the {@link Dataset#getItemsCount() itemsCount} attribute.
     * @param itemsCount The value for itemsCount (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder itemsCount(@Nullable Long itemsCount) {
      this.itemsCount = itemsCount;
      return this;
    }

    /**
     * Initializes the value for the {@link Dataset#getSize() size} attribute.
     * @param size The value for size (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder size(@Nullable Long size) {
      this.size = size;
      return this;
    }

    /**
     * Builds a new {@link ImmutableDataset ImmutableDataset}.
     * @return An immutable instance of Dataset
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDataset build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableDataset(
          reference,
          description,
          List.copyOf(fields),
          List.copyOf(primaryKeys),
          createdAt,
          arn,
          itemsCount,
          size);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_REFERENCE) != 0) attributes.add("reference");
      return "Cannot build Dataset, some of required attributes are not set " + attributes;
    }
  }
}
