package zeenea.connector.aws.athena.client;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.NotNull;

/**
 * Immutable implementation of {@link ItemRef}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableItemRef.builder()}.
 */
@Generated(from = "ItemRef", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableItemRef implements ItemRef {
  @NotNull
  private final String awsRegion;
  @NotNull
  private final String catalogName;
  @NotNull
  private final String databaseName;
  @NotNull
  private final String tableName;

  private ImmutableItemRef(
      String awsRegion,
      String catalogName,
      String databaseName,
      String tableName) {
    this.awsRegion = awsRegion;
    this.catalogName = catalogName;
    this.databaseName = databaseName;
    this.tableName = tableName;
  }

  /**
   * @return The value of the {@code awsRegion} attribute
   */
  @NotNull
  @Override
  public String getAwsRegion() {
    return awsRegion;
  }

  /**
   * @return The value of the {@code catalogName} attribute
   */
  @NotNull
  @Override
  public String getCatalogName() {
    return catalogName;
  }

  /**
   * @return The value of the {@code databaseName} attribute
   */
  @NotNull
  @Override
  public String getDatabaseName() {
    return databaseName;
  }

  /**
   * @return The value of the {@code tableName} attribute
   */
  @NotNull
  @Override
  public String getTableName() {
    return tableName;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ItemRef#getAwsRegion() awsRegion} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for awsRegion
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableItemRef withAwsRegion(String value) {
    String newValue = Objects.requireNonNull(value, "awsRegion");
    if (this.awsRegion.equals(newValue)) return this;
    return new ImmutableItemRef(newValue, this.catalogName, this.databaseName, this.tableName);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ItemRef#getCatalogName() catalogName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for catalogName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableItemRef withCatalogName(String value) {
    String newValue = Objects.requireNonNull(value, "catalogName");
    if (this.catalogName.equals(newValue)) return this;
    return new ImmutableItemRef(this.awsRegion, newValue, this.databaseName, this.tableName);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ItemRef#getDatabaseName() databaseName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for databaseName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableItemRef withDatabaseName(String value) {
    String newValue = Objects.requireNonNull(value, "databaseName");
    if (this.databaseName.equals(newValue)) return this;
    return new ImmutableItemRef(this.awsRegion, this.catalogName, newValue, this.tableName);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ItemRef#getTableName() tableName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tableName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableItemRef withTableName(String value) {
    String newValue = Objects.requireNonNull(value, "tableName");
    if (this.tableName.equals(newValue)) return this;
    return new ImmutableItemRef(this.awsRegion, this.catalogName, this.databaseName, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableItemRef} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableItemRef
        && equalTo(0, (ImmutableItemRef) another);
  }

  private boolean equalTo(int synthetic, ImmutableItemRef another) {
    return awsRegion.equals(another.awsRegion)
        && catalogName.equals(another.catalogName)
        && databaseName.equals(another.databaseName)
        && tableName.equals(another.tableName);
  }

  /**
   * Computes a hash code from attributes: {@code awsRegion}, {@code catalogName}, {@code databaseName}, {@code tableName}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + awsRegion.hashCode();
    h += (h << 5) + catalogName.hashCode();
    h += (h << 5) + databaseName.hashCode();
    h += (h << 5) + tableName.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ItemRef} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ItemRef{"
        + "awsRegion=" + awsRegion
        + ", catalogName=" + catalogName
        + ", databaseName=" + databaseName
        + ", tableName=" + tableName
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link ItemRef} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ItemRef instance
   */
  public static ImmutableItemRef copyOf(ItemRef instance) {
    if (instance instanceof ImmutableItemRef) {
      return (ImmutableItemRef) instance;
    }
    return ImmutableItemRef.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableItemRef ImmutableItemRef}.
   * <pre>
   * ImmutableItemRef.builder()
   *    .awsRegion(String) // required {@link ItemRef#getAwsRegion() awsRegion}
   *    .catalogName(String) // required {@link ItemRef#getCatalogName() catalogName}
   *    .databaseName(String) // required {@link ItemRef#getDatabaseName() databaseName}
   *    .tableName(String) // required {@link ItemRef#getTableName() tableName}
   *    .build();
   * </pre>
   * @return A new ImmutableItemRef builder
   */
  public static ImmutableItemRef.Builder builder() {
    return new ImmutableItemRef.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableItemRef ImmutableItemRef}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ItemRef", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_AWS_REGION = 0x1L;
    private static final long INIT_BIT_CATALOG_NAME = 0x2L;
    private static final long INIT_BIT_DATABASE_NAME = 0x4L;
    private static final long INIT_BIT_TABLE_NAME = 0x8L;
    private long initBits = 0xfL;

    private @Nullable String awsRegion;
    private @Nullable String catalogName;
    private @Nullable String databaseName;
    private @Nullable String tableName;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ItemRef} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ItemRef instance) {
      Objects.requireNonNull(instance, "instance");
      this.awsRegion(instance.getAwsRegion());
      this.catalogName(instance.getCatalogName());
      this.databaseName(instance.getDatabaseName());
      this.tableName(instance.getTableName());
      return this;
    }

    /**
     * Initializes the value for the {@link ItemRef#getAwsRegion() awsRegion} attribute.
     * @param awsRegion The value for awsRegion 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder awsRegion(String awsRegion) {
      this.awsRegion = Objects.requireNonNull(awsRegion, "awsRegion");
      initBits &= ~INIT_BIT_AWS_REGION;
      return this;
    }

    /**
     * Initializes the value for the {@link ItemRef#getCatalogName() catalogName} attribute.
     * @param catalogName The value for catalogName 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder catalogName(String catalogName) {
      this.catalogName = Objects.requireNonNull(catalogName, "catalogName");
      initBits &= ~INIT_BIT_CATALOG_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link ItemRef#getDatabaseName() databaseName} attribute.
     * @param databaseName The value for databaseName 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder databaseName(String databaseName) {
      this.databaseName = Objects.requireNonNull(databaseName, "databaseName");
      initBits &= ~INIT_BIT_DATABASE_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link ItemRef#getTableName() tableName} attribute.
     * @param tableName The value for tableName 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder tableName(String tableName) {
      this.tableName = Objects.requireNonNull(tableName, "tableName");
      initBits &= ~INIT_BIT_TABLE_NAME;
      return this;
    }

    /**
     * Builds a new {@link ImmutableItemRef ImmutableItemRef}.
     * @return An immutable instance of ItemRef
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableItemRef build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableItemRef(awsRegion, catalogName, databaseName, tableName);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_AWS_REGION) != 0) attributes.add("awsRegion");
      if ((initBits & INIT_BIT_CATALOG_NAME) != 0) attributes.add("catalogName");
      if ((initBits & INIT_BIT_DATABASE_NAME) != 0) attributes.add("databaseName");
      if ((initBits & INIT_BIT_TABLE_NAME) != 0) attributes.add("tableName");
      return "Cannot build ItemRef, some of required attributes are not set " + attributes;
    }
  }
}
