package zeenea.connector.aws.athena.client;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awssdk.services.athena.model.Column;

/**
 * Immutable implementation of {@link AthenaTable}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableAthenaTable.builder()}.
 */
@Generated(from = "AthenaTable", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableAthenaTable implements AthenaTable {
  @NotNull
  private final ItemRef reference;
  private final @Nullable String description;
  @NotNull
  private final List<Column> fields;
  private final @Nullable String tableType;
  private final @Nullable String format;
  private final @Nullable Instant createTime;
  private final @Nullable String location;
  private final @Nullable String partitions;

  private ImmutableAthenaTable(
      ItemRef reference,
      @Nullable String description,
      List<Column> fields,
      @Nullable String tableType,
      @Nullable String format,
      @Nullable Instant createTime,
      @Nullable String location,
      @Nullable String partitions) {
    this.reference = reference;
    this.description = description;
    this.fields = fields;
    this.tableType = tableType;
    this.format = format;
    this.createTime = createTime;
    this.location = location;
    this.partitions = partitions;
  }

  /**
   * @return The value of the {@code reference} attribute
   */
  @NotNull
  @Override
  public ItemRef getReference() {
    return reference;
  }

  /**
   * @return The value of the {@code description} attribute
   */
  @Override
  public @Nullable String getDescription() {
    return description;
  }

  /**
   * @return The value of the {@code fields} attribute
   */
  @NotNull
  @Override
  public List<Column> getFields() {
    return fields;
  }

  /**
   * @return The value of the {@code tableType} attribute
   */
  @Override
  public @Nullable String getTableType() {
    return tableType;
  }

  /**
   * @return The value of the {@code format} attribute
   */
  @Override
  public @Nullable String getFormat() {
    return format;
  }

  /**
   * @return The value of the {@code createTime} attribute
   */
  @Override
  public @Nullable Instant getCreateTime() {
    return createTime;
  }

  /**
   * @return The value of the {@code location} attribute
   */
  @Override
  public @Nullable String getLocation() {
    return location;
  }

  /**
   * @return The value of the {@code partitions} attribute
   */
  @Override
  public @Nullable String getPartitions() {
    return partitions;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AthenaTable#getReference() reference} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for reference
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAthenaTable withReference(ItemRef value) {
    if (this.reference == value) return this;
    ItemRef newValue = Objects.requireNonNull(value, "reference");
    return new ImmutableAthenaTable(
        newValue,
        this.description,
        this.fields,
        this.tableType,
        this.format,
        this.createTime,
        this.location,
        this.partitions);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AthenaTable#getDescription() description} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for description (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAthenaTable withDescription(@Nullable String value) {
    if (Objects.equals(this.description, value)) return this;
    return new ImmutableAthenaTable(
        this.reference,
        value,
        this.fields,
        this.tableType,
        this.format,
        this.createTime,
        this.location,
        this.partitions);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AthenaTable#getFields() fields}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAthenaTable withFields(Column... elements) {
    List<Column> newValue = List.of(elements);
    return new ImmutableAthenaTable(
        this.reference,
        this.description,
        newValue,
        this.tableType,
        this.format,
        this.createTime,
        this.location,
        this.partitions);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AthenaTable#getFields() fields}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of fields elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAthenaTable withFields(Iterable<? extends Column> elements) {
    if (this.fields == elements) return this;
    List<Column> newValue = elements instanceof Collection<?>
        ? List.copyOf((Collection<? extends Column>) elements)
        : StreamSupport.stream(elements.spliterator(), false)
            .collect(Collectors.toUnmodifiableList());
    return new ImmutableAthenaTable(
        this.reference,
        this.description,
        newValue,
        this.tableType,
        this.format,
        this.createTime,
        this.location,
        this.partitions);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AthenaTable#getTableType() tableType} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tableType (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAthenaTable withTableType(@Nullable String value) {
    if (Objects.equals(this.tableType, value)) return this;
    return new ImmutableAthenaTable(
        this.reference,
        this.description,
        this.fields,
        value,
        this.format,
        this.createTime,
        this.location,
        this.partitions);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AthenaTable#getFormat() format} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for format (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAthenaTable withFormat(@Nullable String value) {
    if (Objects.equals(this.format, value)) return this;
    return new ImmutableAthenaTable(
        this.reference,
        this.description,
        this.fields,
        this.tableType,
        value,
        this.createTime,
        this.location,
        this.partitions);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AthenaTable#getCreateTime() createTime} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for createTime (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAthenaTable withCreateTime(@Nullable Instant value) {
    if (this.createTime == value) return this;
    return new ImmutableAthenaTable(
        this.reference,
        this.description,
        this.fields,
        this.tableType,
        this.format,
        value,
        this.location,
        this.partitions);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AthenaTable#getLocation() location} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for location (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAthenaTable withLocation(@Nullable String value) {
    if (Objects.equals(this.location, value)) return this;
    return new ImmutableAthenaTable(
        this.reference,
        this.description,
        this.fields,
        this.tableType,
        this.format,
        this.createTime,
        value,
        this.partitions);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AthenaTable#getPartitions() partitions} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for partitions (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAthenaTable withPartitions(@Nullable String value) {
    if (Objects.equals(this.partitions, value)) return this;
    return new ImmutableAthenaTable(
        this.reference,
        this.description,
        this.fields,
        this.tableType,
        this.format,
        this.createTime,
        this.location,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableAthenaTable} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableAthenaTable
        && equalTo(0, (ImmutableAthenaTable) another);
  }

  private boolean equalTo(int synthetic, ImmutableAthenaTable another) {
    return reference.equals(another.reference)
        && Objects.equals(description, another.description)
        && fields.equals(another.fields)
        && Objects.equals(tableType, another.tableType)
        && Objects.equals(format, another.format)
        && Objects.equals(createTime, another.createTime)
        && Objects.equals(location, another.location)
        && Objects.equals(partitions, another.partitions);
  }

  /**
   * Computes a hash code from attributes: {@code reference}, {@code description}, {@code fields}, {@code tableType}, {@code format}, {@code createTime}, {@code location}, {@code partitions}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + reference.hashCode();
    h += (h << 5) + Objects.hashCode(description);
    h += (h << 5) + fields.hashCode();
    h += (h << 5) + Objects.hashCode(tableType);
    h += (h << 5) + Objects.hashCode(format);
    h += (h << 5) + Objects.hashCode(createTime);
    h += (h << 5) + Objects.hashCode(location);
    h += (h << 5) + Objects.hashCode(partitions);
    return h;
  }

  /**
   * Prints the immutable value {@code AthenaTable} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "AthenaTable{"
        + "reference=" + reference
        + ", description=" + description
        + ", fields=" + fields
        + ", tableType=" + tableType
        + ", format=" + format
        + ", createTime=" + createTime
        + ", location=" + location
        + ", partitions=" + partitions
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link AthenaTable} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable AthenaTable instance
   */
  public static ImmutableAthenaTable copyOf(AthenaTable instance) {
    if (instance instanceof ImmutableAthenaTable) {
      return (ImmutableAthenaTable) instance;
    }
    return ImmutableAthenaTable.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableAthenaTable ImmutableAthenaTable}.
   * <pre>
   * ImmutableAthenaTable.builder()
   *    .reference(zeenea.connector.aws.athena.client.ItemRef) // required {@link AthenaTable#getReference() reference}
   *    .description(String | null) // nullable {@link AthenaTable#getDescription() description}
   *    .addFields|addAllFields(software.amazon.awssdk.services.athena.model.Column) // {@link AthenaTable#getFields() fields} elements
   *    .tableType(String | null) // nullable {@link AthenaTable#getTableType() tableType}
   *    .format(String | null) // nullable {@link AthenaTable#getFormat() format}
   *    .createTime(java.time.Instant | null) // nullable {@link AthenaTable#getCreateTime() createTime}
   *    .location(String | null) // nullable {@link AthenaTable#getLocation() location}
   *    .partitions(String | null) // nullable {@link AthenaTable#getPartitions() partitions}
   *    .build();
   * </pre>
   * @return A new ImmutableAthenaTable builder
   */
  public static ImmutableAthenaTable.Builder builder() {
    return new ImmutableAthenaTable.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableAthenaTable ImmutableAthenaTable}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "AthenaTable", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_REFERENCE = 0x1L;
    private long initBits = 0x1L;

    private @javax.annotation.Nullable ItemRef reference;
    private @javax.annotation.Nullable String description;
    private List<Column> fields = new ArrayList<Column>();
    private @javax.annotation.Nullable String tableType;
    private @javax.annotation.Nullable String format;
    private @javax.annotation.Nullable Instant createTime;
    private @javax.annotation.Nullable String location;
    private @javax.annotation.Nullable String partitions;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code AthenaTable} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(AthenaTable instance) {
      Objects.requireNonNull(instance, "instance");
      this.reference(instance.getReference());
      @Nullable String descriptionValue = instance.getDescription();
      if (descriptionValue != null) {
        description(descriptionValue);
      }
      addAllFields(instance.getFields());
      @Nullable String tableTypeValue = instance.getTableType();
      if (tableTypeValue != null) {
        tableType(tableTypeValue);
      }
      @Nullable String formatValue = instance.getFormat();
      if (formatValue != null) {
        format(formatValue);
      }
      @Nullable Instant createTimeValue = instance.getCreateTime();
      if (createTimeValue != null) {
        createTime(createTimeValue);
      }
      @Nullable String locationValue = instance.getLocation();
      if (locationValue != null) {
        location(locationValue);
      }
      @Nullable String partitionsValue = instance.getPartitions();
      if (partitionsValue != null) {
        partitions(partitionsValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link AthenaTable#getReference() reference} attribute.
     * @param reference The value for reference 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder reference(ItemRef reference) {
      this.reference = Objects.requireNonNull(reference, "reference");
      initBits &= ~INIT_BIT_REFERENCE;
      return this;
    }

    /**
     * Initializes the value for the {@link AthenaTable#getDescription() description} attribute.
     * @param description The value for description (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder description(@Nullable String description) {
      this.description = description;
      return this;
    }

    /**
     * Adds one element to {@link AthenaTable#getFields() fields} list.
     * @param element A fields element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addFields(Column element) {
      this.fields.add(Objects.requireNonNull(element, "fields element"));
      return this;
    }

    /**
     * Adds elements to {@link AthenaTable#getFields() fields} list.
     * @param elements An array of fields elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addFields(Column... elements) {
      for (Column element : elements) {
        this.fields.add(Objects.requireNonNull(element, "fields element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link AthenaTable#getFields() fields} list.
     * @param elements An iterable of fields elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder fields(Iterable<? extends Column> elements) {
      this.fields.clear();
      return addAllFields(elements);
    }

    /**
     * Adds elements to {@link AthenaTable#getFields() fields} list.
     * @param elements An iterable of fields elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllFields(Iterable<? extends Column> elements) {
      for (Column element : elements) {
        this.fields.add(Objects.requireNonNull(element, "fields element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link AthenaTable#getTableType() tableType} attribute.
     * @param tableType The value for tableType (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder tableType(@Nullable String tableType) {
      this.tableType = tableType;
      return this;
    }

    /**
     * Initializes the value for the {@link AthenaTable#getFormat() format} attribute.
     * @param format The value for format (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder format(@Nullable String format) {
      this.format = format;
      return this;
    }

    /**
     * Initializes the value for the {@link AthenaTable#getCreateTime() createTime} attribute.
     * @param createTime The value for createTime (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder createTime(@Nullable Instant createTime) {
      this.createTime = createTime;
      return this;
    }

    /**
     * Initializes the value for the {@link AthenaTable#getLocation() location} attribute.
     * @param location The value for location (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder location(@Nullable String location) {
      this.location = location;
      return this;
    }

    /**
     * Initializes the value for the {@link AthenaTable#getPartitions() partitions} attribute.
     * @param partitions The value for partitions (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder partitions(@Nullable String partitions) {
      this.partitions = partitions;
      return this;
    }

    /**
     * Builds a new {@link ImmutableAthenaTable ImmutableAthenaTable}.
     * @return An immutable instance of AthenaTable
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableAthenaTable build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableAthenaTable(
          reference,
          description,
          List.copyOf(fields),
          tableType,
          format,
          createTime,
          location,
          partitions);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_REFERENCE) != 0) attributes.add("reference");
      return "Cannot build AthenaTable, some of required attributes are not set " + attributes;
    }
  }
}
