package zeenea.connector.aws.athena.client;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.NotNull;

/**
 * Immutable implementation of {@link AthenaDatabase}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableAthenaDatabase.builder()}.
 */
@Generated(from = "AthenaDatabase", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableAthenaDatabase implements AthenaDatabase {
  @NotNull
  private final String catalog;
  @NotNull
  private final String database;

  private ImmutableAthenaDatabase(String catalog, String database) {
    this.catalog = catalog;
    this.database = database;
  }

  /**
   * @return The value of the {@code catalog} attribute
   */
  @NotNull
  @Override
  public String getCatalog() {
    return catalog;
  }

  /**
   * @return The value of the {@code database} attribute
   */
  @NotNull
  @Override
  public String getDatabase() {
    return database;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AthenaDatabase#getCatalog() catalog} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for catalog
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAthenaDatabase withCatalog(String value) {
    String newValue = Objects.requireNonNull(value, "catalog");
    if (this.catalog.equals(newValue)) return this;
    return new ImmutableAthenaDatabase(newValue, this.database);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AthenaDatabase#getDatabase() database} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for database
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAthenaDatabase withDatabase(String value) {
    String newValue = Objects.requireNonNull(value, "database");
    if (this.database.equals(newValue)) return this;
    return new ImmutableAthenaDatabase(this.catalog, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableAthenaDatabase} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableAthenaDatabase
        && equalTo(0, (ImmutableAthenaDatabase) another);
  }

  private boolean equalTo(int synthetic, ImmutableAthenaDatabase another) {
    return catalog.equals(another.catalog)
        && database.equals(another.database);
  }

  /**
   * Computes a hash code from attributes: {@code catalog}, {@code database}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + catalog.hashCode();
    h += (h << 5) + database.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code AthenaDatabase} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "AthenaDatabase{"
        + "catalog=" + catalog
        + ", database=" + database
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link AthenaDatabase} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable AthenaDatabase instance
   */
  public static ImmutableAthenaDatabase copyOf(AthenaDatabase instance) {
    if (instance instanceof ImmutableAthenaDatabase) {
      return (ImmutableAthenaDatabase) instance;
    }
    return ImmutableAthenaDatabase.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableAthenaDatabase ImmutableAthenaDatabase}.
   * <pre>
   * ImmutableAthenaDatabase.builder()
   *    .catalog(String) // required {@link AthenaDatabase#getCatalog() catalog}
   *    .database(String) // required {@link AthenaDatabase#getDatabase() database}
   *    .build();
   * </pre>
   * @return A new ImmutableAthenaDatabase builder
   */
  public static ImmutableAthenaDatabase.Builder builder() {
    return new ImmutableAthenaDatabase.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableAthenaDatabase ImmutableAthenaDatabase}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "AthenaDatabase", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_CATALOG = 0x1L;
    private static final long INIT_BIT_DATABASE = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String catalog;
    private @Nullable String database;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code AthenaDatabase} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(AthenaDatabase instance) {
      Objects.requireNonNull(instance, "instance");
      this.catalog(instance.getCatalog());
      this.database(instance.getDatabase());
      return this;
    }

    /**
     * Initializes the value for the {@link AthenaDatabase#getCatalog() catalog} attribute.
     * @param catalog The value for catalog 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder catalog(String catalog) {
      this.catalog = Objects.requireNonNull(catalog, "catalog");
      initBits &= ~INIT_BIT_CATALOG;
      return this;
    }

    /**
     * Initializes the value for the {@link AthenaDatabase#getDatabase() database} attribute.
     * @param database The value for database 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder database(String database) {
      this.database = Objects.requireNonNull(database, "database");
      initBits &= ~INIT_BIT_DATABASE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableAthenaDatabase ImmutableAthenaDatabase}.
     * @return An immutable instance of AthenaDatabase
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableAthenaDatabase build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableAthenaDatabase(catalog, database);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CATALOG) != 0) attributes.add("catalog");
      if ((initBits & INIT_BIT_DATABASE) != 0) attributes.add("database");
      return "Cannot build AthenaDatabase, some of required attributes are not set " + attributes;
    }
  }
}
