/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReadAPIKeyConnectionMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReadAPIKeyConnectionMetadata> {
    private static final SdkField<String> BASE_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BaseEndpoint").getter(ReadAPIKeyConnectionMetadata.getter(ReadAPIKeyConnectionMetadata::baseEndpoint)).setter(ReadAPIKeyConnectionMetadata.setter(Builder::baseEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaseEndpoint").build()}).build();
    private static final SdkField<String> EMAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Email").getter(ReadAPIKeyConnectionMetadata.getter(ReadAPIKeyConnectionMetadata::email)).setter(ReadAPIKeyConnectionMetadata.setter(Builder::email)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Email").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BASE_ENDPOINT_FIELD, EMAIL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ReadAPIKeyConnectionMetadata.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String baseEndpoint;
    private final String email;

    private ReadAPIKeyConnectionMetadata(BuilderImpl builder) {
        this.baseEndpoint = builder.baseEndpoint;
        this.email = builder.email;
    }

    public final String baseEndpoint() {
        return this.baseEndpoint;
    }

    public final String email() {
        return this.email;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.baseEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.email());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReadAPIKeyConnectionMetadata)) {
            return false;
        }
        ReadAPIKeyConnectionMetadata other = (ReadAPIKeyConnectionMetadata)obj;
        return Objects.equals(this.baseEndpoint(), other.baseEndpoint()) && Objects.equals(this.email(), other.email());
    }

    public final String toString() {
        return ToString.builder((String)"ReadAPIKeyConnectionMetadata").add("BaseEndpoint", (Object)this.baseEndpoint()).add("Email", (Object)(this.email() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BaseEndpoint": {
                return Optional.ofNullable(clazz.cast(this.baseEndpoint()));
            }
            case "Email": {
                return Optional.ofNullable(clazz.cast(this.email()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("BaseEndpoint", BASE_ENDPOINT_FIELD);
        map.put("Email", EMAIL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReadAPIKeyConnectionMetadata, T> g) {
        return obj -> g.apply((ReadAPIKeyConnectionMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String baseEndpoint;
        private String email;

        private BuilderImpl() {
        }

        private BuilderImpl(ReadAPIKeyConnectionMetadata model) {
            this.baseEndpoint(model.baseEndpoint);
            this.email(model.email);
        }

        public final String getBaseEndpoint() {
            return this.baseEndpoint;
        }

        public final void setBaseEndpoint(String baseEndpoint) {
            this.baseEndpoint = baseEndpoint;
        }

        @Override
        public final Builder baseEndpoint(String baseEndpoint) {
            this.baseEndpoint = baseEndpoint;
            return this;
        }

        public final String getEmail() {
            return this.email;
        }

        public final void setEmail(String email) {
            this.email = email;
        }

        @Override
        public final Builder email(String email) {
            this.email = email;
            return this;
        }

        public ReadAPIKeyConnectionMetadata build() {
            return new ReadAPIKeyConnectionMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReadAPIKeyConnectionMetadata> {
        public Builder baseEndpoint(String var1);

        public Builder email(String var1);
    }
}

