/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.FieldSortOptions;
import software.amazon.awssdk.services.quicksight.model.PluginVisualItemsLimitConfiguration;
import software.amazon.awssdk.services.quicksight.model.RowSortListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PluginVisualTableQuerySort
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PluginVisualTableQuerySort> {
    private static final SdkField<List<FieldSortOptions>> ROW_SORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RowSort").getter(PluginVisualTableQuerySort.getter(PluginVisualTableQuerySort::rowSort)).setter(PluginVisualTableQuerySort.setter(Builder::rowSort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RowSort").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FieldSortOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<PluginVisualItemsLimitConfiguration> ITEMS_LIMIT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ItemsLimitConfiguration").getter(PluginVisualTableQuerySort.getter(PluginVisualTableQuerySort::itemsLimitConfiguration)).setter(PluginVisualTableQuerySort.setter(Builder::itemsLimitConfiguration)).constructor(PluginVisualItemsLimitConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ItemsLimitConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROW_SORT_FIELD, ITEMS_LIMIT_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PluginVisualTableQuerySort.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<FieldSortOptions> rowSort;
    private final PluginVisualItemsLimitConfiguration itemsLimitConfiguration;

    private PluginVisualTableQuerySort(BuilderImpl builder) {
        this.rowSort = builder.rowSort;
        this.itemsLimitConfiguration = builder.itemsLimitConfiguration;
    }

    public final boolean hasRowSort() {
        return this.rowSort != null && !(this.rowSort instanceof SdkAutoConstructList);
    }

    public final List<FieldSortOptions> rowSort() {
        return this.rowSort;
    }

    public final PluginVisualItemsLimitConfiguration itemsLimitConfiguration() {
        return this.itemsLimitConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRowSort() ? this.rowSort() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.itemsLimitConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PluginVisualTableQuerySort)) {
            return false;
        }
        PluginVisualTableQuerySort other = (PluginVisualTableQuerySort)obj;
        return this.hasRowSort() == other.hasRowSort() && Objects.equals(this.rowSort(), other.rowSort()) && Objects.equals(this.itemsLimitConfiguration(), other.itemsLimitConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"PluginVisualTableQuerySort").add("RowSort", this.hasRowSort() ? this.rowSort() : null).add("ItemsLimitConfiguration", (Object)this.itemsLimitConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RowSort": {
                return Optional.ofNullable(clazz.cast(this.rowSort()));
            }
            case "ItemsLimitConfiguration": {
                return Optional.ofNullable(clazz.cast(this.itemsLimitConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RowSort", ROW_SORT_FIELD);
        map.put("ItemsLimitConfiguration", ITEMS_LIMIT_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PluginVisualTableQuerySort, T> g) {
        return obj -> g.apply((PluginVisualTableQuerySort)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<FieldSortOptions> rowSort = DefaultSdkAutoConstructList.getInstance();
        private PluginVisualItemsLimitConfiguration itemsLimitConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(PluginVisualTableQuerySort model) {
            this.rowSort(model.rowSort);
            this.itemsLimitConfiguration(model.itemsLimitConfiguration);
        }

        public final List<FieldSortOptions.Builder> getRowSort() {
            List<FieldSortOptions.Builder> result = RowSortListCopier.copyToBuilder(this.rowSort);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRowSort(Collection<FieldSortOptions.BuilderImpl> rowSort) {
            this.rowSort = RowSortListCopier.copyFromBuilder(rowSort);
        }

        @Override
        public final Builder rowSort(Collection<FieldSortOptions> rowSort) {
            this.rowSort = RowSortListCopier.copy(rowSort);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rowSort(FieldSortOptions ... rowSort) {
            this.rowSort(Arrays.asList(rowSort));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rowSort(Consumer<FieldSortOptions.Builder> ... rowSort) {
            this.rowSort(Stream.of(rowSort).map(c -> (FieldSortOptions)((FieldSortOptions.Builder)FieldSortOptions.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final PluginVisualItemsLimitConfiguration.Builder getItemsLimitConfiguration() {
            return this.itemsLimitConfiguration != null ? this.itemsLimitConfiguration.toBuilder() : null;
        }

        public final void setItemsLimitConfiguration(PluginVisualItemsLimitConfiguration.BuilderImpl itemsLimitConfiguration) {
            this.itemsLimitConfiguration = itemsLimitConfiguration != null ? itemsLimitConfiguration.build() : null;
        }

        @Override
        public final Builder itemsLimitConfiguration(PluginVisualItemsLimitConfiguration itemsLimitConfiguration) {
            this.itemsLimitConfiguration = itemsLimitConfiguration;
            return this;
        }

        public PluginVisualTableQuerySort build() {
            return new PluginVisualTableQuerySort(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PluginVisualTableQuerySort> {
        public Builder rowSort(Collection<FieldSortOptions> var1);

        public Builder rowSort(FieldSortOptions ... var1);

        public Builder rowSort(Consumer<FieldSortOptions.Builder> ... var1);

        public Builder itemsLimitConfiguration(PluginVisualItemsLimitConfiguration var1);

        default public Builder itemsLimitConfiguration(Consumer<PluginVisualItemsLimitConfiguration.Builder> itemsLimitConfiguration) {
            return this.itemsLimitConfiguration((PluginVisualItemsLimitConfiguration)((PluginVisualItemsLimitConfiguration.Builder)PluginVisualItemsLimitConfiguration.builder().applyMutation(itemsLimitConfiguration)).build());
        }
    }
}

