/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.filesystem.local;

import java.io.InputStream;
import java.io.Serializable;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnce;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import zeenea.connector.filesystem.CloseableIterator;
import zeenea.connector.filesystem.CloseableIterator$;
import zeenea.connector.filesystem.DirectoryDescription;
import zeenea.connector.filesystem.FileDescription;
import zeenea.connector.filesystem.FilePath;
import zeenea.connector.filesystem.FilePath$;
import zeenea.connector.filesystem.FileSystemClient;
import zeenea.connector.filesystem.FileSystemFile;
import zeenea.connector.filesystem.FileSystemFileReader;
import zeenea.connector.filesystem.FileSystemItem;
import zeenea.connector.filesystem.ItemDescription;
import zeenea.connector.filesystem.local.LocalFileSystemClient$;
import zeenea.connector.filesystem.local.LocalFileSystemFileReader;
import zeenea.connector.property.StandardTechnicalMetadata$;
import zeenea.connector.source.PropertyValues;
import zeenea.connector.source.PropertyValues$;
import zeenea.connector.source.SourceStringPropertyValue$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005c\u0001B\b\u0011\u0001eA\u0001B\n\u0001\u0003\u0002\u0003\u0006Ia\n\u0005\u0006_\u0001!\t\u0001\r\u0005\bi\u0001\u0011\r\u0011\"\u00016\u0011\u0019q\u0004\u0001)A\u0005m!)q\b\u0001C!\u0001\")\u0001\f\u0001C!3\")\u0001\u000e\u0001C!S\")a\u000f\u0001C!o\"9\u0011\u0011\u0001\u0001\u0005\n\u0005\r\u0001bBA\u0011\u0001\u0011\u0005\u00131E\u0004\b\u0003[\u0001\u0002\u0012AA\u0018\r\u0019y\u0001\u0003#\u0001\u00022!1q\u0006\u0004C\u0001\u0003sAq!a\u000f\r\t\u0003\tiDA\u000bM_\u000e\fGNR5mKNK8\u000f^3n\u00072LWM\u001c;\u000b\u0005E\u0011\u0012!\u00027pG\u0006d'BA\n\u0015\u0003)1\u0017\u000e\\3tsN$X-\u001c\u0006\u0003+Y\t\u0011bY8o]\u0016\u001cGo\u001c:\u000b\u0003]\taA_3f]\u0016\f7\u0001A\n\u0004\u0001i\u0011\u0003CA\u000e!\u001b\u0005a\"BA\u000f\u001f\u0003\u0011a\u0017M\\4\u000b\u0003}\tAA[1wC&\u0011\u0011\u0005\b\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005\r\"S\"\u0001\n\n\u0005\u0015\u0012\"\u0001\u0005$jY\u0016\u001c\u0016p\u001d;f[\u000ec\u0017.\u001a8u\u00035IgN^3oi>\u0014\u0018PU8piB\u0011\u0001&L\u0007\u0002S)\u0011!fK\u0001\u0005M&dWM\u0003\u0002-=\u0005\u0019a.[8\n\u00059J#\u0001\u0002)bi\"\fa\u0001P5oSRtDCA\u00194!\t\u0011\u0004!D\u0001\u0011\u0011\u00151#\u00011\u0001(\u0003)!\u0017\r^3G_Jl\u0017\r^\u000b\u0002mA\u0011q\u0007P\u0007\u0002q)\u0011\u0011HO\u0001\u0007M>\u0014X.\u0019;\u000b\u0005mr\u0012\u0001\u0002;j[\u0016L!!\u0010\u001d\u0003#\u0011\u000bG/\u001a+j[\u00164uN]7biR,'/A\u0006eCR,gi\u001c:nCR\u0004\u0013!\u00037jgR\u0014vn\u001c;t)\u0005\t\u0005c\u0001\"H\u00136\t1I\u0003\u0002E\u000b\u0006!Q\u000f^5m\u0015\u00051\u0015!B:dC2\f\u0017B\u0001%D\u0005\r!&/\u001f\t\u0004\u0015J+fBA&Q\u001d\tau*D\u0001N\u0015\tq\u0005$\u0001\u0004=e>|GOP\u0005\u0002\r&\u0011\u0011+R\u0001\ba\u0006\u001c7.Y4f\u0013\t\u0019FK\u0001\u0004WK\u000e$xN\u001d\u0006\u0003#\u0016\u0003\"a\t,\n\u0005]\u0013\"\u0001\u0003$jY\u0016\u0004\u0016\r\u001e5\u0002\u00131L7\u000f\u001e$jY\u0016\u001cHc\u0001.bMB\u0019!iR.\u0011\u0007\rbf,\u0003\u0002^%\t\t2\t\\8tK\u0006\u0014G.Z%uKJ\fGo\u001c:\u0011\u0005\rz\u0016B\u00011\u0013\u0005=IE/Z7EKN\u001c'/\u001b9uS>t\u0007\"\u00022\u0007\u0001\u0004\u0019\u0017aA2uqB\u00111\u0005Z\u0005\u0003KJ\u0011a\u0002\u0016:bG&twmQ8oi\u0016DH\u000fC\u0003h\r\u0001\u0007Q+\u0001\u0003s_>$\u0018\u0001F5uK6\u001cv.\u001e:dKB\u0013x\u000e]3si&,7\u000fF\u0002kaF\u0004\"a\u001b8\u000e\u00031T!!\u001c\u000b\u0002\rM|WO]2f\u0013\tyGN\u0001\bQe>\u0004XM\u001d;z-\u0006dW/Z:\t\u000b\t<\u0001\u0019A2\t\u000bI<\u0001\u0019A:\u0002\r\u0019\u001c\u0018\n^3n!\t\u0019C/\u0003\u0002v%\tqa)\u001b7f'f\u001cH/Z7Ji\u0016l\u0017A\u0002:fC\u0012,'\u000f\u0006\u0002yyB\u0019!iR=\u0011\u0005\rR\u0018BA>\u0013\u0005Q1\u0015\u000e\\3TsN$X-\u001c$jY\u0016\u0014V-\u00193fe\")!\u0006\u0003a\u0001{B\u00111E`\u0005\u0003\u007fJ\u0011aBR5mKNK8\u000f^3n\r&dW-A\bg_Jl\u0017\r\u001e+j[\u0016\u001cH/Y7q)\u0011\t)!!\u0006\u0011\t\u0005\u001d\u0011q\u0002\b\u0005\u0003\u0013\tY\u0001\u0005\u0002M\u000b&\u0019\u0011QB#\u0002\rA\u0013X\rZ3g\u0013\u0011\t\t\"a\u0005\u0003\rM#(/\u001b8h\u0015\r\ti!\u0012\u0005\b\u0003/I\u0001\u0019AA\r\u0003\t!8\u000f\u0005\u0003\u0002\u001c\u0005uQ\"\u0001\u001e\n\u0007\u0005}!HA\u0004J]N$\u0018M\u001c;\u0002\u000b\rdwn]3\u0015\u0005\u0005\u0015\u0002\u0003BA\u0014\u0003Si\u0011!R\u0005\u0004\u0003W)%\u0001B+oSR\fQ\u0003T8dC24\u0015\u000e\\3TsN$X-\\\"mS\u0016tG\u000f\u0005\u00023\u0019M\u0019A\"a\r\u0011\t\u0005\u001d\u0012QG\u0005\u0004\u0003o)%AB!osJ+g\r\u0006\u0002\u00020\u0005)\u0011\r\u001d9msR\u0019\u0011'a\u0010\t\u000b\u0019r\u0001\u0019A\u0014")
public class LocalFileSystemClient
implements FileSystemClient {
    private final Path inventoryRoot;
    private final DateTimeFormatter dateFormat;

    public static LocalFileSystemClient apply(Path inventoryRoot) {
        return LocalFileSystemClient$.MODULE$.apply(inventoryRoot);
    }

    @Override
    public Try<InputStream> inputStream(FileSystemFile file) {
        return FileSystemClient.inputStream$(this, file);
    }

    public DateTimeFormatter dateFormat() {
        return this.dateFormat;
    }

    @Override
    public Try<Vector<FilePath>> listRoots() {
        return new Success(package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new FilePath[]{FilePath$.MODULE$.root()})));
    }

    @Override
    public Try<CloseableIterator<ItemDescription>> listFiles(String ctx, FilePath root) {
        Path rootPath = this.inventoryRoot.resolve(root.toString());
        return Try$.MODULE$.apply((Function0 & Serializable)() -> Files.walk(rootPath, new FileVisitOption[0])).map((Function1 & Serializable)stream -> CloseableIterator$.MODULE$.apply((Function0 & Serializable)() -> CollectionConverters$.MODULE$.IteratorHasAsScala(stream.iterator()).asScala().flatMap((Function1 & Serializable)path -> {
            FilePath filePath = FilePath$.MODULE$.apply($this.inventoryRoot.relativize((Path)path));
            return Try$.MODULE$.apply((Function0 & Serializable)() -> Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0])).map((Function1 & Serializable)attributes -> {
                if (attributes.isDirectory()) {
                    return new DirectoryDescription(filePath);
                }
                return new FileDescription(filePath, attributes.lastModifiedTime().toInstant(), attributes.size());
            }).toOption();
        }), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> stream.close()));
    }

    @Override
    public PropertyValues itemSourceProperties(String ctx, FileSystemItem fsItem) {
        String path = fsItem.path().toString();
        Path syspath = this.inventoryRoot.resolve(path);
        return PropertyValues$.MODULE$.from(Predef$.MODULE$.Map().from((IterableOnce)((StrictOptimizedIterableOps)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Option[]{new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)StandardTechnicalMetadata$.MODULE$.filePath()), (Object)SourceStringPropertyValue$.MODULE$.apply(((Object)syspath).toString()))), new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)StandardTechnicalMetadata$.MODULE$.updated()), (Object)SourceStringPropertyValue$.MODULE$.apply(this.formatTimestamp(fsItem.timestamp())))), Try$.MODULE$.apply((Function0 & Serializable)() -> Files.readAttributes(syspath, BasicFileAttributes.class, new LinkOption[0])).map((Function1 & Serializable)attr -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)StandardTechnicalMetadata$.MODULE$.created()), (Object)SourceStringPropertyValue$.MODULE$.apply(this.formatTimestamp(attr.creationTime().toInstant())))).toOption(), Try$.MODULE$.apply((Function0 & Serializable)() -> Files.getOwner(syspath, new LinkOption[0])).map((Function1 & Serializable)x$1 -> x$1.getName()).map((Function1 & Serializable)value -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)StandardTechnicalMetadata$.MODULE$.owner()), (Object)SourceStringPropertyValue$.MODULE$.apply(value))).toOption()}))).flatten(Predef$.MODULE$.$conforms())), PropertyValues$.MODULE$.from$default$2());
    }

    @Override
    public Try<FileSystemFileReader> reader(FileSystemFile file) {
        Path p = this.inventoryRoot.resolve(file.path().toString());
        return Try$.MODULE$.apply((Function0 & Serializable)() -> Files.newByteChannel(p, new OpenOption[0])).map((Function1 & Serializable)channel -> new LocalFileSystemFileReader((SeekableByteChannel)channel));
    }

    private String formatTimestamp(Instant ts) {
        return this.dateFormat().format(ts.atZone(ZoneOffset.UTC));
    }

    @Override
    public void close() {
    }

    public LocalFileSystemClient(Path inventoryRoot) {
        this.inventoryRoot = inventoryRoot;
        FileSystemClient.$init$(this);
        this.dateFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    }
}

