/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.filesystem.io;

import java.io.InputStream;
import java.io.PushbackInputStream;
import java.io.Serializable;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipInputStream;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.math.package$;
import scala.util.ChainingOps$;
import scala.util.Try;
import scala.util.Try$;
import scala.util.package;

public final class CompressionUtils$ {
    public static final CompressionUtils$ MODULE$ = new CompressionUtils$();
    private static final byte[] gzipMagicNumber = new byte[]{(byte)31, (byte)139, (byte)8};
    private static final byte[] zipMagicNumber = new byte[]{(byte)80, (byte)75, (byte)3, (byte)4};
    private static final int maxMagicLen = package$.MODULE$.max(MODULE$.gzipMagicNumber().length, MODULE$.zipMagicNumber().length);

    private byte[] gzipMagicNumber() {
        return gzipMagicNumber;
    }

    private byte[] zipMagicNumber() {
        return zipMagicNumber;
    }

    private int maxMagicLen() {
        return maxMagicLen;
    }

    public Try<InputStream> decompressStream(InputStream inputStream) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            byte[] signature;
            PushbackInputStream pb = new PushbackInputStream(inputStream, MODULE$.maxMagicLen());
            int len = pb.read(signature = new byte[MODULE$.maxMagicLen()]);
            if (len > 0) {
                pb.unread(signature, 0, len);
            }
            if (MODULE$.matches(signature, len, MODULE$.gzipMagicNumber())) {
                return new GZIPInputStream(pb);
            }
            if (MODULE$.matches(signature, len, MODULE$.zipMagicNumber())) {
                return (InputStream)ChainingOps$.MODULE$.tap$extension(package.chaining$.MODULE$.scalaUtilChainingOps((Object)new ZipInputStream(pb)), (Function1 & Serializable)x$1 -> x$1.getNextEntry());
            }
            return pb;
        });
    }

    private boolean matches(byte[] signature, int len, byte[] magic) {
        if (len >= magic.length) {
            return ArrayOps$.MODULE$.startsWith$extension(Predef$.MODULE$.byteArrayOps(signature), (Object)magic);
        }
        return false;
    }

    private CompressionUtils$() {
    }
}

